/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.db2.editors.DB2StatefulObject;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.ext.db2.model.DB2Index;
import org.jkiss.dbeaver.ext.db2.model.DB2MaterializedQueryTable;
import org.jkiss.dbeaver.ext.db2.model.DB2Schema;
import org.jkiss.dbeaver.ext.db2.model.DB2Table;
import org.jkiss.dbeaver.ext.db2.model.DB2TableColumn;
import org.jkiss.dbeaver.ext.db2.model.DB2TableForeignKey;
import org.jkiss.dbeaver.ext.db2.model.DB2TableReference;
import org.jkiss.dbeaver.ext.db2.model.DB2TableUniqueKey;
import org.jkiss.dbeaver.ext.db2.model.DB2Trigger;
import org.jkiss.dbeaver.ext.db2.model.DB2View;
import org.jkiss.dbeaver.ext.db2.model.cache.DB2TableIndexCache;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2OwnerType;
import org.jkiss.dbeaver.ext.db2.model.fed.DB2Nickname;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.utils.CommonUtils;

public abstract class DB2TableBase
extends JDBCTable<DB2DataSource, DB2Schema>
implements DBPNamedObject2,
DBPRefreshableObject,
DB2StatefulObject {
    private DB2TableIndexCache tableIndexCache = new DB2TableIndexCache();
    private String owner;
    private DB2OwnerType ownerType;
    private Integer tableId;
    private Timestamp createTime;
    private String remarks;

    public DB2TableBase(DBRProgressMonitor monitor, DB2Schema schema, ResultSet dbResult) {
        super((DBSObjectContainer)schema, true);
        this.setName(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABNAME"));
        DB2DataSource db2DataSource = schema.getDataSource();
        this.owner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OWNER");
        this.tableId = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"TABLEID");
        this.createTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CREATE_TIME");
        this.remarks = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"REMARKS");
        if (db2DataSource.isAtLeastV9_5()) {
            this.ownerType = (DB2OwnerType)CommonUtils.valueOf(DB2OwnerType.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OWNERTYPE"));
        }
    }

    public DB2TableBase(DB2Schema container, String name, Boolean persisted) {
        super((DBSObjectContainer)container, name, persisted.booleanValue());
    }

    public void refreshObjectState(@NotNull DBRProgressMonitor monitor) throws DBCException {
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getSchema(), this});
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.tableIndexCache.clearCache();
        for (DB2Index index : new ArrayList(((DB2Schema)this.getContainer()).getIndexCache().getCachedObjects())) {
            if (index.getTable() != this) continue;
            ((DB2Schema)this.getContainer()).getIndexCache().removeObject((DBSObject)index, true);
        }
        for (DB2Trigger trigger : new ArrayList(((DB2Schema)this.getContainer()).getTriggerCache().getCachedObjects())) {
            if (trigger.getTable() != this) continue;
            ((DB2Schema)this.getContainer()).getTriggerCache().removeObject(trigger, true);
        }
        return this;
    }

    public Collection<DB2TableColumn> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this instanceof DB2Table) {
            return ((DB2Schema)this.getContainer()).getTableCache().getChildren(monitor, (DB2Schema)this.getContainer(), (DB2Table)this);
        }
        if (this instanceof DB2Nickname) {
            return ((DB2Schema)this.getContainer()).getNicknameCache().getChildren(monitor, (DB2Schema)this.getContainer(), (DB2Nickname)this);
        }
        if (this instanceof DB2MaterializedQueryTable) {
            return ((DB2Schema)this.getContainer()).getMaterializedQueryTableCache().getChildren(monitor, (DB2Schema)this.getContainer(), (DB2MaterializedQueryTable)this);
        }
        if (this instanceof DB2View) {
            return ((DB2Schema)this.getContainer()).getViewCache().getChildren(monitor, (DB2Schema)this.getContainer(), (DB2View)this);
        }
        throw new DBException("Unknown object with columns encountered");
    }

    public DB2TableColumn getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) throws DBException {
        if (this instanceof DB2Table) {
            return (DB2TableColumn)((DB2Schema)this.getContainer()).getTableCache().getChild(monitor, (DB2Schema)this.getContainer(), (DB2Table)this, attributeName);
        }
        if (this instanceof DB2Nickname) {
            return (DB2TableColumn)((DB2Schema)this.getContainer()).getNicknameCache().getChild(monitor, (DB2Schema)this.getContainer(), (DB2Nickname)this, attributeName);
        }
        if (this instanceof DB2MaterializedQueryTable) {
            return (DB2TableColumn)((DB2Schema)this.getContainer()).getMaterializedQueryTableCache().getChild(monitor, (DB2Schema)this.getContainer(), (DB2MaterializedQueryTable)this, attributeName);
        }
        if (this instanceof DB2View) {
            return (DB2TableColumn)((DB2Schema)this.getContainer()).getViewCache().getChild(monitor, (DB2Schema)this.getContainer(), (DB2View)this, attributeName);
        }
        throw new DBException("Unknown object with columns encountered");
    }

    @Association
    public Collection<DB2Index> getIndexes(DBRProgressMonitor monitor) throws DBException {
        return this.tableIndexCache.getAllObjects(monitor, this);
    }

    @Nullable
    public Collection<DB2TableUniqueKey> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        return Collections.emptyList();
    }

    public Collection<DB2TableForeignKey> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        return Collections.emptyList();
    }

    public Collection<DB2TableReference> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
        return Collections.emptyList();
    }

    @Property(viewable=true, editable=false, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return super.getName();
    }

    @Override
    @Property(viewable=true, editable=false, order=2)
    public DB2Schema getSchema() {
        return (DB2Schema)super.getContainer();
    }

    @Property(viewable=false, editable=false, order=100, category="Date & Time")
    public Timestamp getCreateTime() {
        return this.createTime;
    }

    @Property(viewable=false, editable=false, category="Owner")
    public String getOwner() {
        return this.owner;
    }

    @Property(viewable=false, editable=false, category="Owner")
    public DB2OwnerType getOwnerType() {
        return this.ownerType;
    }

    @Property(viewable=true, order=98)
    public Integer getTableId() {
        return this.tableId;
    }

    @Property(viewable=false, order=99, editable=true, updatable=true)
    @Nullable
    public String getDescription() {
        return this.remarks;
    }

    public void setDescription(String description) {
        this.remarks = description;
    }
}

