/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.ext.db2.model.DB2GlobalObject;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2YesNo;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;

public class DB2StorageGroup
extends DB2GlobalObject
implements DBPNamedObject {
    private String name;
    private Integer id;
    private String owner;
    private Timestamp createTime;
    private Boolean defautSG;
    private Double overhead;
    private Double deviceReadRate;
    private Double writeOverhead;
    private Double deviceWriteRate;
    private Integer dataTag;
    private String cachingTier;
    private String remarks;

    public DB2StorageGroup(DB2DataSource db2DataSource, ResultSet dbResult) throws DBException {
        super(db2DataSource, dbResult != null);
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SGNAME");
        this.id = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"SGID");
        this.owner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OWNER");
        this.createTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CREATE_TIME");
        this.defautSG = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"DEFAULTSG", (String)DB2YesNo.Y.name());
        this.overhead = JDBCUtils.safeGetDouble((ResultSet)dbResult, (String)"OVERHEAD");
        this.deviceReadRate = JDBCUtils.safeGetDouble((ResultSet)dbResult, (String)"DEVICEREADRATE");
        this.writeOverhead = JDBCUtils.safeGetDouble((ResultSet)dbResult, (String)"WRITEOVERHEAD");
        this.deviceWriteRate = JDBCUtils.safeGetDouble((ResultSet)dbResult, (String)"DEVICEWRITERATE");
        this.dataTag = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"DATATAG");
        this.remarks = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"REMARKS");
        if (db2DataSource.isAtLeastV10_5()) {
            this.cachingTier = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CACHINGTIER");
        }
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=2)
    public Integer getId() {
        return this.id;
    }

    @Property(viewable=true, order=3)
    public Boolean getDefautSG() {
        return this.defautSG;
    }

    @Property(viewable=false, category="Owner")
    public String getOwner() {
        return this.owner;
    }

    @Property(viewable=false, category="Date & Time")
    public Timestamp getCreateTime() {
        return this.createTime;
    }

    @Property(viewable=false)
    public String getCachingTier() {
        return this.cachingTier;
    }

    @Property(viewable=false)
    public Integer getDataTag() {
        return this.dataTag;
    }

    @Override
    @Property(viewable=false)
    @Nullable
    public String getDescription() {
        return this.remarks;
    }

    @Property(viewable=false, order=100, category="Performance")
    public Double getOverhead() {
        return this.overhead;
    }

    @Property(viewable=false, order=101, category="Performance")
    public Double getDeviceReadRate() {
        return this.deviceReadRate;
    }

    @Property(viewable=false, order=102, category="Performance")
    public Double getWriteOverhead() {
        return this.writeOverhead;
    }

    @Property(viewable=false, order=103, category="Performance")
    public Double getDeviceWriteRate() {
        return this.deviceWriteRate;
    }
}

