/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mockdata.adv.generator;

import java.io.IOException;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mockdata.MockDataUtils;
import org.jkiss.dbeaver.ext.mockdata.generator.AbstractMockValueGenerator;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.utils.CommonUtils;

public class StringPriceGenerator
extends AbstractMockValueGenerator {
    private String country = "UK";
    private Locale locale = Locale.UK;
    private double min = 0.0;
    private double max = 1000.0;

    public void init(DBSDataManipulator dBSDataManipulator, DBSAttributeBase dBSAttributeBase, Map<Object, Object> map) throws DBException {
        Double d;
        block30: {
            super.init(dBSDataManipulator, dBSAttributeBase, map);
            String string = (String)map.get("country");
            if (CommonUtils.isEmpty((String)string)) break block30;
            this.country = string;
            switch (string) {
                case "China": {
                    this.locale = Locale.CHINA;
                    break;
                }
                case "France": {
                    this.locale = Locale.FRANCE;
                    break;
                }
                case "Germany": {
                    this.locale = Locale.GERMANY;
                    break;
                }
                case "Italy": {
                    this.locale = Locale.ITALY;
                    break;
                }
                case "Japan": {
                    this.locale = Locale.JAPAN;
                    break;
                }
                case "Russia": {
                    this.locale = new Locale("ru", "RU");
                    break;
                }
                case "UK": {
                    this.locale = Locale.UK;
                    break;
                }
                case "USA": {
                    this.locale = Locale.US;
                }
            }
        }
        if ((d = (Double)map.get("min")) != null) {
            this.min = d;
        }
        if ((d = (Double)map.get("max")) != null) {
            this.max = d;
        }
    }

    protected Object generateOneValue(DBRProgressMonitor dBRProgressMonitor) throws DBException, IOException {
        if (this.isGenerateNULL()) {
            return null;
        }
        return this.formatCurrency(MockDataUtils.getRandomDouble((double)this.min, (double)this.max, (Random)this.random));
    }

    private String formatCurrency(double d) {
        NumberFormat numberFormat = NumberFormat.getCurrencyInstance(this.locale);
        return this.correct(numberFormat.format(d));
    }

    public String correct(String string) {
        int n = string.length();
        if (string.lastIndexOf(44) == n - 1 || string.lastIndexOf(44) == n - 1) {
            return String.valueOf(string) + '0';
        }
        if (string.endsWith(".00") || string.endsWith(",00")) {
            return string.substring(0, n - 3);
        }
        return string;
    }
}

