/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mockdata.adv.generator;

import com.dbeaver.ee.mockdata.adv.generator.AdvancedAbstractMockValueGenerator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;

public class StringNameGenerator
extends AdvancedAbstractMockValueGenerator {
    private static final Log log = Log.getLog(StringNameGenerator.class);
    protected static List<String> MALE_NAMES;
    protected static List<String> FEMALE_NAMES;
    protected static List<String> SURNAMES;
    protected static int maleNames;
    protected static int femaleNames;
    protected static int allNames;
    protected static int surnames;
    private GENDER gender = GENDER.ALL;
    protected boolean withSurnames = false;

    public void init(DBSDataManipulator dBSDataManipulator, DBSAttributeBase dBSAttributeBase, Map<Object, Object> map) throws DBException {
        Boolean bl;
        super.init(dBSDataManipulator, dBSAttributeBase, map);
        String string = (String)map.get("gender");
        if (string != null) {
            this.gender = GENDER.valueOf(string);
        }
        if ((bl = (Boolean)map.get("withSurnames")) != null) {
            this.withSurnames = bl;
        }
    }

    public Object generateOneValue(DBRProgressMonitor dBRProgressMonitor) throws DBException, IOException {
        String string;
        if (allNames == 0) {
            MALE_NAMES = this.readDict("names_male_en.txt");
            FEMALE_NAMES = this.readDict("names_female_en.txt");
            SURNAMES = this.readDict("surnames_en.txt");
            maleNames = MALE_NAMES.size();
            femaleNames = FEMALE_NAMES.size();
            surnames = SURNAMES.size();
            allNames = femaleNames + maleNames;
        }
        if (this.isGenerateNULL()) {
            return null;
        }
        switch (this.gender) {
            case MALE: {
                string = MALE_NAMES.get(this.random.nextInt(maleNames));
                break;
            }
            case FEMALE: {
                string = FEMALE_NAMES.get(this.random.nextInt(femaleNames));
                break;
            }
            default: {
                int n = this.random.nextInt(allNames);
                string = n < maleNames ? MALE_NAMES.get(n) : FEMALE_NAMES.get(n - maleNames);
            }
        }
        if (this.withSurnames) {
            string = String.valueOf(string) + " " + SURNAMES.get(this.random.nextInt(surnames));
        }
        return string;
    }

    private static enum GENDER {
        ALL,
        FEMALE,
        MALE;

    }
}

