/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.lm.ui;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.runtime.WebUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.lm.LMLicense;
import org.jkiss.lm.LMLicenseManager;
import org.jkiss.lm.LMProduct;
import org.jkiss.lm.LMValidateException;

public class LicenseMissingDialog
extends IconAndMessageDialog {
    public static final int IMPORT_BUTTON_ID = 1000;
    public static final int TRIAL_BUTTON_ID = 1001;
    public static final int LM_BUTTON_ID = 1002;
    private final LMLicenseManager licenseManager;
    private final LMProduct product;

    public LicenseMissingDialog(Shell parentShell, LMLicenseManager licenseManager, LMProduct product) {
        super(parentShell);
        this.licenseManager = licenseManager;
        this.product = product;
        try {
            LMLicense trialLicense = licenseManager.findTrialLicense(product);
            this.message = "License for '" + product.getName() + "' " + (trialLicense == null ? "not found" : "has expired") + ".\nYou need to import a valid license or obtain a new one.";
        }
        catch (LMValidateException e) {
            this.message = "License validation error.\n" + e.getMessage();
        }
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        String errorMassage;
        try {
            LMLicense license = this.licenseManager.getValidProductLicense(this.product);
            errorMassage = license == null ? "No License" : "License has expired";
        }
        catch (LMValidateException e) {
            errorMassage = e.getMessage();
        }
        this.getShell().setText(errorMassage);
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite msgPlaceholder = UIUtils.createPlaceholder((Composite)composite, (int)2, (int)5);
        super.createMessageArea(msgPlaceholder);
        Group licenseGroup = UIUtils.createControlGroup((Composite)composite, (String)"License", (int)2, (int)1808, (int)0);
        Text productText = UIUtils.createLabelText((Composite)licenseGroup, (String)"Product", (String)(String.valueOf(this.product.getName()) + " " + this.product.getVersion()), (int)2056);
        productText.setLayoutData((Object)new GridData(768));
        Link label = new Link((Composite)licenseGroup, 0);
        LMLicense[] productLicenses = this.licenseManager.getProductLicenses(this.product);
        if (productLicenses.length == 0) {
            label.setText("License not found.\nIf you have product license then you can import it by pressing the Import button.\nYou can buy a license on DBeaver <a href=\"buy\">web site</a> or you can use trial license.");
        } else {
            String statusText;
            Arrays.sort(productLicenses, new Comparator<LMLicense>(){

                @Override
                public int compare(LMLicense o1, LMLicense o2) {
                    return o1.getLicenseEndTime() == null ? -1 : (o2.getLicenseEndTime() == null ? 1 : o1.getLicenseEndTime().compareTo(o2.getLicenseEndTime()));
                }
            });
            LMLicense lastLicense = productLicenses[productLicenses.length - 1];
            try {
                this.licenseManager.validateLicense(this.product, lastLicense);
                statusText = "License has expired.\nLicense " + lastLicense.getLicenseId() + " has expired at " + lastLicense.getLicenseEndTime() + ".\n" + "You can buy a license on DBeaver <a href=\"buy\">web site</a> and then import it.";
            }
            catch (Exception e) {
                statusText = "License is invalid.\nLicense " + lastLicense.getLicenseId() + " is invalid:\n" + e.getMessage();
            }
            label.setText(statusText);
        }
        label.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebUtils.openWebBrowser((String)"https://dbeaver.com/trial");
            }
        });
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button button = this.createButton(parent, 1002, "License Manager", true);
        button.setLayoutData((Object)new GridData(768));
        this.createButton(parent, 1000, "Import License", true);
        this.createButton(parent, 1001, "Trial", false);
        this.createButton(parent, 1, "Exit", false);
    }

    protected Image getImage() {
        return this.getErrorImage();
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1002: {
                this.setReturnCode(1002);
                this.close();
                return;
            }
            case 1000: {
                this.setReturnCode(1000);
                this.close();
                return;
            }
            case 1001: {
                try {
                    if (this.licenseManager.findTrialLicense(this.product) == null) {
                        this.setReturnCode(1001);
                        this.close();
                    } else {
                        MessageBox messageBox = new MessageBox(this.getShell(), 1);
                        messageBox.setText("Can't generate trial license");
                        messageBox.setMessage("You can't generate second trial license. Old one has expired");
                        messageBox.open();
                    }
                }
                catch (LMValidateException e) {
                    DBeaverUI.getInstance().showError("Error reading trial license", "Bad trial license", (Throwable)e);
                }
                return;
            }
        }
        super.buttonPressed(buttonId);
    }
}

