/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime.internal.ide.ui.handlers;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.runtime.ide.core.WorkspaceResources;
import org.jkiss.dbeaver.runtime.ide.ui.handlers.CreateLinkHandler;

public class LinkFileHandler
extends CreateLinkHandler {
    private static final String COMMAND_PARAMETER_LINK_FILE_CONTENTTYPE = "org.jkiss.dbeaver.core.resource.link.file.contenttype";

    @Override
    protected Path[] selectTargets(ExecutionEvent event) {
        String file;
        IContentType contentType;
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        FileDialog dialog = new FileDialog(shell, 2);
        String contentTypeId = event.getParameter(COMMAND_PARAMETER_LINK_FILE_CONTENTTYPE);
        if (contentTypeId != null && (contentType = Platform.getContentTypeManager().getContentType(contentTypeId)) != null) {
            String[] fileSpecs;
            StringBuilder sb = new StringBuilder();
            String[] stringArray = fileSpecs = contentType.getFileSpecs(8);
            int n = fileSpecs.length;
            int n2 = 0;
            while (n2 < n) {
                String extension = stringArray[n2];
                if (sb.length() > 0) {
                    sb.append(';');
                }
                sb.append('*').append('.').append(extension);
                ++n2;
            }
            if (sb.length() > 0) {
                String[] names = new String[]{contentType.getName()};
                String[] extensions = new String[]{sb.toString()};
                dialog.setFilterNames(names);
                dialog.setFilterExtensions(extensions);
            }
        }
        if ((file = dialog.open()) == null) {
            return NO_TARGETS;
        }
        ArrayList<Path> paths = new ArrayList<Path>();
        String filterPath = dialog.getFilterPath();
        String[] fileNames = dialog.getFileNames();
        int i = 0;
        while (i < fileNames.length) {
            String fileName = fileNames[i];
            Path filePath = Paths.get(filterPath, fileName);
            paths.add(filePath);
            ++i;
        }
        return paths.toArray(new Path[paths.size()]);
    }

    @Override
    protected IStatus createLink(IContainer container, IProgressMonitor monitor, Path ... targets) {
        return WorkspaceResources.createLinkedFiles((IContainer)container, (IProgressMonitor)monitor, (Path[])targets);
    }
}

