/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.ui.locks.manage;

import java.util.Collection;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.ext.ui.locks.graph.LockGraphicalView;
import org.jkiss.dbeaver.ext.ui.locks.manage.LockGraphManager;
import org.jkiss.dbeaver.ext.ui.locks.table.LockTable;
import org.jkiss.dbeaver.ext.ui.locks.table.LockTableDetail;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.admin.locks.DBAServerLock;
import org.jkiss.dbeaver.model.admin.locks.DBAServerLockItem;
import org.jkiss.dbeaver.model.admin.locks.DBAServerLockManager;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.autorefresh.AutoRefreshControl;

public class LockManagerViewer {
    public static final String keyType = "type";
    public static final String typeWait = "wait";
    public static final String typeHold = "hold";
    private Font boldFont;
    private LockListControl lockTable;
    private LockTableDetail blockedTable;
    private LockTableDetail blockingTable;
    private Label blockedLabel;
    private Label blockingLabel;
    private DBAServerLock curLock;
    private LockGraphManager graphManager;
    private LockGraphicalView gv;
    private AutoRefreshControl refreshControl;
    private Action killAction = new Action("Kill waiting session", UIUtils.getShardImageDescriptor((String)"IMG_ELCL_STOP")){

        public void run() {
            if (LockManagerViewer.this.curLock != null) {
                DBAServerLock root = LockManagerViewer.this.graphManager.getGraph(LockManagerViewer.this.curLock).getLockRoot();
                LockManagerViewer.this.alterSession();
                LockManagerViewer.this.refreshLocks(root);
                LockManagerViewer.this.setTableLockSelect(root);
            }
        }
    };

    public LockGraphManager getGraphManager() {
        return this.graphManager;
    }

    public void dispose() {
        this.lockTable.disposeControl();
        UIUtils.dispose((Resource)this.boldFont);
    }

    protected LockManagerViewer(IWorkbenchPart part, Composite parent, DBAServerLockManager<DBAServerLock, DBAServerLockItem> lockManager) {
        this.refreshControl = new AutoRefreshControl((Control)parent, lockManager.getClass().getSimpleName(), monitor -> DBeaverUI.syncExec(() -> this.refreshLocks(null)));
        this.graphManager = (LockGraphManager)lockManager;
        this.boldFont = UIUtils.makeBoldFont((Font)parent.getFont());
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1);
        SashForm sashMain = UIUtils.createPartDivider((IWorkbenchPart)part, (Composite)composite, (int)65792);
        sashMain.setLayoutData((Object)new GridData(1808));
        SashForm sash = UIUtils.createPartDivider((IWorkbenchPart)part, (Composite)sashMain, (int)66048);
        sash.setLayoutData((Object)new GridData(1808));
        this.lockTable = new LockListControl(sash, (IWorkbenchSite)part.getSite(), lockManager, lockManager.getLocksType());
        this.lockTable.createProgressPanel(composite);
        this.lockTable.getItemsViewer().addSelectionChangedListener(event -> this.onLockSelect(this.getSelectedLock()));
        this.lockTable.loadData();
        SashForm infoSash = UIUtils.createPartDivider((IWorkbenchPart)part, (Composite)sash, (int)65792);
        infoSash.setLayoutData((Object)new GridData(1808));
        Composite cBlocked = UIUtils.createPlaceholder((Composite)infoSash, (int)1, (int)5);
        this.blockedLabel = new Label(cBlocked, 0);
        this.blockedLabel.setLayoutData((Object)new GridData(768));
        this.blockedLabel.setFont(this.boldFont);
        this.blockedTable = new LockTableDetail(cBlocked, 0x10000000, (IWorkbenchSite)part.getSite(), lockManager);
        this.blockedTable.setLayoutData(new GridData(1808));
        Composite cBlocking = UIUtils.createPlaceholder((Composite)infoSash, (int)1, (int)5);
        this.blockingLabel = new Label(cBlocking, 0);
        this.blockingLabel.setLayoutData((Object)new GridData(768));
        this.blockingLabel.setFont(this.boldFont);
        this.blockingTable = new LockTableDetail(cBlocking, 0x10000000, (IWorkbenchSite)part.getSite(), lockManager);
        this.blockingTable.setLayoutData(new GridData(1808));
        this.gv = new LockGraphicalView(this);
        this.gv.createPartControl((Composite)sashMain);
        sashMain.setWeights(new int[]{3, 1});
        sash.setWeights(new int[]{4, 1});
    }

    protected void onLockSelect(DBAServerLock lock) {
        this.curLock = lock;
        this.refreshGraph(this.curLock);
    }

    public void setTableLockSelect(DBAServerLock lock) {
        ColumnViewer itemsViewer = this.lockTable.getItemsViewer();
        itemsViewer.getControl().setRedraw(false);
        try {
            itemsViewer.setSelection((ISelection)new StructuredSelection((Object)lock), true);
        }
        finally {
            itemsViewer.getControl().setRedraw(true);
        }
        this.curLock = lock;
    }

    protected void contributeToToolbar(DBAServerLockManager<DBAServerLock, DBAServerLockItem> sessionManager, IContributionManager contributionManager) {
    }

    public Action getKillAction() {
        return this.killAction;
    }

    private DBAServerLock getSelectedLock() {
        ISelection selection = this.lockTable.getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            return (DBAServerLock)((IStructuredSelection)selection).getFirstElement();
        }
        return null;
    }

    private void refreshGraph(DBAServerLock selected) {
        this.gv.drawGraf(selected);
    }

    public void refreshLocks(DBAServerLock selected) {
        this.lockTable.loadData(false);
        this.gv.drawGraf(selected);
        this.refreshControl.scheduleAutoRefresh(false);
    }

    protected void refreshDetail(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder("Wait - ");
        sb.append(this.curLock.getTitle());
        this.blockedLabel.setText(sb.toString());
        this.blockedTable.getOptions().putAll(options);
        this.blockedTable.getOptions().put(keyType, typeWait);
        this.blockedTable.loadData(false);
        sb.setLength(0);
        if (this.curLock.getHoldBy() != null) {
            sb.append("Hold - ");
            sb.append(this.curLock.getHoldBy().getTitle());
            this.blockingLabel.setText(sb.toString());
        }
        this.blockingTable.getOptions().putAll(options);
        this.blockingTable.getOptions().put(keyType, typeHold);
        this.blockingTable.loadData();
    }

    public void alterSession() {
        if (UIUtils.confirmAction((String)"Terminate", (String)NLS.bind((String)"Terminate session?", (Object)"Terminate"))) {
            this.lockTable.createAlterService(this.curLock, null).schedule();
        }
    }

    public Composite getControl() {
        return this.lockTable.getControl();
    }

    private class LockListControl
    extends LockTable {
        private Class<DBAServerLock> locksType;

        LockListControl(SashForm sash, IWorkbenchSite site, DBAServerLockManager<DBAServerLock, DBAServerLockItem> lockManager, Class<DBAServerLock> locksType) {
            super((Composite)sash, 0x10000000, site, lockManager);
            this.locksType = locksType;
        }

        @Nullable
        protected Class[] getListBaseTypes(Collection<DBAServerLock> items) {
            return new Class[]{this.locksType};
        }

        protected void fillCustomActions(IContributionManager contributionManager) {
            LockManagerViewer.this.contributeToToolbar(this.getLockManager(), contributionManager);
            contributionManager.add((IAction)LockManagerViewer.this.killAction);
            contributionManager.add((IContributionItem)new Separator());
            LockManagerViewer.this.refreshControl.populateRefreshButton(contributionManager);
            contributionManager.add((IAction)new Action("Refresh locks", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.REFRESH)){

                public void run() {
                    LockManagerViewer.this.refreshLocks(LockManagerViewer.this.curLock);
                }
            });
        }
    }
}

