/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.firebird.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.firebird.model.FireBirdDataType;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class FireBirdTableColumn
extends GenericTableColumn {
    private String domainTypeName;
    private FireBirdDataType dataType;

    public FireBirdTableColumn(GenericTable table) {
        super(table);
    }

    public FireBirdTableColumn(JDBCSession session, GenericTable table, String columnName, String typeName, int valueType, int sourceType, int ordinalPosition, long columnSize, long charLength, Integer scale, Integer precision, int radix, boolean notNull, String remarks, String defaultValue, boolean autoIncrement, boolean autoGenerated) throws DBException {
        super(table, columnName, typeName, valueType, sourceType, ordinalPosition, columnSize, charLength, scale, precision, radix, notNull, remarks, defaultValue, autoIncrement, autoGenerated);
        if (typeName.equals("CHAR") || typeName.equals("VARCHAR")) {
            this.getDomainTypeName(session.getProgressMonitor());
        }
        this.dataType = this.domainTypeName != null ? (FireBirdDataType)((GenericDataSource)table.getDataSource()).getLocalDataType(this.domainTypeName) : (FireBirdDataType)((GenericDataSource)table.getDataSource()).getLocalDataType(typeName);
    }

    public DBPDataKind getDataKind() {
        return this.dataType == null ? super.getDataKind() : this.dataType.getDataKind();
    }

    @Property(order=21)
    public String getDomainTypeName(DBRProgressMonitor monitor) throws DBException {
        if (this.domainTypeName == null) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this.getDataSource(), (String)"Read column domain type");){
                    Throwable throwable2 = null;
                    Object var6_10 = null;
                    try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT RF.RDB$FIELD_SOURCE FROM RDB$RELATION_FIELDS RF WHERE RF.RDB$RELATION_NAME=? AND RF.RDB$FIELD_NAME=?");){
                        dbStat.setString(1, ((GenericTable)this.getTable()).getName());
                        dbStat.setString(2, this.getName());
                        Throwable throwable3 = null;
                        Object var9_15 = null;
                        try (JDBCResultSet dbResult = dbStat.executeQuery();){
                            if (dbResult.next()) {
                                this.domainTypeName = JDBCUtils.safeGetString((ResultSet)dbResult, (int)1);
                                if (this.domainTypeName != null) {
                                    this.domainTypeName = this.domainTypeName.trim();
                                }
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                    } else if (throwable != throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    throw throwable;
                }
            }
            catch (SQLException ex) {
                throw new DBException("Error reading column domain type", (Throwable)ex);
            }
        }
        return this.domainTypeName;
    }

    @Property(order=22, viewable=true)
    public String getCharset() throws DBException {
        if (this.dataType != null) {
            return this.dataType.getCharsetName();
        }
        return null;
    }
}

