/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.runtime.core;

import com.dbeaver.ee.runtime.core.DBeaverEnterpriseCoreActivator;
import java.nio.file.Path;
import java.util.Properties;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.impl.app.BaseWorkspaceImpl;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public final class DBeaverEnterprisePreferences {
    private static final Log log = Log.getLog(DBeaverEnterprisePreferences.class);
    public static final String SECURITY_USE_SECURE_PASSWORDS_STORAGE = "security.secure.password.storage";

    public static IEclipsePreferences getPreferences() {
        return DBeaverEnterpriseCoreActivator.getDefault().getPreferences();
    }

    public static boolean useSecurePreferences() {
        boolean useAdvSecurity;
        Path metadataFolder = GeneralUtils.getMetadataFolder();
        Properties props = BaseWorkspaceImpl.readWorkspaceInfo((Path)metadataFolder);
        String securityProperty = props.getProperty(SECURITY_USE_SECURE_PASSWORDS_STORAGE);
        DBeaverEnterpriseCoreActivator coreActivator = DBeaverEnterpriseCoreActivator.getDefault();
        if (CommonUtils.isNotEmpty((String)securityProperty)) {
            IEclipsePreferences preferences = DBeaverEnterprisePreferences.getPreferences();
            useAdvSecurity = CommonUtils.toBoolean((Object)securityProperty);
            preferences.putBoolean(SECURITY_USE_SECURE_PASSWORDS_STORAGE, useAdvSecurity);
        } else {
            useAdvSecurity = coreActivator.getPreferences().getBoolean(SECURITY_USE_SECURE_PASSWORDS_STORAGE, false);
            if (!useAdvSecurity && (useAdvSecurity = coreActivator.getLegacyPrefs().getBoolean(SECURITY_USE_SECURE_PASSWORDS_STORAGE, false))) {
                coreActivator.getPreferences().putBoolean(SECURITY_USE_SECURE_PASSWORDS_STORAGE, true);
                try {
                    coreActivator.getPreferences().flush();
                }
                catch (Exception e) {
                    log.debug((Object)e);
                }
                coreActivator.getLegacyPrefs().remove(SECURITY_USE_SECURE_PASSWORDS_STORAGE);
                try {
                    coreActivator.getLegacyPrefs().flush();
                }
                catch (Exception e) {
                    log.debug((Object)e);
                }
            }
        }
        return useAdvSecurity;
    }
}

