/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.timestream.model;

import com.dbeaver.net.auth.aws.AuthModelAWSAbstract;
import com.dbeaver.net.auth.aws.AuthModelAWSCredentials;
import com.dbeaver.net.auth.aws.AuthModelAWSSimpleCredentials;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;

public class AuthModelAWSTimestream
extends AuthModelAWSAbstract {
    public static final String ID = "aws_timestream";

    @NotNull
    public AuthModelAWSCredentials createCredentials() {
        return new AuthModelAWSSimpleCredentials();
    }

    public Object initAuthentication(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull AuthModelAWSCredentials credentials, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) throws DBException {
        String sessionToken;
        AwsCredentials awsCredentials = credentials.getAuthCredentialsProvider(monitor).resolveCredentials();
        if (!CommonUtils.isEmpty((String)awsCredentials.accessKeyId())) {
            connProperties.put("AccessKeyId", awsCredentials.accessKeyId());
        }
        if (!CommonUtils.isEmpty((String)awsCredentials.secretAccessKey())) {
            connProperties.put("SecretAccessKey", awsCredentials.secretAccessKey());
        }
        if (awsCredentials instanceof AwsSessionCredentials && !CommonUtils.isEmpty((String)(sessionToken = ((AwsSessionCredentials)awsCredentials).sessionToken()))) {
            connProperties.put("SessionToken", sessionToken);
        }
        return credentials;
    }

    public void endAuthentication(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) {
    }

    public boolean supportsDatabaseUser() {
        return false;
    }
}

