/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.clickhouse.model.plan;

import com.dbeaver.db.clickhouse.model.plan.ClickhousePlanNode;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNode;
import org.jkiss.dbeaver.model.impl.plan.AbstractExecutionPlan;

public class ClickhouseExecutionPlan
extends AbstractExecutionPlan {
    private final String query;
    private final List<DBCPlanNode> nodes;

    public ClickhouseExecutionPlan(@NotNull String query) {
        this.query = query;
        this.nodes = new ArrayList<DBCPlanNode>();
    }

    public String getQueryString() {
        return this.query;
    }

    public String getPlanQueryString() {
        return "EXPLAIN PLAN json=1 " + this.query;
    }

    public List<? extends DBCPlanNode> getPlanNodes(Map<String, Object> options) {
        return this.nodes;
    }

    public void explain(@NotNull DBCSession session) throws DBCException {
        block21: {
            JDBCSession connection = (JDBCSession)session;
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (JDBCStatement stmt = connection.createStatement();){
                    Throwable throwable2 = null;
                    Object var7_11 = null;
                    try (JDBCResultSet result = stmt.executeQuery(this.getPlanQueryString());){
                        if (result.next()) {
                            this.nodes.clear();
                            this.nodes.addAll(this.parse(result.getString(1)));
                            break block21;
                        }
                        throw new DBCException("Query plan is not available");
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBCException((Throwable)e, session.getExecutionContext());
            }
        }
    }

    @NotNull
    private List<? extends DBCPlanNode> parse(@NotNull String result) {
        List plans = (List)new Gson().fromJson(result, new TypeToken<List<Map<String, Object>>>(){}.getType());
        ArrayList<ClickhousePlanNode> roots = new ArrayList<ClickhousePlanNode>();
        for (Map plan : plans) {
            roots.add(new ClickhousePlanNode(null, JSONUtils.getObject((Map)plan, (String)"Plan")));
        }
        return roots;
    }
}

