/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.ConnectionInfo;
import com.intersys.jdbc.Descriptor;
import com.intersys.jdbc.LogFileStream;
import com.intersys.util.ListUtil;
import com.intersys.util.TimestampFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@Deprecated
public class SysList {
    public static final byte ITEM_UNDEF = -1;
    public static final byte ITEM_PLACEHOLDER = 0;
    public static final byte ITEM_ASCII = 1;
    public static final byte ITEM_UNICODE = 2;
    public static final byte ITEM_XUNICODE = 3;
    public static final byte ITEM_POSINT = 4;
    public static final byte ITEM_NEGINT = 5;
    public static final byte ITEM_POSNUM = 6;
    public static final byte ITEM_NEGNUM = 7;
    public static final byte ITEM_DOUBLE = 8;
    private static final int STREAM_BUF_SIZE = 32768;
    private static final int CHUNKSIZE = 256;
    private int BUCKET_SIZE = 1024;
    private static SimpleDateFormat m_sdfDate = new SimpleDateFormat("yyyy-MM-dd");
    private static SimpleDateFormat m_sdfTime = new SimpleDateFormat("HH:mm:ss");
    private static SimpleDateFormat m_sdfTimestamp = new TimestampFormat();
    private ConnectionInfo connectionInfo;
    private String serverLocale = "ISO8859_1";
    private byte[] m_aData;
    private int m_iLength;
    private int m_iLastIndex;
    private int m_iLastOffset;
    private int m_len;
    private int m_pos;
    private boolean m_header = false;
    private int currentRowIndex;
    private int currentRowOffset;
    private int maxFieldSize = 0;
    private int[] rowIndex;
    private int row;
    private int colCount;
    boolean NewRow = false;
    boolean isNull;

    SysList() {
        this.m_aData = new byte[256];
        this.m_iLength = 0;
        this.m_iLastIndex = 0;
        this.m_iLastOffset = 0;
    }

    SysList(byte[] list) {
        if (list == null) {
            this.m_aData = new byte[256];
            this.m_iLength = 0;
            this.m_iLastIndex = 0;
            this.m_iLastOffset = 0;
        } else {
            this.setList(list);
        }
    }

    SysList(byte[] list, int length) {
        this.setList(list, length, 0);
    }

    SysList(byte[] list, int length, int offset) {
        this.setList(list, length, offset);
    }

    SysList(boolean copy, SysList sl) {
        if (copy) {
            this.setList(sl.getData());
        } else {
            this.m_aData = sl.m_aData;
            this.m_iLength = sl.m_iLength;
            this.m_iLastIndex = sl.m_iLastIndex;
            this.m_iLastOffset = sl.m_iLastOffset;
        }
        this.setConnectionInfo(sl.connectionInfo);
    }

    SysList(boolean copy, byte[] list) {
        if (copy) {
            this.setList(list, list.length, 0);
        } else {
            this.setList(list);
        }
    }

    String readServerEncoding() throws SQLException {
        String encoding = this.getString();
        if (encoding.equalsIgnoreCase("UNICODE") || encoding.equalsIgnoreCase("LATIN1")) {
            return "ISO8859_1";
        }
        if (encoding.equalsIgnoreCase("LATIN7")) {
            return "ISO8859_13";
        }
        if (encoding.equalsIgnoreCase("LATIN9")) {
            return "Latin9";
        }
        if (encoding.equalsIgnoreCase("LATINA")) {
            return "ISO8859_6";
        }
        if (encoding.equalsIgnoreCase("LATINT")) {
            return "ISO8859_11";
        }
        if (encoding.equalsIgnoreCase("LATIN2")) {
            return "ISO8859_2";
        }
        if (encoding.equalsIgnoreCase("LATIN3")) {
            return "ISO8859_3";
        }
        if (encoding.equalsIgnoreCase("LATINC")) {
            return "ISO8859_5";
        }
        if (encoding.equalsIgnoreCase("LATING")) {
            return "ISO8859_7";
        }
        if (encoding.equalsIgnoreCase("LATINH")) {
            return "ISO8859_8";
        }
        if (encoding.equalsIgnoreCase("CP866")) {
            return "Cp866";
        }
        if (encoding.equalsIgnoreCase("CP874")) {
            return "Cp874";
        }
        if (encoding.equalsIgnoreCase("CP1250")) {
            return "Cp1250";
        }
        if (encoding.equalsIgnoreCase("CP1251")) {
            return "Cp1251";
        }
        if (encoding.equalsIgnoreCase("CP1252")) {
            return "Cp1252";
        }
        if (encoding.equalsIgnoreCase("CP1253")) {
            return "Cp1253";
        }
        if (encoding.equalsIgnoreCase("CP1255")) {
            return "Cp1255";
        }
        if (encoding.equalsIgnoreCase("CP1256")) {
            return "Cp1256";
        }
        if (encoding.equalsIgnoreCase("CP1257")) {
            return "Cp1257";
        }
        return encoding;
    }

    private boolean isUnicode() {
        return this.connectionInfo.isUnicodeServer;
    }

    private synchronized boolean eltLength() throws SQLException {
        this.isNull = false;
        this.m_pos = this.m_iLastOffset++;
        if (this.m_aData[this.m_pos] == 0) {
            if (this.m_pos + 3 > this.m_iLength) {
                throw new SQLException("Incorrect list format: " + (this.m_pos + 3) + " > " + this.m_iLength, "S1000");
            }
            this.m_len = this.m_aData[this.m_pos + 1] & 0xFF | (this.m_aData[this.m_pos + 2] & 0xFF) << 8;
            this.m_pos += 3;
            if (this.m_len == 0) {
                this.m_len = this.m_aData[this.m_pos] & 0xFF | (this.m_aData[this.m_pos + 1] & 0xFF) << 8 | (this.m_aData[this.m_pos + 2] & 0xFF) << 16 | (this.m_aData[this.m_pos + 3] & 0xFF) << 24;
                this.m_pos += 4;
            }
            --this.m_len;
        } else {
            if (this.m_aData[this.m_pos] == 1) {
                ++this.m_iLastIndex;
                this.m_len = 0;
                this.isNull = true;
                return this.isNull;
            }
            if (this.m_pos >= this.m_iLength) {
                throw new SQLException("Incorrect list format: " + this.m_pos + " >= " + this.m_iLength, "S1000");
            }
            this.m_len = (this.m_aData[this.m_pos++] & 0xFF) - 2;
        }
        if (this.m_pos + this.m_len >= this.m_iLength) {
            throw new SQLException("Incorrect list format: " + (this.m_pos + this.m_len + 1) + " > " + this.m_iLength, "S1000");
        }
        this.m_iLastOffset = this.m_pos + this.m_len + 1;
        ++this.m_iLastIndex;
        if (this.m_len == 0 && this.m_aData[this.m_pos] == 1) {
            this.isNull = true;
        }
        return this.isNull;
    }

    boolean isUndefined() {
        return this.m_aData[this.m_iLastOffset] == 1;
    }

    boolean isNullOrZero() {
        return this.m_aData[this.m_iLastOffset] == 2;
    }

    private synchronized void ensureBuffer(int needed) {
        needed = needed + (needed >> 4) + this.BUCKET_SIZE - 1 & ~(this.BUCKET_SIZE - 1);
        this.BUCKET_SIZE *= 2;
        if (needed < 0) {
            throw new RuntimeException("Exceeded maximum amount of memory that can be allocated for a given row.");
        }
        byte[] a = new byte[needed];
        System.arraycopy(this.m_aData, 0, a, 0, this.m_iLength);
        this.m_aData = a;
    }

    private synchronized int makeItem(int off, int len) {
        if (len < 255) {
            if (this.m_iLength + ++len > this.m_aData.length) {
                this.ensureBuffer(this.m_iLength + len);
            }
            if (this.m_iLength != off) {
                System.arraycopy(this.m_aData, off, this.m_aData, off + len, this.m_iLength - off);
            }
            this.m_iLength += len;
            this.m_aData[off] = (byte)len;
            ++this.m_iLastIndex;
            this.m_iLastOffset += len;
            return off + 1;
        }
        if (len < 65536) {
            if (this.m_iLength + len + 3 > this.m_aData.length) {
                this.ensureBuffer(this.m_iLength + len + 3);
            }
            if (this.m_iLength != off) {
                System.arraycopy(this.m_aData, off, this.m_aData, off + len + 3, this.m_iLength - off);
            }
            this.m_iLength += len + 3;
            this.m_aData[off] = 0;
            this.m_aData[off + 1] = (byte)len;
            this.m_aData[off + 2] = (byte)(len >> 8);
            ++this.m_iLastIndex;
            this.m_iLastOffset += len + 3;
            return off + 3;
        }
        if (this.m_iLength + len + 7 > this.m_aData.length) {
            this.ensureBuffer(this.m_iLength + len + 7);
        }
        if (this.m_iLength != off) {
            System.arraycopy(this.m_aData, off, this.m_aData, off + len + 3, this.m_iLength - off);
        }
        this.m_iLength += len + 7;
        this.m_aData[off] = 0;
        this.m_aData[off + 1] = 0;
        this.m_aData[off + 2] = 0;
        this.m_aData[off + 3] = (byte)len;
        this.m_aData[off + 4] = (byte)(len >> 8);
        this.m_aData[off + 5] = (byte)(len >> 16);
        this.m_aData[off + 6] = (byte)(len >> 24);
        ++this.m_iLastIndex;
        this.m_iLastOffset += len + 7;
        return off + 7;
    }

    private boolean isWide(String s) {
        for (int j = 0; j < s.length(); ++j) {
            if (s.charAt(j) <= '\u00ff') continue;
            return true;
        }
        return false;
    }

    int getItemType() throws SQLException {
        int i = this.m_iLastOffset;
        if (i == this.m_iLength) {
            throw new NoMoreDataException();
        }
        if (this.m_aData[i] == 1) {
            return -1;
        }
        if (this.m_aData[i] == 0) {
            if (i + 3 >= this.m_iLength) {
                throw new SQLException("Incorrect list format: " + (i + 4) + " > " + this.m_iLength, "S1000");
            }
            int len = this.m_aData[++i] & 0xFF | this.m_aData[i + 1] << 8;
            i += 2;
            if (len == 0) {
                if (i + 4 >= this.m_iLength) {
                    throw new SQLException("Incorrect list format: " + (i + 5) + " > " + this.m_iLength, "S1000");
                }
                i += 4;
            }
        } else if (++i >= this.m_iLength) {
            throw new SQLException("Incorrect list format: " + (i + 1) + " > " + this.m_iLength, "S1000");
        }
        return this.m_aData[i] & 0xFF;
    }

    private String grabUnicode() {
        int i = this.m_pos;
        char[] c = new char[this.m_len >>>= 1];
        int j = 0;
        while (j < this.m_len) {
            c[j] = (char)(this.m_aData[i] & 0xFF | this.m_aData[i + 1] << 8);
            ++j;
            i += 2;
        }
        return new String(c);
    }

    private boolean stuff7BitAscii(String s) {
        if (s.charAt(0) > '\u007f') {
            return false;
        }
        int pos = this.m_iLastIndex;
        int mpos = this.m_pos;
        int mlen = this.m_len;
        int milen = this.m_iLength;
        int moff = this.m_iLastOffset;
        int l = s.length();
        int off = this.m_iLastOffset;
        off = this.makeItem(off, l + 1);
        this.m_aData[off] = 1;
        ++off;
        for (int i = 0; i < l; ++i) {
            char c = s.charAt(i);
            if (c > '\u007f') {
                this.m_iLastIndex = pos;
                this.m_pos = mpos;
                this.m_len = mlen;
                this.m_iLength = milen;
                this.m_iLastOffset = moff;
                return false;
            }
            this.m_aData[off + i] = (byte)c;
        }
        return true;
    }

    private void stuffAscii(String s) {
        if (this.stuff7BitAscii(s)) {
            return;
        }
        this.stuff8BitAscii(s);
    }

    private void stuff8BitAscii(String s) {
        byte[] ascii;
        int i = this.m_iLastOffset;
        try {
            if (this.serverLocale == null) {
                throw new IllegalStateException("Null locale: ci.locale = " + this.connectionInfo.serverLocale);
            }
            ascii = s.getBytes(this.serverLocale);
        }
        catch (UnsupportedEncodingException e) {
            ascii = s.getBytes();
        }
        int l = ascii.length;
        i = this.makeItem(i, l + 1);
        this.m_aData[i] = 1;
        System.arraycopy(ascii, 0, this.m_aData, i + 1, l);
    }

    private void stuffList(SysList lst) {
        int i = this.m_iLastOffset;
        int l = lst.m_iLength;
        i = this.makeItem(i, l + 1);
        this.m_aData[i] = 1;
        System.arraycopy(lst.m_aData, 0, this.m_aData, i + 1, l);
    }

    synchronized SysList set(byte[] b) throws SQLException {
        if (b.length == 0) {
            char[] c = new char[]{'\u0000'};
            this.stuffAscii(new String(c));
            return this;
        }
        int i = this.m_iLastOffset;
        int l = b.length;
        i = this.makeItem(i, l + 1);
        this.m_aData[i] = 1;
        System.arraycopy(b, 0, this.m_aData, i + 1, l);
        return this;
    }

    private void stuffUnicode(String s) {
        int i = this.m_iLastOffset;
        int l = s.length();
        i = this.makeItem(i, l * 2 + 1);
        this.m_aData[i++] = 2;
        int j = 0;
        while (j < l) {
            char c = s.charAt(j);
            this.m_aData[i] = (byte)c;
            this.m_aData[i + 1] = (byte)(c >> 8);
            ++j;
            i += 2;
        }
    }

    private void stuffNegInt(int value) {
        int i = this.m_iLastOffset;
        if (value < -65536) {
            if (value < -16777216) {
                i = this.makeItem(i, 5);
                this.m_aData[i + 4] = (byte)(value >> 24);
            } else {
                i = this.makeItem(i, 4);
            }
            this.m_aData[i + 3] = (byte)(value >> 16);
            this.m_aData[i + 2] = (byte)(value >> 8);
            this.m_aData[i + 1] = (byte)value;
        } else if (value < -256) {
            i = this.makeItem(i, 3);
            this.m_aData[i + 2] = (byte)(value >> 8);
            this.m_aData[i + 1] = (byte)value;
        } else if (value != -1) {
            i = this.makeItem(i, 2);
            this.m_aData[i + 1] = (byte)value;
        } else {
            i = this.makeItem(i, 1);
        }
        this.m_aData[i] = 5;
    }

    private void stuffPosInt(int value) {
        int i = this.m_iLastOffset;
        if (value > 65535) {
            if (value > 0xFFFFFF) {
                i = this.makeItem(i, 5);
                this.m_aData[i + 4] = (byte)(value >> 24);
            } else {
                i = this.makeItem(i, 4);
            }
            this.m_aData[i + 3] = (byte)(value >> 16);
            this.m_aData[i + 2] = (byte)(value >> 8);
            this.m_aData[i + 1] = (byte)value;
        } else if (value > 255) {
            i = this.makeItem(i, 3);
            this.m_aData[i + 2] = (byte)(value >> 8);
            this.m_aData[i + 1] = (byte)value;
        } else if (value != 0) {
            i = this.makeItem(i, 2);
            this.m_aData[i + 1] = (byte)value;
        } else {
            i = this.makeItem(i, 1);
        }
        this.m_aData[i] = 4;
    }

    private void stuffPosLong(long value) {
        int len = value > 0xFFFFFFFFL ? (value > 0xFFFFFFFFFFFFL ? (value > 0xFFFFFFFFFFFFFFL ? 8 : 7) : (value > 0xFFFFFFFFFFL ? 6 : 5)) : (value > 65535L ? (value > 0xFFFFFFL ? 4 : 3) : (value > 255L ? 2 : (value > 0L ? 1 : 0)));
        int i = this.stuffRawLong(value, len);
        this.m_aData[i] = 4;
    }

    private void stuffNegLong(long value) {
        int len = value < -4294967296L ? (value < -281474976710656L ? (value < -72057594037927936L ? 8 : 7) : (value < -1099511627776L ? 6 : 5)) : (value < -65536L ? (value < -1048576L ? 4 : 3) : (value < -256L ? 2 : (value < -1L ? 1 : 0)));
        int i = this.stuffRawLong(value, len);
        this.m_aData[i] = 5;
    }

    private int stuffRawLong(long value, int len) {
        int i = this.m_iLastOffset;
        i = this.makeItem(i, len + 1);
        switch (len) {
            case 8: {
                this.m_aData[i + 8] = (byte)(value >> 56);
            }
            case 7: {
                this.m_aData[i + 7] = (byte)(value >> 48);
            }
            case 6: {
                this.m_aData[i + 6] = (byte)(value >> 40);
            }
            case 5: {
                this.m_aData[i + 5] = (byte)(value >> 32);
            }
            case 4: {
                this.m_aData[i + 4] = (byte)(value >> 24);
            }
            case 3: {
                this.m_aData[i + 3] = (byte)(value >> 16);
            }
            case 2: {
                this.m_aData[i + 2] = (byte)(value >> 8);
            }
            case 1: {
                this.m_aData[i + 1] = (byte)value;
            }
        }
        return i;
    }

    public synchronized void setIEEEDouble(double d) {
        long bits = Double.doubleToRawLongBits(d);
        int i = this.stuffRawLong(bits, 8);
        this.m_aData[i] = 8;
    }

    synchronized SysList set(BigInteger value) throws SQLException {
        int newLen;
        int off;
        if (value == null) {
            this.setNull();
            return this;
        }
        byte[] b = value.toByteArray();
        int len = b.length;
        boolean isNegative = b[0] < 0;
        if (isNegative) {
            for (off = 0; off < len && b[off] == 255; ++off) {
            }
            if (off == len) {
                --off;
                newLen = 1;
            } else {
                newLen = len - off;
            }
        } else {
            while (off < len && b[off] == 0) {
                ++off;
            }
            if (off == len) {
                return this.set(0);
            }
            newLen = len - off;
        }
        int i = this.m_iLastOffset;
        i = this.makeItem(i, newLen + 1);
        for (int j = 1; j <= newLen; ++j) {
            this.m_aData[i + j] = b[len - j];
        }
        this.m_aData[i] = isNegative ? 5 : 4;
        return this;
    }

    synchronized SysList set(BigDecimal value) throws SQLException {
        int offset = this.m_iLastOffset;
        int scale = value.scale();
        BigInteger n = value.unscaledValue();
        int len = n.bitLength();
        if (len < 64 && scale <= 128) {
            int off;
            byte[] b = n.toByteArray();
            len = b.length;
            int n2 = off = b[0] == 0 || b[0] == 255 ? 1 : 0;
            if (scale == 0) {
                offset = this.makeItem(offset, len - off + 1);
                this.m_aData[offset++] = b[0] >= 0 ? 4 : 5;
            } else {
                offset = this.makeItem(offset, len - off + 2);
                this.m_aData[offset++] = b[0] >= 0 ? 6 : 7;
                this.m_aData[offset++] = (byte)(-scale);
            }
            while (len > off) {
                this.m_aData[offset++] = b[--len];
            }
        } else {
            this.stuffAscii(ListUtil.scaledDecimaltoString(-scale, n));
        }
        return this;
    }

    synchronized void setSQLText(String text) throws SQLException {
        int len = text.length();
        if (len == 0) {
            char[] c = new char[]{'\u0000'};
            this.stuffPosInt(1);
            this.stuffAscii(new String(c));
            return;
        }
        int bindex = 0;
        int chunksize = this.isWide(text) ? 15952 : 31904;
        int chunknum = len % chunksize != 0 ? len / chunksize + 1 : len / chunksize;
        this.stuffPosInt(chunknum);
        if (this.isUnicode() && this.isWide(text)) {
            for (int i = 1; i <= chunknum; ++i) {
                int eindex = bindex + chunksize;
                eindex = eindex > len ? len : eindex;
                this.stuffUnicode(text.substring(bindex, eindex));
                bindex = eindex;
            }
        } else {
            for (int i = 1; i <= chunknum; ++i) {
                int eindex = bindex + chunksize;
                eindex = eindex > len ? len : eindex;
                this.stuffAscii(text.substring(bindex, eindex));
                bindex = eindex;
            }
        }
    }

    public final synchronized void setConnectionInfo(ConnectionInfo info) {
        this.connectionInfo = info;
        this.serverLocale = this.connectionInfo.serverLocale;
        if (this.serverLocale == null) {
            throw new IllegalArgumentException("Null locale");
        }
    }

    ConnectionInfo getConnectionInfo() {
        return (ConnectionInfo)this.connectionInfo.clone();
    }

    synchronized boolean wasNull() {
        return this.isNull;
    }

    private void setList(byte[] list, int length, int offset) {
        if (null == this.m_aData) {
            this.m_aData = new byte[length + 256 - 1 & 0xFFFFFF00];
        } else if (length > this.m_aData.length) {
            this.ensureBuffer(length);
        }
        System.arraycopy(list, offset, this.m_aData, 0, length);
        this.m_iLength = length;
        this.m_iLastIndex = 0;
        this.m_iLastOffset = 0;
    }

    private synchronized void setList(byte[] list) {
        this.m_aData = list;
        this.m_iLength = list.length;
        this.m_iLastIndex = 0;
        this.m_iLastOffset = 0;
    }

    synchronized void setNull() {
        if (this.m_iLength + 2 > this.m_aData.length) {
            this.ensureBuffer(this.m_iLength + 2);
        }
        this.m_aData[this.m_iLastOffset] = 2;
        this.m_aData[this.m_iLastOffset + 1] = 1;
        this.m_iLength += 2;
        this.m_iLastOffset += 2;
        ++this.m_iLastIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized int setParameter(OutputStream out, CacheConnection connection, int messageCount, Object value) throws SQLException {
        this.setParameter(value);
        if (this.m_iLength > 32014) {
            try {
                if (messageCount == -1) {
                    messageCount = connection.messageCount.getCount();
                }
                int carryover = this.m_iLength - 32014;
                int id = SysList.read4ByteInt(this.m_aData, 8);
                SysList.write4ByteInt(this.m_aData, 0, 32000);
                SysList.write4ByteInt(this.m_aData, 4, messageCount);
                SysList.write4ByteInt(this.m_aData, 8, id | Integer.MIN_VALUE);
                OutputStream outputStream = out;
                synchronized (outputStream) {
                    out.write(this.m_aData, 0, 32014);
                    out.flush();
                }
                if (connection.logFile != null) {
                    connection.logFile.dump(this.m_aData, 0, 32014, 1, null);
                }
                System.arraycopy(this.m_aData, 32014, this.m_aData, 14, carryover);
                this.m_iLastOffset = this.m_iLength = carryover + 14;
                this.m_iLastIndex = 1;
                SysList.write4ByteInt(this.m_aData, 8, id);
            }
            catch (Exception e) {
                throw new SQLException("Error writing parameters " + e.getMessage());
            }
        }
        return messageCount;
    }

    synchronized void setParameter(Object value) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        }
        if (value instanceof String) {
            if (((String)value).length() == 0) {
                char[] c = new char[]{'\u0000'};
                this.stuffAscii(new String(c));
                return;
            }
            if (this.isUnicode() && this.isWide((String)value)) {
                this.stuffUnicode((String)value);
            } else {
                this.stuffAscii((String)value);
            }
            return;
        }
        if (value instanceof Integer) {
            if ((Integer)value < 0) {
                this.stuffNegInt((Integer)value);
            } else {
                this.stuffPosInt((Integer)value);
            }
            return;
        }
        if (value instanceof Double) {
            if (this.connectionInfo.useIEEEDouble) {
                this.setIEEEDouble((Double)value);
            } else {
                this.stuffAscii(ListUtil.canonizeFloatingPointString((Double)value));
            }
            return;
        }
        if (value instanceof Float) {
            if (this.connectionInfo.useIEEEDouble) {
                this.setIEEEDouble(((Float)value).doubleValue());
            } else {
                this.stuffAscii(ListUtil.canonizeFloatingPointString(((Float)value).doubleValue()));
            }
            return;
        }
        if (value instanceof byte[]) {
            this.set((byte[])value);
        } else if (value instanceof char[]) {
            this.set(new String((char[])value));
        } else if (value instanceof SysList) {
            this.set((SysList)value);
        } else if (value instanceof BigDecimal) {
            this.set((BigDecimal)value);
        } else if (value instanceof Date) {
            this.set((Date)value);
        } else if (value instanceof Time) {
            this.set((Time)value);
        } else if (value instanceof Timestamp) {
            this.stuffAscii(ListUtil.canonizeTimestampString(String.valueOf((Timestamp)value)));
        } else if (value instanceof Long) {
            if ((Long)value < 0L) {
                this.stuffNegLong((Long)value);
            } else {
                this.stuffPosLong((Long)value);
            }
        } else if (value instanceof BigInteger) {
            this.set((BigInteger)value);
        } else if (value instanceof Byte) {
            this.set(((Byte)value).byteValue());
        } else if (value instanceof Short) {
            if (((Short)value).intValue() < 0) {
                this.stuffNegInt(((Short)value).intValue());
            } else {
                this.stuffPosInt(((Short)value).intValue());
            }
        } else if (value instanceof Character) {
            this.set(value.toString());
        } else if (value instanceof Boolean) {
            this.set((Boolean)value);
        } else {
            throw new SQLException("Type out of range: " + value.getClass().getName(), "S1003");
        }
    }

    synchronized void setIntegerWrapper(Integer value) throws SQLException {
        if (value == null) {
            this.setNull();
        } else if (value < 0) {
            this.stuffNegInt(value);
        } else {
            this.stuffPosInt(value);
        }
    }

    synchronized void setByte(byte[] value) throws SQLException {
        if (value == null) {
            this.setNull();
        } else {
            this.set(value);
        }
    }

    synchronized void setBooleanWrapper(Boolean value) throws SQLException {
        if (value == null) {
            this.setNull();
        } else {
            this.set(value);
        }
    }

    synchronized void setDoubleWrapper(Double value) throws SQLException {
        if (value == null) {
            this.setNull();
        } else if (this.connectionInfo.useIEEEDouble) {
            this.setIEEEDouble(value);
        } else {
            this.stuffAscii(String.valueOf(value));
        }
    }

    synchronized void setFloatWrapper(Float value) throws SQLException {
        if (value == null) {
            this.setNull();
        } else {
            this.stuffAscii(String.valueOf(value.floatValue()));
        }
    }

    synchronized void setString(String value) throws SQLException {
        this.set(value);
    }

    synchronized void setDate(Date value) throws SQLException {
        if (value == null) {
            this.setNull();
        } else {
            this.set(value);
        }
    }

    synchronized void setTime(Time value) throws SQLException {
        if (value == null) {
            this.setNull();
        } else {
            this.set(value);
        }
    }

    synchronized void setTimestamp(Timestamp value) throws SQLException {
        if (value == null) {
            this.setNull();
        } else {
            this.set(value);
        }
    }

    synchronized void setLongWrapper(Long value) throws SQLException {
        if (value == null) {
            this.setNull();
        } else if (value < 0L) {
            this.stuffNegLong(value);
        } else {
            this.stuffPosLong(value);
        }
    }

    synchronized void setShortWrapper(Short value) throws SQLException {
        if (value == null) {
            this.setNull();
        } else if (value.intValue() < 0) {
            this.stuffNegInt(value.intValue());
        } else {
            this.stuffPosInt(value.intValue());
        }
    }

    synchronized void setBigDecimal(BigDecimal value) throws SQLException {
        if (value == null) {
            this.setNull();
        } else {
            this.set(value);
        }
    }

    synchronized SysList getListEx() throws SQLException {
        if (this.m_iLastOffset == this.m_iLength) {
            throw new NoMoreDataException();
        }
        return this.getList();
    }

    synchronized SysList getList(int pos) throws SQLException {
        this.setReadPosition(pos);
        return this.getList();
    }

    synchronized SysList getList() throws SQLException {
        if (this.eltLength()) {
            SysList temp = new SysList(false, new byte[0]);
            temp.setConnectionInfo(this.connectionInfo);
            return temp;
        }
        if (this.m_aData[this.m_pos] != 1) {
            throw new SQLException("Incorrect list format: item <> ITEM_ASCII", "S1000");
        }
        byte[] data = new byte[this.m_len];
        System.arraycopy(this.m_aData, this.m_pos + 1, data, 0, this.m_len);
        SysList temp = new SysList(false, data);
        temp.setConnectionInfo(this.connectionInfo);
        return temp;
    }

    synchronized byte[] getByte(int pos) throws SQLException {
        this.setReadPosition(pos);
        return this.getByte();
    }

    synchronized byte[] getByte() throws SQLException {
        if (this.eltLength()) {
            return null;
        }
        if (this.m_len == 1 && this.m_aData[this.m_pos + 1] == 0) {
            return new byte[0];
        }
        byte[] b = new byte[this.m_len];
        System.arraycopy(this.m_aData, this.m_pos + 1, b, 0, this.m_len);
        return b;
    }

    synchronized String getStringEx() throws SQLException {
        if (this.m_iLastOffset == this.m_iLength) {
            throw new NoMoreDataException();
        }
        return this.getString();
    }

    synchronized String getString(int pos) throws SQLException {
        this.setReadPosition(pos);
        return this.getString();
    }

    byte[] getByte(Descriptor desc, int pos) throws SQLException {
        this.setReadPosition(pos);
        return this.getByte(desc);
    }

    byte[] getByte(Descriptor desc) throws SQLException {
        if (this.eltLength()) {
            return null;
        }
        if (this.m_len == 1 && this.m_aData[this.m_pos + 1] == 0) {
            return new byte[0];
        }
        int len = -1;
        if (this.maxFieldSize > 0 && (desc.type == -2 || desc.type == -3 || desc.type == -4 || desc.type == 1 || desc.type == 12 || desc.type == -1)) {
            len = this.maxFieldSize;
        }
        if (this.m_aData[this.m_pos] == 2) {
            byte[] b = ListUtil.getUTF8Bytes(this.m_aData, this.m_pos + 1, this.m_len, len);
            return b;
        }
        if (this.m_aData[this.m_pos] == 4) {
            byte[] b = new byte[]{ListUtil.dblbyte(0, this.grabPosLong(this.m_pos, this.m_len))};
            return b;
        }
        if (this.m_aData[this.m_pos] == 5) {
            byte[] b = new byte[]{ListUtil.dblbyte(0, this.grabNegLong(this.m_pos, this.m_len))};
            return b;
        }
        if (this.m_aData[this.m_pos] != 1) {
            throw new SQLException("Element cannot be read as byte[]", "S1000");
        }
        if (len > 0 && this.m_len > len) {
            this.m_len = len;
        }
        byte[] b = new byte[this.m_len];
        System.arraycopy(this.m_aData, this.m_pos + 1, b, 0, this.m_len);
        return b;
    }

    String getString(Descriptor desc, int pos) throws SQLException {
        this.setReadPosition(pos);
        return this.getString(desc);
    }

    double getDouble(Descriptor desc, int pos) throws SQLException {
        this.setReadPosition(pos);
        return this.getDouble(desc);
    }

    synchronized String getString(Descriptor desc) throws SQLException {
        switch (desc.type) {
            case 2: 
            case 3: {
                BigDecimal str = this.getBigDecimalScale(desc.scale);
                if (str == null) {
                    return null;
                }
                return ListUtil.toString(str);
            }
            case 8: {
                double dbl = this.getDouble();
                if (this.isNull) {
                    return null;
                }
                return String.valueOf(dbl);
            }
        }
        if (this.eltLength()) {
            return null;
        }
        switch (this.m_aData[this.m_pos++]) {
            case 1: {
                if (this.m_len == 1 && this.m_aData[this.m_pos] == 0) {
                    return "";
                }
                try {
                    String st = new String(this.m_aData, this.m_pos, this.m_len, this.serverLocale);
                    if (this.maxFieldSize > 0 && (desc.type == -2 || desc.type == -3 || desc.type == -4 || desc.type == 1 || desc.type == 12 || desc.type == -1)) {
                        if (st.length() > this.maxFieldSize / 2) {
                            return st.substring(0, this.maxFieldSize / 2);
                        }
                        return st;
                    }
                    return st;
                }
                catch (UnsupportedEncodingException e) {
                    throw new SQLException("Cannot convert using server locale: unsupported Encoding:" + this.serverLocale, "S2208");
                }
            }
            case 2: {
                String st = this.grabUnicode();
                if (this.maxFieldSize > 0 && (desc.type == -2 || desc.type == -3 || desc.type == -4 || desc.type == 1 || desc.type == 12 || desc.type == -1)) {
                    if (st.length() > this.maxFieldSize / 2) {
                        return st.substring(0, this.maxFieldSize / 2);
                    }
                    return st;
                }
                return st;
            }
            case 4: {
                return this.m_len < 8 || this.m_len == 8 && this.m_aData[this.m_pos + 7] > 0 ? ListUtil.lngstr(this.grabPosLong(this.m_pos, this.m_len)) : this.grabBigInteger(this.m_pos, this.m_len, false).toString();
            }
            case 5: {
                return this.m_len < 8 || this.m_len == 8 && this.m_aData[this.m_pos + 7] < 0 ? ListUtil.lngstr(this.grabNegLong(this.m_pos, this.m_len)) : this.grabBigInteger(this.m_pos, this.m_len, true).toString();
            }
            case 6: {
                return this.m_len < 9 || this.m_len == 9 && this.m_aData[this.m_pos + 8] > 0 ? ListUtil.dblstr(this.m_aData[this.m_pos], this.grabPosLong(this.m_pos + 1, this.m_len - 1)) : ListUtil.scaledDecimaltoString(this.m_aData[this.m_pos], this.grabBigInteger(this.m_pos + 1, this.m_len - 1, false));
            }
            case 7: {
                return this.m_len < 9 || this.m_len == 9 && this.m_aData[this.m_pos + 8] < 0 ? ListUtil.dblstr(this.m_aData[this.m_pos], this.grabNegLong(this.m_pos + 1, this.m_len - 1)) : ListUtil.scaledDecimaltoString(this.m_aData[this.m_pos], this.grabBigInteger(this.m_pos + 1, this.m_len - 1, true));
            }
            case 8: {
                return String.valueOf(this.grabIEEEDouble(this.m_pos, this.m_len));
            }
        }
        throw new SQLException("Incorrect list format, unknown type: " + (this.m_aData[this.m_pos - 1] & 0xFF), "S1003");
    }

    double getDouble(Descriptor desc) throws SQLException {
        return this.getDouble();
    }

    Double getDoubleWrapper(Descriptor desc, int pos) throws SQLException {
        this.setReadPosition(pos);
        double d = this.getDouble(desc);
        if (this.isNull) {
            return null;
        }
        return new Double(d);
    }

    synchronized BigDecimal getBigDecimal(Descriptor desc) throws SQLException {
        return this.getBigDecimalScale(desc.scale);
    }

    synchronized BigDecimal getBigDecimal(Descriptor desc, int pos) throws SQLException {
        this.setReadPosition(pos);
        return this.getBigDecimalScale(desc.scale);
    }

    synchronized BigDecimal getBigDecimalAutoScale(Descriptor desc) throws SQLException {
        return this.getBigDecimalAutoScale();
    }

    synchronized BigDecimal getBigDecimalAutoScale(Descriptor desc, int pos) throws SQLException {
        this.setReadPosition(pos);
        return this.getBigDecimalAutoScale();
    }

    synchronized String getString() throws SQLException {
        if (this.eltLength()) {
            return null;
        }
        byte itemType = this.m_aData[this.m_pos++];
        switch (itemType) {
            case 1: {
                if (this.m_len == 1 && this.m_aData[this.m_pos] == 0) {
                    return "";
                }
                try {
                    return new String(this.m_aData, this.m_pos, this.m_len, this.serverLocale);
                }
                catch (UnsupportedEncodingException e) {
                    throw new SQLException("Cannot convert using server locale: unsupported Encoding:" + this.serverLocale, "S2208");
                }
            }
        }
        return this.getNonAsciiString(itemType);
    }

    synchronized String getDisplayString() throws SQLException {
        if (this.eltLength()) {
            return null;
        }
        byte itemType = this.m_aData[this.m_pos++];
        switch (itemType) {
            case 1: {
                if (this.m_len == 1 && this.m_aData[this.m_pos] == 0) {
                    return "";
                }
                byte[] data = new byte[this.m_len];
                System.arraycopy(this.m_aData, this.m_pos, data, 0, this.m_len);
                SysList temp = new SysList(false, data);
                temp.setConnectionInfo(this.connectionInfo);
                return temp.toString(false);
            }
        }
        return this.getNonAsciiString(itemType);
    }

    private String getNonAsciiString(int itemType) throws SQLException {
        switch (itemType) {
            case 2: {
                return this.grabUnicode();
            }
            case 4: {
                return this.m_len < 8 || this.m_len == 8 && this.m_aData[this.m_pos + 7] > 0 ? ListUtil.lngstr(this.grabPosLong(this.m_pos, this.m_len)) : this.grabBigInteger(this.m_pos, this.m_len, false).toString();
            }
            case 5: {
                return this.m_len < 8 || this.m_len == 8 && this.m_aData[this.m_pos + 7] < 0 ? ListUtil.lngstr(this.grabNegLong(this.m_pos, this.m_len)) : this.grabBigInteger(this.m_pos, this.m_len, true).toString();
            }
            case 6: {
                return this.m_len < 9 || this.m_len == 9 && this.m_aData[this.m_pos + 8] > 0 ? ListUtil.dblstr(this.m_aData[this.m_pos], this.grabPosLong(this.m_pos + 1, this.m_len - 1)) : ListUtil.scaledDecimaltoString(this.m_aData[this.m_pos], this.grabBigInteger(this.m_pos + 1, this.m_len - 1, false));
            }
            case 7: {
                return this.m_len < 9 || this.m_len == 9 && this.m_aData[this.m_pos + 8] < 0 ? ListUtil.dblstr(this.m_aData[this.m_pos], this.grabNegLong(this.m_pos + 1, this.m_len - 1)) : ListUtil.scaledDecimaltoString(this.m_aData[this.m_pos], this.grabBigInteger(this.m_pos + 1, this.m_len - 1, true));
            }
            case 8: {
                return String.valueOf(this.grabIEEEDouble(this.m_pos, this.m_len));
            }
        }
        throw new SQLException("Incorrect list format, unknown type: " + (this.m_aData[this.m_pos - 1] & 0xFF), "S1003");
    }

    synchronized Timestamp getTimestamp(int pos) throws SQLException {
        String s = this.getString(pos);
        if (s == null) {
            return null;
        }
        return Timestamp.valueOf(s);
    }

    synchronized Timestamp getTimestamp(int pos, Calendar cal) throws SQLException {
        this.setReadPosition(pos);
        return this.getTimestamp(cal);
    }

    synchronized Timestamp getTimestamp() throws SQLException {
        String s = this.getString();
        if (s == null) {
            return null;
        }
        int len = s.length();
        if (len < 10) {
            throw new SQLException("Invalid Timestamp", "22008", 22008);
        }
        if (len == 10) {
            s = s.concat(" 00:00:00.0");
        }
        return Timestamp.valueOf(s);
    }

    synchronized Timestamp getTimestamp(Calendar cal) throws SQLException {
        int[] dt = new int[3];
        int[] tm = new int[4];
        if (this.eltLength()) {
            return null;
        }
        switch (this.m_aData[this.m_pos++]) {
            case 1: {
                if (this.m_len >= 19) {
                    ListUtil.readTimestampb(this.m_aData, this.m_pos, this.m_len, dt, tm);
                    Calendar mycal = (Calendar)cal.clone();
                    mycal.set(dt[0], dt[1] - 1 + 0, dt[2], tm[0], tm[1], tm[2]);
                    Timestamp myts = new Timestamp(mycal.getTime().getTime());
                    myts.setNanos(tm[3]);
                    return myts;
                }
                if (this.m_len >= 10) {
                    ListUtil.readDateb(this.m_aData, this.m_pos, this.m_len, dt);
                    Calendar mycal = (Calendar)cal.clone();
                    mycal.set(dt[0], dt[1] - 1 + 0, dt[2], 0, 0, 0);
                    Timestamp myts = new Timestamp(mycal.getTime().getTime());
                    myts.setNanos(0);
                    return myts;
                }
                throw new SQLException("Invalid Timestamp", "22008", 22008);
            }
            case 2: {
                throw new SQLException("Invalid Timestamp", "22008", 22008);
            }
        }
        throw new SQLException("Incorrect list format, unknown type: " + (this.m_aData[this.m_pos - 1] & 0xFF), "S1000");
    }

    synchronized Date getDate(int pos) throws SQLException {
        String s = this.getString(pos);
        if (s == null) {
            return null;
        }
        return Date.valueOf(s);
    }

    synchronized Date getDate(int pos, Calendar cal) throws SQLException {
        this.setReadPosition(pos);
        return this.getDate(cal);
    }

    synchronized Date getDate() throws SQLException {
        String s = this.getString();
        if (s == null) {
            return null;
        }
        if (s.length() < 10) {
            throw new SQLException("Invalid Date", "22008", 22008);
        }
        if (s.length() != 10) {
            s = s.substring(0, 10);
        }
        return Date.valueOf(s);
    }

    synchronized Date getDate(Calendar cal) throws SQLException {
        int[] dt = new int[3];
        if (this.eltLength()) {
            return null;
        }
        switch (this.m_aData[this.m_pos++]) {
            case 1: {
                if (this.m_len < 10) {
                    throw new SQLException("Invalid Date", "22008", 22008);
                }
                this.m_pos = ListUtil.readDateb(this.m_aData, this.m_pos, this.m_len, dt);
                Calendar mycal = (Calendar)cal.clone();
                mycal.set(dt[0], dt[1] - 1 + 0, dt[2], 0, 0, 0);
                mycal.set(14, 0);
                return new Date(mycal.getTime().getTime());
            }
            case 2: {
                throw new SQLException("Invalid Date", "22008", 22008);
            }
        }
        throw new SQLException("Incorrect list format, unknown type: " + (this.m_aData[this.m_pos - 1] & 0xFF), "S1000");
    }

    synchronized Time getTime(int pos) throws SQLException {
        String s = this.getString(pos);
        if (s == null) {
            return null;
        }
        return Time.valueOf(s);
    }

    synchronized Time getTime(int pos, Calendar cal) throws SQLException {
        this.setReadPosition(pos);
        return this.getTime(true, cal);
    }

    synchronized Time getTime() throws SQLException {
        String s = this.getString();
        if (s == null) {
            return null;
        }
        int len = s.length();
        if (len == 8) {
            return Time.valueOf(s);
        }
        if (len < 8) {
            throw new SQLException("Invalid Time", "22008", 22008);
        }
        if (len >= 19) {
            return Time.valueOf(s.substring(11, 19));
        }
        throw new SQLException("Invalid Time", "22008", 22008);
    }

    synchronized Time getTime(Calendar cal) throws SQLException {
        return this.getTime(true, cal);
    }

    synchronized Time getTime(boolean useCalendar, Calendar cal) throws SQLException {
        int[] tm = new int[4];
        if (this.eltLength()) {
            return null;
        }
        switch (this.m_aData[this.m_pos++]) {
            case 1: {
                if (this.m_len >= 19) {
                    if (this.m_aData[this.m_pos + 10] != 32) {
                        throw new SQLException("Invalid Timestamp", "22008", 22008);
                    }
                    this.m_len -= 11;
                    this.m_pos += 11;
                }
                if (this.m_len >= 8) {
                    this.m_pos = ListUtil.readTimeb(this.m_aData, this.m_pos, this.m_len, tm);
                    Calendar mycal = (Calendar)cal.clone();
                    mycal.clear();
                    mycal.set(11, tm[0]);
                    mycal.set(12, tm[1]);
                    mycal.set(13, tm[2]);
                    mycal.set(14, tm[3] / 1000000);
                    return new Time(mycal.getTime().getTime());
                }
                throw new SQLException("Invalid Time", "22008", 22008);
            }
            case 2: {
                throw new SQLException("Invalid Date", "22008", 22008);
            }
        }
        throw new SQLException("Incorrect list format, unknown type: " + (this.m_aData[this.m_pos - 1] & 0xFF), "S1000");
    }

    synchronized boolean getBoolean(int pos) throws SQLException {
        this.setReadPosition(pos);
        return this.getBoolean();
    }

    synchronized boolean getBoolean() throws SQLException {
        if (this.eltLength()) {
            return false;
        }
        switch (this.m_aData[this.m_pos++]) {
            case 1: {
                long[] num = new long[1];
                this.m_pos = ListUtil.parsenumb(this.m_aData, this.m_pos, this.m_len, num);
                return num[0] != 0L;
            }
            case 4: {
                if (this.m_len < 8 || this.m_len == 8 && this.m_aData[this.m_pos + 7] > 0) {
                    return this.grabPosLong(this.m_pos, this.m_len) != 0L;
                }
                BigInteger myBigInt = this.grabBigInteger(this.m_pos, this.m_len, false);
                return !myBigInt.equals(new BigInteger("0"));
            }
            case 5: 
            case 7: {
                return true;
            }
            case 6: {
                return this.grabPosLong(this.m_pos, this.m_len) != 0L;
            }
            case 8: {
                throw new SQLException("Invalid boolean: item = IEEE DOUBLE", "22008", 22008);
            }
            case 2: {
                throw new SQLException("Invalid boolean: item = ITEM_UNICODE", "22008", 22008);
            }
        }
        throw new SQLException("Incorrect list format, unknown type: " + (this.m_aData[this.m_pos - 1] & 0xFF), "S1000");
    }

    synchronized Boolean getBooleanWrapper(int pos) throws SQLException {
        this.setReadPosition(pos);
        return this.getBooleanWrapper();
    }

    synchronized Boolean getBooleanWrapper() throws SQLException {
        boolean b = this.getBoolean();
        if (this.isNull) {
            return null;
        }
        return b;
    }

    synchronized short getShort(int pos) throws SQLException {
        this.setReadPosition(pos);
        return this.getShort();
    }

    synchronized short getShort() throws SQLException {
        if (this.eltLength()) {
            return 0;
        }
        switch (this.m_aData[this.m_pos++]) {
            case 1: {
                long[] num = new long[1];
                this.m_pos = ListUtil.parsenumb(this.m_aData, this.m_pos, this.m_len, num);
                return ListUtil.dblshort(this.m_pos, num[0]);
            }
            case 4: {
                return ListUtil.dblshort(0, this.grabPosLong(this.m_pos, this.m_len));
            }
            case 5: {
                return ListUtil.dblshort(0, this.grabNegLong(this.m_pos, this.m_len));
            }
            case 6: {
                return ListUtil.dblshort(this.m_aData[this.m_pos], this.grabPosLong(this.m_pos + 1, this.m_len - 1));
            }
            case 7: {
                return ListUtil.dblshort(this.m_aData[this.m_pos], this.grabNegLong(this.m_pos + 1, this.m_len - 1));
            }
            case 2: {
                throw new SQLException("Invalid number; item = ITEM_UNICODE", "22008", 22008);
            }
            case 8: {
                return (short)this.grabIEEEDouble(this.m_pos, this.m_len);
            }
        }
        throw new SQLException("Incorrect list format, unknown type: " + (this.m_aData[this.m_pos - 1] & 0xFF), "S1000");
    }

    synchronized Short getShortWrapper(int pos) throws SQLException {
        this.setReadPosition(pos);
        return this.getShortWrapper();
    }

    synchronized Short getShortWrapper() throws SQLException {
        short s = this.getShort();
        if (this.isNull) {
            return null;
        }
        return new Short(s);
    }

    synchronized BigDecimal getBigDecimalScale(int pos, int scale) throws SQLException {
        this.setReadPosition(pos);
        return this.getBigDecimalScale(scale);
    }

    synchronized BigDecimal getBigDecimalScale(int scale) throws SQLException {
        BigDecimal bgDec = this.getBigDecimal();
        if (bgDec == null) {
            return null;
        }
        BigDecimal ret = bgDec.setScale(scale, 5);
        return ret;
    }

    synchronized BigDecimal getBigDecimalAutoScale(int pos) throws SQLException {
        this.setReadPosition(pos);
        return this.getBigDecimalAutoScale();
    }

    synchronized BigDecimal getBigDecimalAutoScale() throws SQLException {
        BigDecimal bgDec = this.getBigDecimal();
        if (bgDec == null) {
            return null;
        }
        try {
            while (true) {
                bgDec = bgDec.setScale(bgDec.scale() - 1);
            }
        }
        catch (ArithmeticException arithmeticException) {
            return bgDec;
        }
    }

    synchronized byte getOneByte(int pos) throws SQLException {
        this.setReadPosition(pos);
        return this.getOneByte();
    }

    synchronized byte getOneByte() throws SQLException {
        if (this.eltLength()) {
            return 0;
        }
        switch (this.m_aData[this.m_pos++]) {
            case 1: {
                long[] num = new long[1];
                this.m_pos = ListUtil.parsenumb(this.m_aData, this.m_pos, this.m_len, num);
                return ListUtil.dblbyte(this.m_pos, num[0]);
            }
            case 4: {
                return ListUtil.dblbyte(0, this.grabPosLong(this.m_pos, this.m_len));
            }
            case 5: {
                return ListUtil.dblbyte(0, this.grabNegLong(this.m_pos, this.m_len));
            }
            case 6: {
                return ListUtil.dblbyte(this.m_aData[this.m_pos], this.grabPosLong(this.m_pos + 1, this.m_len - 1));
            }
            case 7: {
                return ListUtil.dblbyte(this.m_aData[this.m_pos], this.grabNegLong(this.m_pos + 1, this.m_len - 1));
            }
            case 8: {
                return (byte)this.grabIEEEDouble(this.m_pos, this.m_len);
            }
            case 2: {
                throw new SQLException("Invalid number; item = ITEM_UNICODE", "22008", 22008);
            }
        }
        throw new SQLException("Incorrect list format, unknown type: " + (this.m_aData[this.m_pos - 1] & 0xFF), "S1000");
    }

    synchronized int getInt(int pos) throws SQLException {
        this.setReadPosition(pos);
        return this.getInt();
    }

    synchronized int getInt() throws SQLException {
        if (this.eltLength()) {
            return 0;
        }
        switch (this.m_aData[this.m_pos++]) {
            case 1: {
                long[] num = new long[1];
                this.m_pos = ListUtil.parsenumb(this.m_aData, this.m_pos, this.m_len, num);
                return ListUtil.dblint(this.m_pos, num[0]);
            }
            case 4: {
                return ListUtil.dblint(0, this.grabPosLong(this.m_pos, this.m_len));
            }
            case 5: {
                return ListUtil.dblint(0, this.grabNegLong(this.m_pos, this.m_len));
            }
            case 6: {
                return ListUtil.dblint(this.m_aData[this.m_pos], this.grabPosLong(this.m_pos + 1, this.m_len - 1));
            }
            case 7: {
                return ListUtil.dblint(this.m_aData[this.m_pos], this.grabNegLong(this.m_pos + 1, this.m_len - 1));
            }
            case 8: {
                return (int)this.grabIEEEDouble(this.m_pos, this.m_len);
            }
            case 2: {
                throw new SQLException("Invalid number; item = ITEM_UNICODE", "22008", 22008);
            }
        }
        throw new SQLException("Incorrect list format, unknown type: " + (this.m_aData[this.m_pos - 1] & 0xFF), "S1000");
    }

    synchronized Integer getIntegerWrapper(int pos) throws SQLException {
        this.setReadPosition(pos);
        return this.getIntegerWrapper();
    }

    synchronized Integer getIntegerWrapper() throws SQLException {
        int i = this.getInt();
        if (this.isNull) {
            return null;
        }
        return new Integer(i);
    }

    synchronized long getLong(int pos) throws SQLException {
        this.setReadPosition(pos);
        return this.getLong();
    }

    synchronized long getLong() throws SQLException {
        if (this.eltLength()) {
            return 0L;
        }
        switch (this.m_aData[this.m_pos++]) {
            case 1: {
                long[] num = new long[1];
                this.m_pos = ListUtil.parsenumb(this.m_aData, this.m_pos, this.m_len, num);
                return ListUtil.dbllong(this.m_pos, num[0]);
            }
            case 4: {
                return this.grabPosLong(this.m_pos, this.m_len);
            }
            case 5: {
                return this.grabNegLong(this.m_pos, this.m_len);
            }
            case 6: {
                return ListUtil.dbllong(this.m_aData[this.m_pos], this.grabPosLong(this.m_pos + 1, this.m_len - 1));
            }
            case 7: {
                return ListUtil.dbllong(this.m_aData[this.m_pos], this.grabNegLong(this.m_pos + 1, this.m_len - 1));
            }
            case 8: {
                return (long)this.grabIEEEDouble(this.m_pos, this.m_len);
            }
            case 2: {
                throw new SQLException("Invalid number; item = ITEM_UNICODE", "22008", 22008);
            }
        }
        throw new SQLException("Incorrect list format, unknown type: " + (this.m_aData[this.m_pos - 1] & 0xFF), "S1000");
    }

    synchronized Long getLongWrapper(int pos) throws SQLException {
        this.setReadPosition(pos);
        return this.getLongWrapper();
    }

    synchronized Long getLongWrapper() throws SQLException {
        long l = this.getLong();
        if (this.isNull) {
            return null;
        }
        return new Long(l);
    }

    synchronized BigDecimal getBigDecimal(int pos) throws SQLException {
        this.setReadPosition(pos);
        return this.getBigDecimal();
    }

    synchronized BigDecimal getBigDecimal() throws SQLException {
        if (this.eltLength()) {
            return null;
        }
        switch (this.m_aData[this.m_pos++]) {
            case 1: {
                return ListUtil.parsedecb(this.m_aData, this.m_pos, this.m_len);
            }
            case 4: {
                return this.grabBigDecimal(this.m_pos, this.m_len, 0, false);
            }
            case 5: {
                return this.grabBigDecimal(this.m_pos, this.m_len, 0, true);
            }
            case 6: {
                return this.grabBigDecimal(this.m_pos + 1, this.m_len - 1, this.m_aData[this.m_pos], false);
            }
            case 7: {
                return this.grabBigDecimal(this.m_pos + 1, this.m_len - 1, this.m_aData[this.m_pos], true);
            }
            case 8: {
                return new BigDecimal(this.grabIEEEDouble(this.m_pos, this.m_len));
            }
            case 2: {
                throw new SQLException("Invalid number; item = ITEM_UNICODE", "22008", 22008);
            }
        }
        throw new SQLException("Incorrect list format, unknown type: " + (this.m_aData[this.m_pos - 1] & 0xFF), "S1000");
    }

    synchronized double getDouble(int pos) throws SQLException {
        this.setReadPosition(pos);
        return this.getDouble();
    }

    synchronized double getDouble() throws SQLException {
        if (this.eltLength()) {
            return 0.0;
        }
        switch (this.m_aData[this.m_pos++]) {
            case 1: {
                return ListUtil.parsedblb(this.m_aData, this.m_pos, this.m_len);
            }
            case 2: {
                return Double.parseDouble(this.grabUnicode());
            }
            case 4: {
                return this.grabPosLong(this.m_pos, this.m_len);
            }
            case 5: {
                return this.grabNegLong(this.m_pos, this.m_len);
            }
            case 6: {
                return ListUtil.dbl2dbl(this.m_aData[this.m_pos], this.grabPosLong(this.m_pos + 1, this.m_len - 1));
            }
            case 7: {
                return ListUtil.dbl2dbl(this.m_aData[this.m_pos], this.grabNegLong(this.m_pos + 1, this.m_len - 1));
            }
            case 8: {
                return this.grabIEEEDouble(this.m_pos, this.m_len);
            }
        }
        throw new SQLException("Incorrect list format, unknown type: " + (this.m_aData[this.m_pos - 1] & 0xFF), "S1000");
    }

    private double grabIEEEDouble(int pos, int len) throws SQLException {
        byte signByte = this.m_aData[pos + len - 1];
        boolean negative = signByte < 0;
        long longBits = negative ? this.grabNegLong(pos, len) : this.grabPosLong(pos, len);
        return Double.longBitsToDouble(longBits);
    }

    synchronized Double getDoubleWrapper(int pos) throws SQLException {
        this.setReadPosition(pos);
        return this.getDoubleWrapper();
    }

    synchronized Double getDoubleWrapper() throws SQLException {
        double d = this.getDouble();
        if (this.isNull) {
            return null;
        }
        return new Double(d);
    }

    synchronized float getFloat(int pos) throws SQLException {
        this.setReadPosition(pos);
        return this.getFloat();
    }

    synchronized float getFloat() throws SQLException {
        Float f = this.getFloatWrapper();
        if (f == null) {
            return 0.0f;
        }
        return f.floatValue();
    }

    synchronized Float getFloatWrapper(int pos) throws SQLException {
        this.setReadPosition(pos);
        return this.getFloatWrapper();
    }

    synchronized Float getFloatWrapper() throws SQLException {
        double d = this.getDouble();
        if (this.isNull) {
            return null;
        }
        return new Float(d);
    }

    private long grabPosLong(int i, int l) throws SQLException {
        long num = 0L;
        switch (l) {
            case 8: {
                num = (long)this.m_aData[i + 7] << 56;
                if (num < 0L) break;
            }
            case 7: {
                num |= ((long)this.m_aData[i + 6] & 0xFFL) << 48;
            }
            case 6: {
                num |= ((long)this.m_aData[i + 5] & 0xFFL) << 40;
            }
            case 5: {
                num |= ((long)this.m_aData[i + 4] & 0xFFL) << 32;
            }
            case 4: {
                num |= ((long)this.m_aData[i + 3] & 0xFFL) << 24;
            }
            case 3: {
                num |= (long)((this.m_aData[i + 2] & 0xFF) << 16);
            }
            case 2: {
                num |= (long)((this.m_aData[i + 1] & 0xFF) << 8);
            }
            case 1: {
                return num |= (long)(this.m_aData[i] & 0xFF);
            }
            case 0: {
                return 0L;
            }
        }
        throw new SQLException("Numeric value out of range", "22003", 22003);
    }

    private synchronized long grabNegLong(int i, int l) throws SQLException {
        switch (l) {
            case 8: {
                l = this.m_aData[i + 7] << 24 | (this.m_aData[i + 6] & 0xFF) << 16 | (this.m_aData[i + 5] & 0xFF) << 8 | this.m_aData[i + 4] & 0xFF;
                if (l < 0) break;
                throw new SQLException("Numeric value out of range", "22003", 22003);
            }
            case 7: {
                l = 0xFF000000 | (this.m_aData[i + 6] & 0xFF) << 16 | (this.m_aData[i + 5] & 0xFF) << 8 | this.m_aData[i + 4] & 0xFF;
                break;
            }
            case 6: {
                l = 0xFFFF0000 | (this.m_aData[i + 5] & 0xFF) << 8 | this.m_aData[i + 4] & 0xFF;
                break;
            }
            case 5: {
                l = 0xFFFFFF00 | this.m_aData[i + 4] & 0xFF;
                break;
            }
            case 4: {
                return (long)((this.m_aData[i + 3] & 0xFF) << 24 | (this.m_aData[i + 2] & 0xFF) << 16 | (this.m_aData[i + 1] & 0xFF) << 8 | this.m_aData[i] & 0xFF) | 0xFFFFFFFF00000000L;
            }
            case 3: {
                return (long)((this.m_aData[i + 2] & 0xFF) << 16 | (this.m_aData[i + 1] & 0xFF) << 8 | this.m_aData[i] & 0xFF) | 0xFFFFFFFFFF000000L;
            }
            case 2: {
                return (long)((this.m_aData[i + 1] & 0xFF) << 8 | this.m_aData[i] & 0xFF) | 0xFFFFFFFFFFFF0000L;
            }
            case 1: {
                return (long)(this.m_aData[i] & 0xFF) | 0xFFFFFFFFFFFFFF00L;
            }
            case 0: {
                return -1L;
            }
            default: {
                throw new SQLException("Numeric value out of range", "22003", 22003);
            }
        }
        i = (this.m_aData[i + 3] & 0xFF) << 24 | (this.m_aData[i + 2] & 0xFF) << 16 | (this.m_aData[i + 1] & 0xFF) << 8 | this.m_aData[i] & 0xFF;
        return (long)l << 32 | (long)i & 0xFFFFFFFFL;
    }

    private synchronized BigInteger grabBigInteger(int off, int len, boolean sign) {
        byte[] b;
        if (len == 0 || sign ^ this.m_aData[off + len - 1] < 0) {
            b = new byte[len + 1];
            b[0] = sign ? -1 : 0;
            for (int i = len; i > 0; --i) {
                b[i] = this.m_aData[off++];
            }
        } else {
            b = new byte[len];
            for (int i = len - 1; i >= 0; --i) {
                b[i] = this.m_aData[off++];
            }
        }
        return new BigInteger(b);
    }

    private BigDecimal grabBigDecimal(int offset, int len, int scale, boolean sign) {
        return ListUtil.remainingPositiveScale(this.grabBigInteger(offset, len, sign), scale);
    }

    synchronized SysList set(SysList value) throws SQLException {
        this.stuffList(value);
        return this;
    }

    synchronized SysList set(int value) throws SQLException {
        if (value < 0) {
            this.stuffNegInt(value);
        } else {
            this.stuffPosInt(value);
        }
        return this;
    }

    synchronized SysList set(long value) throws SQLException {
        if (value < 0L) {
            this.stuffNegLong(value);
        } else {
            this.stuffPosLong(value);
        }
        return this;
    }

    synchronized SysList set(double value) throws SQLException {
        if (this.connectionInfo.useIEEEDouble) {
            this.setIEEEDouble(value);
        } else {
            this.stuffAscii(String.valueOf(value));
        }
        return this;
    }

    synchronized SysList set(String s) throws SQLException {
        if (s == null) {
            this.setNull();
            return this;
        }
        if (s.length() == 0) {
            char[] c = new char[]{'\u0000'};
            this.stuff7BitAscii(new String(c));
            return this;
        }
        if (this.stuff7BitAscii(s)) {
            return this;
        }
        if (this.isUnicode() && this.isWide(s)) {
            this.stuffUnicode(s);
        } else {
            this.stuff8BitAscii(s);
        }
        return this;
    }

    synchronized void setAsciiString(String s) {
        if (s == null) {
            this.setNull();
            return;
        }
        int i = this.m_iLastOffset;
        int l = s.length();
        i = this.makeItem(i, l + 1);
        this.m_aData[i] = 1;
        s.getBytes(0, l, this.m_aData, i + 1);
    }

    synchronized SysList set(Date d) throws SQLException {
        return this.set(d.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized SysList set(Date d, Calendar cal) throws SQLException {
        SimpleDateFormat simpleDateFormat = m_sdfDate;
        synchronized (simpleDateFormat) {
            m_sdfDate.setCalendar(cal);
            return this.set(m_sdfDate.format(new java.util.Date(d.getTime())));
        }
    }

    synchronized SysList set(Time t) throws SQLException {
        return this.set(t.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized SysList set(Time t, Calendar cal) throws SQLException {
        SimpleDateFormat simpleDateFormat = m_sdfTime;
        synchronized (simpleDateFormat) {
            m_sdfTime.setCalendar(cal);
            return this.set(m_sdfTime.format(new java.util.Date(t.getTime())));
        }
    }

    synchronized SysList set(Timestamp ts) throws SQLException {
        return this.set(ts.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized SysList set(Timestamp ts, Calendar cal) throws SQLException {
        SimpleDateFormat simpleDateFormat = m_sdfTimestamp;
        synchronized (simpleDateFormat) {
            m_sdfTimestamp.setCalendar(cal);
            return this.set(m_sdfTimestamp.format(ts));
        }
    }

    synchronized SysList set(boolean b) throws SQLException {
        if (b) {
            this.stuffPosInt(1);
        } else {
            this.stuffPosInt(0);
        }
        return this;
    }

    void setMapOfDatatypes(Map x) throws SQLException {
        SysList list = SysList.wrapMapOfDatatypes(x, this.connectionInfo);
        this.set(list);
    }

    static SysList wrapMapOfDatatypes(Map x, ConnectionInfo connectionInfo) throws SQLException {
        SysList list = new SysList();
        list.setConnectionInfo(connectionInfo);
        SysList temp = new SysList();
        temp.setConnectionInfo(connectionInfo);
        for (Object key : x.keySet()) {
            temp.set((String)key);
            temp.setParameter(x.get(key));
            list.set(temp);
            temp.clearList();
        }
        return list;
    }

    void setListOfDatatypes(List x) throws SQLException {
        SysList list = SysList.wrapListOfDatatypes(x, this.connectionInfo);
        this.set(list);
    }

    static SysList wrapListOfDatatypes(List x, ConnectionInfo connectionInfo) throws SQLException {
        SysList list = new SysList();
        list.setConnectionInfo(connectionInfo);
        for (int i = 0; i < x.size(); ++i) {
            Object o = x.get(i);
            if (o instanceof Character) {
                list.set(((Character)o).charValue());
                continue;
            }
            list.setParameter(o);
        }
        return list;
    }

    static SysList wrapArrayOfDatatypes(Object x, ConnectionInfo connectionInfo) throws SQLException {
        SysList list = new SysList();
        list.setConnectionInfo(connectionInfo);
        int len = Array.getLength(x);
        for (int i = 0; i < len; ++i) {
            Object o = Array.get(x, i);
            if (o instanceof Character) {
                list.set(((Character)o).charValue());
                continue;
            }
            list.setParameter(o);
        }
        return list;
    }

    static SysList wrapCollectionOfDatatypes(Collection x, ConnectionInfo connectionInfo) throws SQLException {
        SysList list = new SysList();
        list.setConnectionInfo(connectionInfo);
        for (Object o : x) {
            if (o instanceof Character) {
                list.set(((Character)o).charValue());
                continue;
            }
            list.setParameter(o);
        }
        return list;
    }

    void setMapOfReferences(Map x) throws SQLException {
        SysList list = SysList.wrapMapOfReferences(x, this.connectionInfo);
        this.set(list);
    }

    static SysList wrapMapOfReferences(Map x, ConnectionInfo connectionInfo) throws SQLException {
        SysList list = new SysList();
        list.setConnectionInfo(connectionInfo);
        SysList temp = new SysList();
        temp.setConnectionInfo(connectionInfo);
        SysList temp2 = new SysList();
        temp2.setConnectionInfo(connectionInfo);
        for (Object key : x.keySet()) {
            temp.setParameter(x.get(key));
            temp2.set((String)key);
            temp2.set(temp);
            list.set(temp2);
            temp.clearList();
            temp2.clearList();
        }
        return list;
    }

    synchronized void setListOfReferences(List x) throws SQLException {
        SysList list = SysList.wrapListOfReferences(x, this.connectionInfo);
        this.set(list);
    }

    static SysList wrapListOfReferences(List x, ConnectionInfo connectionInfo) throws SQLException {
        SysList list = new SysList();
        list.setConnectionInfo(connectionInfo);
        SysList temp = new SysList();
        temp.setConnectionInfo(connectionInfo);
        for (int i = 0; i < x.size(); ++i) {
            temp.setParameter(x.get(i));
            list.set(temp);
            temp.clearList();
        }
        return list;
    }

    void unconditionalRewind() {
        this.m_iLastIndex = 0;
        this.m_iLastOffset = 0;
    }

    int setReadPosition(int pos) throws SQLException {
        int i;
        int p;
        block15: {
            if (pos == 0) {
                if (this.m_iLength == 0) {
                    throw new NoMoreDataException();
                }
                this.m_iLastIndex = 0;
                this.m_iLastOffset = this.m_header ? 14 : 0;
                return 0;
            }
            if (pos == this.m_iLastIndex) {
                if (this.m_iLastOffset == this.m_iLength) {
                    throw new NoMoreDataException();
                }
                return this.m_iLastIndex;
            }
            if (pos > this.m_iLastIndex) {
                p = this.m_iLastIndex;
                i = this.m_iLastOffset;
            } else {
                p = 0;
                i = this.m_header ? 14 : 0;
            }
            while (i < this.m_iLength) {
                if (this.m_aData[i] == 0) {
                    if (i + 3 > this.m_iLength) {
                        throw new SQLException("Incorrect list format: " + (i + 3) + " > " + this.m_iLength, "S1000");
                    }
                    int len = this.m_aData[i + 1] & 0xFF | (this.m_aData[i + 2] & 0xFF) << 8;
                    if (len == 0) {
                        if (i + 6 >= this.m_iLength) {
                            throw new SQLException("Incorrect List Format.", "S1000");
                        }
                        len = (this.m_aData[i + 3] & 0xFF | (this.m_aData[i + 4] & 0xFF) << 8 | (this.m_aData[i + 5] & 0xFF) << 16 | (this.m_aData[i + 6] & 0xFF) << 24) + 4;
                    }
                    i += len + 3;
                } else {
                    i += this.m_aData[i] & 0xFF;
                }
                if (++p != pos) continue;
                if (i > this.m_iLength) {
                    throw new SQLException("Incorrect list format: " + i + " > " + this.m_iLength, "S1000");
                }
                break block15;
            }
            if (i != this.m_iLength) {
                throw new SQLException("Incorrect list format: " + i + " > " + this.m_iLength, "S1000");
            }
            if (p < pos) {
                throw new NoMoreDataException();
            }
        }
        this.m_iLastIndex = p;
        this.m_iLastOffset = i;
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dumpData(OutputStream out, int count, LogFileStream logFile) throws IOException {
        SysList.write4ByteInt(this.m_aData, 4, count);
        SysList.write4ByteInt(this.m_aData, 0, this.m_iLength - 14);
        OutputStream outputStream = out;
        synchronized (outputStream) {
            out.write(this.m_aData, 0, this.m_iLength);
        }
        if (logFile != null) {
            logFile.dump(this.getm_aData(), 0, this.getLength(), 1, null);
        }
    }

    synchronized void writeData(OutputStream out) throws IOException {
        int len = this.m_iLength - 14;
        SysList.write4ByteInt(this.m_aData, 0, len);
        out.write(this.m_aData, 0, this.m_iLength);
    }

    synchronized int getCurrentOffset() {
        return this.m_iLastOffset;
    }

    synchronized SysList getOutputParameterList(int begin, int addNull) {
        if (0 == addNull) {
            SysList a = new SysList(this.m_aData, this.m_iLastOffset - begin, begin);
            a.setConnectionInfo(this.connectionInfo);
            return a;
        }
        SysList a = new SysList(this.m_aData, this.m_iLastOffset - begin, begin);
        a.setConnectionInfo(this.connectionInfo);
        a.stuffAscii("");
        return a;
    }

    synchronized void setUndefined() {
        if (this.m_iLength + 1 > this.m_aData.length) {
            this.ensureBuffer(this.m_iLength + 1);
        }
        this.m_aData[this.m_iLastOffset] = 1;
        ++this.m_iLength;
        ++this.m_iLastIndex;
        ++this.m_iLastOffset;
    }

    synchronized boolean isEnd() {
        return this.m_iLength == this.m_iLastOffset;
    }

    synchronized void isEndEx() throws NoMoreDataException {
        if (this.m_iLength == this.m_iLastOffset) {
            throw new NoMoreDataException();
        }
    }

    synchronized SysList getWire() {
        SysList t = new SysList(this.m_aData, this.m_iLength);
        t.setConnectionInfo(this.connectionInfo);
        return t;
    }

    synchronized SysList getSubWire() {
        SysList t = new SysList(this.m_aData, this.m_iLength - this.m_iLastOffset, this.m_iLastOffset);
        t.setConnectionInfo(this.connectionInfo);
        return t;
    }

    synchronized SysList setParameter(Object value, Object whatever) throws SQLException {
        if (value == null) {
            this.setNull();
            return this;
        }
        if (value instanceof Date) {
            this.set((Date)value, (Calendar)whatever);
            return this;
        }
        if (value instanceof Time) {
            this.set((Time)value, (Calendar)whatever);
            return this;
        }
        if (value instanceof Timestamp) {
            this.set((Timestamp)value, (Calendar)whatever);
            return this;
        }
        if (whatever instanceof Integer) {
            if (value instanceof Number) {
                this.setNumberWithScale((Number)value, (Integer)whatever);
                return this;
            }
            if (value instanceof String) {
                this.setNumberWithScale(new Double((String)value), (Integer)whatever);
                return this;
            }
            throw new SQLException("Type out of range", "S1003");
        }
        throw new SQLException("Type out of range " + value.getClass().getName() + " " + whatever.getClass().getName(), "S1003");
    }

    synchronized void setNumberWithScale(Number value, int scale) throws SQLException {
        this.set(new BigDecimal(value.toString()).setScale(scale, 1));
    }

    synchronized int get2ByteInt() {
        this.m_iLastOffset += 2;
        ++this.m_iLastIndex;
        return this.m_aData[this.m_iLastOffset - 2] & 0xFF | (this.m_aData[this.m_iLastOffset - 1] & 0xFF) << 8;
    }

    synchronized void set2ByteInt(int s) {
        this.m_aData[this.m_iLastOffset] = (byte)s;
        this.m_aData[this.m_iLastOffset + 1] = (byte)(s >> 8);
        this.m_iLastOffset += 2;
        this.m_iLength += 2;
    }

    synchronized int get4ByteInt() {
        this.m_iLastOffset += 4;
        ++this.m_iLastIndex;
        return this.m_aData[this.m_iLastOffset - 4] & 0xFF | (this.m_aData[this.m_iLastOffset - 3] & 0xFF) << 8 | (this.m_aData[this.m_iLastOffset - 2] & 0xFF) << 16 | (this.m_aData[this.m_iLastOffset - 1] & 0xFF) << 24;
    }

    synchronized void setMessageCount(int count) {
        SysList.write4ByteInt(this.m_aData, 4, count);
    }

    synchronized void writeHeader(byte[] type) {
        SysList.write4ByteInt(this.m_aData, 8, 0);
        this.m_aData[12] = type[0];
        this.m_aData[13] = type[1];
        this.m_iLastOffset = 14;
        this.m_iLength = 14;
        this.m_header = true;
    }

    synchronized void writeHeader(int statementID, byte[] type) {
        SysList.write4ByteInt(this.m_aData, 8, statementID);
        this.m_aData[12] = type[0];
        this.m_aData[13] = type[1];
        this.m_iLastOffset = 14;
        this.m_iLength = 14;
        this.m_header = true;
    }

    synchronized void writeContinuationHeader(int statementID, byte[] type, boolean setContinuation) {
        int len = this.m_iLength - 14;
        SysList.write4ByteInt(this.m_aData, 0, len);
        if (setContinuation) {
            SysList.write4ByteInt(this.m_aData, 8, statementID | Integer.MIN_VALUE);
        } else {
            SysList.write4ByteInt(this.m_aData, 8, statementID);
        }
        this.m_aData[12] = type[0];
        this.m_aData[13] = type[1];
        this.m_header = true;
    }

    synchronized void writeHeader(int count, int statementID, int error) {
        int len = this.m_iLength - 14;
        SysList.write4ByteInt(this.m_aData, 0, len);
        SysList.write4ByteInt(this.m_aData, 4, count);
        SysList.write4ByteInt(this.m_aData, 8, statementID);
        this.m_aData[12] = (byte)error;
        this.m_aData[13] = (byte)(error >> 8);
        this.m_header = true;
    }

    synchronized void reserveHeader() {
        this.m_aData[0] = 0;
        this.m_aData[1] = 0;
        this.m_aData[2] = 0;
        this.m_aData[3] = 0;
        this.m_aData[4] = 0;
        this.m_aData[5] = 0;
        this.m_aData[6] = 0;
        this.m_aData[7] = 0;
        this.m_aData[8] = 0;
        this.m_aData[9] = 0;
        this.m_aData[10] = 0;
        this.m_aData[11] = 0;
        this.m_aData[12] = 0;
        this.m_aData[13] = 0;
        this.m_iLastOffset = 14;
        this.m_iLength = 14;
        this.m_header = true;
    }

    synchronized void clearList() {
        this.m_iLength = 0;
        this.m_iLastIndex = 0;
        this.m_iLastOffset = 0;
        this.m_header = false;
    }

    synchronized Object next() throws SQLException {
        if (this.m_iLastOffset == this.m_iLength) {
            throw new NoMoreDataException();
        }
        int i = this.m_iLastOffset;
        int len = 0;
        if (this.m_aData[i] != 0) {
            len = this.m_aData[i] & 0xFF;
        } else if (i + 2 < this.m_iLength) {
            len = this.m_aData[i + 1] & 0xFF | (this.m_aData[i + 2] & 0xFF) << 8;
            len = len == 0 ? (i + 7 < this.m_iLength ? (this.m_aData[i + 3] & 0xFF | (this.m_aData[i + 4] & 0xFF) << 8 | (this.m_aData[i + 5] & 0xFF) << 16 | (this.m_aData[i + 6] & 0xFF) << 24) + 7 : 0) : (len += 3);
        }
        this.m_iLastOffset = i += len;
        ++this.m_iLastIndex;
        return null;
    }

    synchronized Object nextUnlessUndefined() throws SQLException {
        if (this.m_iLastOffset == this.m_iLength) {
            throw new NoMoreDataException();
        }
        if (this.m_aData[this.m_iLastOffset] == 1) {
            throw new SQLException("Output/Default parameter not assigned a value.", "S1000");
        }
        return this.next();
    }

    synchronized void initRowIndex(int count) {
        this.rowIndex = new int[count + 1];
        this.row = 0;
        this.colCount = count;
    }

    synchronized boolean indexRow(boolean partial) {
        int i = 0;
        int j = 0;
        if (this.row > 0) {
            this.currentRowOffset = this.rowIndex[this.colCount];
            this.currentRowIndex += this.colCount;
            i = this.currentRowOffset;
        } else if (partial) {
            if (this.rowIndex[0] <= 0) {
                this.rowIndex[0] = 0;
                i = 0;
                j = 0;
            } else {
                int oldOffset = this.rowIndex[0];
                for (int k = 0; k <= this.colCount; ++k) {
                    if (this.rowIndex[k] == -1) {
                        j = k;
                        i = this.rowIndex[k - 1];
                        break;
                    }
                    this.rowIndex[k] = this.rowIndex[k] - oldOffset;
                }
            }
        } else {
            this.currentRowOffset = this.m_iLastOffset;
            this.currentRowIndex = this.m_iLastIndex;
            i = this.currentRowOffset;
        }
        while (j <= this.colCount) {
            if (i == this.m_iLength) {
                this.m_iLastOffset = i;
                if (j == 1) {
                    this.m_iLastOffset = 0;
                }
                if (j > 1) {
                    this.m_iLastOffset = this.rowIndex[j - 2];
                }
                this.rowIndex[j] = -1;
                this.m_iLastIndex = this.currentRowIndex + j - 1;
                return false;
            }
            if (j == 0) {
                this.rowIndex[0] = i;
            } else {
                if (this.m_aData[i] != 0) {
                    i += this.m_aData[i] & 0xFF;
                } else if (this.m_aData[i + 1] == 0 && this.m_aData[i + 2] == 0) {
                    if (i + 6 < this.m_iLength) {
                        i += (this.m_aData[i + 3] & 0xFF | (this.m_aData[i + 4] & 0xFF) << 8 | (this.m_aData[i + 5] & 0xFF) << 16) + 7;
                    }
                } else if (i + 2 < this.m_iLength) {
                    i += (this.m_aData[i + 1] & 0xFF | (this.m_aData[i + 2] & 0xFF) << 8) + 3;
                }
                this.rowIndex[j] = i;
            }
            ++j;
        }
        ++this.row;
        return true;
    }

    synchronized boolean jump(int to) {
        this.m_iLastOffset = this.rowIndex[to - 1];
        this.m_iLastIndex = this.currentRowIndex + to - 1;
        return this.m_iLastOffset == this.m_iLength;
    }

    synchronized int advance(int from, int to) throws SQLException {
        int i = this.m_iLastOffset;
        while (from < to) {
            if (i == this.m_iLength) {
                this.m_iLastOffset = i;
                return from;
            }
            if (this.m_aData[i] != 0) {
                i += this.m_aData[i] & 0xFF;
            } else if (i + 2 < this.m_iLength) {
                int len = this.m_aData[i + 1] & 0xFF | (this.m_aData[i + 2] & 0xFF) << 8;
                if (len == 0) {
                    if (i + 6 >= this.m_iLength) {
                        throw new SQLException("Incorrect List Format.", "S1000");
                    }
                    len = (this.m_aData[i + 3] & 0xFF | (this.m_aData[i + 4] & 0xFF) << 8 | (this.m_aData[i + 5] & 0xFF) << 16 | (this.m_aData[i + 6] & 0xFF) << 24) + 4;
                }
                i += len + 3;
            } else {
                throw new SQLException("Incorrect List Format.", "S1000");
            }
            ++this.m_iLastIndex;
            ++from;
        }
        this.m_iLastOffset = i;
        return to;
    }

    synchronized boolean skip(int items) throws SQLException {
        int i = this.m_iLastOffset;
        for (int j = 0; j < items; ++j) {
            if (i == this.m_iLength) {
                this.m_iLastOffset = i;
                return false;
            }
            if (this.m_aData[i] != 0) {
                i += this.m_aData[i] & 0xFF;
            } else if (i + 2 < this.m_iLength) {
                int len = this.m_aData[i + 1] & 0xFF | (this.m_aData[i + 2] & 0xFF) << 8;
                if (len == 0) {
                    if (i + 6 >= this.m_iLength) {
                        throw new SQLException("Incorrect List Format", "S1000");
                    }
                    len = (this.m_aData[i + 3] & 0xFF | (this.m_aData[i + 4] & 0xFF) << 8 | (this.m_aData[i + 5] & 0xFF) << 16 | (this.m_aData[i + 6] & 0xFF) << 24) + 4;
                }
                i += len + 3;
            } else {
                throw new SQLException("Incorrect List Format", "S1000");
            }
            ++this.m_iLastIndex;
        }
        this.m_iLastOffset = i;
        return true;
    }

    synchronized void readData(InputStream in, int len) throws IOException {
        if (len + this.m_iLength > this.m_aData.length) {
            this.ensureBuffer(len + this.m_iLength);
        }
        int ptr = this.m_iLength;
        this.m_iLength += len;
        while (len > 0) {
            int cb = in.read(this.m_aData, ptr, len);
            ptr += cb;
            len -= cb;
        }
    }

    synchronized int resetFDRead() {
        if (this.NewRow) {
            this.m_iLastIndex = 0;
            this.m_iLastOffset = 0;
            this.m_iLength = 0;
            this.currentRowIndex = 0;
            this.currentRowOffset = 0;
            this.NewRow = false;
            this.row = 0;
            return 0;
        }
        if (this.currentRowOffset == 0) {
            return this.m_iLength;
        }
        int carryOver = this.m_iLength - this.currentRowOffset;
        System.arraycopy(this.m_aData, this.currentRowOffset, this.m_aData, 0, carryOver);
        this.m_iLength = carryOver;
        this.m_iLastIndex -= this.currentRowIndex;
        this.m_iLastOffset = carryOver;
        this.currentRowIndex = 0;
        this.currentRowOffset = 0;
        this.row = 0;
        return carryOver;
    }

    synchronized void resetRead() {
        this.m_iLastIndex = 0;
        this.m_iLastOffset = 0;
        this.m_iLength = 0;
        this.row = 0;
    }

    synchronized void saveCurrentRowPosition() {
        this.currentRowIndex = this.m_iLastIndex;
        this.currentRowOffset = this.m_iLastOffset;
    }

    synchronized void resetRow() {
        this.m_iLastIndex = this.currentRowIndex;
        this.m_iLastOffset = this.currentRowOffset;
    }

    synchronized void writeBatchCount(int count) {
        if (count == -1) {
            if (this.m_iLength + 4 > this.m_aData.length) {
                this.ensureBuffer(this.m_iLength + 4);
            }
            this.m_iLastOffset = 18;
            this.m_iLength = 18;
            return;
        }
        SysList.write4ByteInt(this.m_aData, 14, count);
    }

    final synchronized void writeInputStream(InputStream in, int len, int streamType, int sqlType) throws SQLException {
        try {
            int needed;
            int originalOffset = this.m_iLastOffset;
            this.m_iLength += 4;
            this.m_iLastOffset += 4;
            int n = needed = streamType == 0 ? this.m_iLength + len * 2 : this.m_iLength + len;
            if (needed > this.m_aData.length) {
                this.ensureBuffer(needed);
            }
            String locale = this.isUnicode() ? null : this.serverLocale;
            int bytes = SysList.writeStream(in, streamType, sqlType, this.m_aData, len, this.m_iLastOffset, originalOffset, locale);
            this.m_iLastOffset += bytes;
            this.m_iLength += bytes;
        }
        catch (IOException e) {
            throw new SQLException("Error writing stream: " + e.getMessage());
        }
    }

    final synchronized void writeReader(Reader reader, int len) throws SQLException {
        int startOffset = this.m_iLastOffset;
        this.m_iLength += 4;
        this.m_iLastOffset += 4;
        try {
            int needed;
            int chars = 0;
            int bytes = 0;
            int n = needed = this.isUnicode() ? len * 3 : len * 2;
            if (this.m_iLength + needed > this.m_aData.length) {
                this.ensureBuffer(this.m_iLength + needed);
            }
            char[] buffer = new char[32768];
            while (len > 0) {
                int charsread = len > 32768 ? 32768 : len;
                if ((charsread = reader.read(buffer, 0, charsread)) == -1) break;
                chars += charsread;
                len -= charsread;
                for (int i = 0; i < charsread; ++i) {
                    char c = buffer[i];
                    int n2 = ListUtil.getUTFBytes(c, this.m_aData, this.m_iLastOffset, this.m_aData.length - this.m_iLastOffset);
                    bytes += n2;
                    this.m_iLastOffset += n2;
                    if (n2 > 0) continue;
                    throw new SQLException("Buffer length is not enough", "S1000");
                }
            }
            this.m_iLength += bytes;
            this.m_aData[startOffset++] = (byte)chars;
            this.m_aData[startOffset++] = (byte)(chars >> 8);
            this.m_aData[startOffset++] = (byte)(chars >> 16);
            this.m_aData[startOffset++] = (byte)(chars >> 24);
        }
        catch (IOException e) {
            throw new SQLException("Error writing stream: " + e.getMessage());
        }
    }

    synchronized void setRawBytes(byte[] b) throws IOException {
        if (b.length + 14 > this.m_aData.length) {
            this.ensureBuffer(b.length + 14);
        }
        System.arraycopy(b, 0, this.m_aData, 14, b.length);
        this.m_iLastOffset += b.length;
        this.m_iLength += b.length;
    }

    public int getLength() {
        return this.m_iLength;
    }

    byte[] getm_aData() {
        return this.m_aData;
    }

    final int count() throws SQLException {
        int i = 0;
        int tempLen = this.m_iLength;
        while (this.skip(1)) {
            ++i;
        }
        this.m_iLastIndex = 0;
        this.m_iLastOffset = 0;
        this.m_iLength = tempLen;
        return i;
    }

    byte[] getData() {
        byte[] b = new byte[this.m_iLength];
        System.arraycopy(this.m_aData, 0, b, 0, this.m_iLength);
        return b;
    }

    byte[] getByteArray(int length) {
        byte[] b = new byte[length];
        System.arraycopy(this.m_aData, this.m_iLastOffset, b, 0, length);
        this.m_iLastOffset += length;
        return b;
    }

    void addRawBytes(byte[] b) {
        int newSize = this.m_iLength + b.length;
        if (newSize > this.m_aData.length) {
            this.ensureBuffer(newSize);
        }
        System.arraycopy(b, 0, this.m_aData, this.m_iLength, b.length);
        this.m_iLastOffset = newSize;
        this.m_iLength = newSize;
    }

    void addRawBytes(SysList s) {
        byte[] b = s.m_aData;
        int len = s.m_iLength;
        int newSize = this.m_iLength + len;
        if (newSize > this.m_aData.length) {
            this.ensureBuffer(newSize);
        }
        System.arraycopy(b, 0, this.m_aData, this.m_iLength, len);
        this.m_iLastOffset = newSize;
        this.m_iLength = newSize;
    }

    void setMaxFieldSize(int max) {
        this.maxFieldSize = max;
    }

    int getMaxFieldSize() {
        return this.maxFieldSize;
    }

    SysList append(SysList list) throws SQLException {
        int len = list.m_iLength;
        if (this.m_iLength + len > this.m_aData.length) {
            this.ensureBuffer(this.m_iLength + len);
        }
        System.arraycopy(list.m_aData, 0, this.m_aData, this.m_iLength, len);
        this.m_iLastOffset += len;
        this.m_iLength += len;
        return this;
    }

    SysList appendBytes(byte[] list2) throws SQLException {
        int len = list2.length;
        if (this.m_iLength + len > this.m_aData.length) {
            this.ensureBuffer(this.m_iLength + len);
        }
        System.arraycopy(list2, 0, this.m_aData, this.m_iLength, len);
        this.m_iLastOffset += len;
        this.m_iLength += len;
        return this;
    }

    synchronized SysList getWrappedItem() throws SQLException {
        return this.getSubList(1);
    }

    final synchronized SysList getSubList(int numItems) throws SQLException {
        int pos = this.m_iLastOffset;
        for (int i = 0; i < numItems; ++i) {
            this.eltLength();
        }
        int len = this.m_iLastOffset - pos;
        byte[] data = new byte[len];
        System.arraycopy(this.m_aData, pos, data, 0, len);
        SysList wi = new SysList(false, data);
        wi.setConnectionInfo(this.connectionInfo);
        return wi;
    }

    Object getParameter() throws SQLException {
        Object x = this.grabParameter();
        if (x instanceof byte[]) {
            byte[] b = (byte[])x;
            if (b.length == 0 && b[0] == 0) {
                return "";
            }
            try {
                return new String(b, this.serverLocale);
            }
            catch (UnsupportedEncodingException e) {
                throw new SQLException("Cannot convert using server locale: unsupported Encoding:" + this.serverLocale, "S2208");
            }
        }
        return x;
    }

    private Object grabParameter() throws SQLException {
        if (this.eltLength()) {
            return null;
        }
        switch (this.m_aData[this.m_pos++]) {
            case 1: {
                byte[] b = new byte[this.m_len];
                System.arraycopy(this.m_aData, this.m_pos, b, 0, this.m_len);
                return b;
            }
            case 2: {
                return this.grabUnicode();
            }
            case 4: {
                if (this.m_len < 4 || this.m_len == 4 && this.m_aData[this.m_pos + 3] > 0) {
                    return new Integer((int)this.grabPosLong(this.m_pos, this.m_len));
                }
                if (this.m_len < 8 || this.m_len == 8 && this.m_aData[this.m_pos + 7] > 0) {
                    return new Long(this.grabPosLong(this.m_pos, this.m_len));
                }
                return this.grabBigInteger(this.m_pos, this.m_len, false);
            }
            case 5: {
                if (this.m_len < 4 || this.m_len == 4 && this.m_aData[this.m_pos + 3] < 0) {
                    return new Integer((int)this.grabNegLong(this.m_pos, this.m_len));
                }
                if (this.m_len < 8 || this.m_len == 8 && this.m_aData[this.m_pos + 7] < 0) {
                    return new Long(this.grabNegLong(this.m_pos, this.m_len));
                }
                return this.grabBigInteger(this.m_pos, this.m_len, true);
            }
            case 6: {
                if (this.m_len < 9 || this.m_len == 9 && this.m_aData[this.m_pos + 8] > 0) {
                    return new Double(ListUtil.dbl2dbl(this.m_aData[this.m_pos], this.grabPosLong(this.m_pos + 1, this.m_len - 1)));
                }
                return this.grabBigDecimal(this.m_pos + 1, this.m_len - 1, this.m_aData[this.m_pos], false);
            }
            case 7: {
                if (this.m_len < 9 || this.m_len == 9 && this.m_aData[this.m_pos + 8] < 0) {
                    return new Double(ListUtil.dbl2dbl(this.m_aData[this.m_pos], this.grabNegLong(this.m_pos + 1, this.m_len - 1)));
                }
                return this.grabBigDecimal(this.m_pos + 1, this.m_len - 1, this.m_aData[this.m_pos], true);
            }
            case 8: {
                return new Double(this.grabIEEEDouble(this.m_pos, this.m_len));
            }
        }
        throw new SQLException("Incorrect list format, unknown type: " + (this.m_aData[this.m_pos - 1] & 0xFF), "S1003");
    }

    public boolean equals(Object o) {
        if (!(o instanceof SysList)) {
            return false;
        }
        SysList other = (SysList)o;
        if (this.m_iLength != other.m_iLength) {
            return false;
        }
        for (int i = 0; i < this.m_iLength; ++i) {
            if (this.m_aData[i] == other.m_aData[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.cloneMe().toString(true);
    }

    String toString(boolean ex) {
        int pos = this.m_iLastIndex;
        int mpos = this.m_pos;
        int mlen = this.m_len;
        int milen = this.m_iLength;
        StringBuffer sb = new StringBuffer();
        if (this.m_header) {
            this.verboseHeader(sb);
        }
        sb.append("$lb(");
        if (this.m_iLength == 0) {
            sb.append(")");
            return sb.toString();
        }
        try {
            this.setReadPosition(0);
            if (!this.isEnd()) {
                this.toStringBuffer(sb);
            }
            while (!this.isEnd()) {
                sb.append(',');
                this.toStringBuffer(sb);
            }
            sb.append(")");
        }
        catch (SQLException x) {
            if (ex) {
                sb.append("! Exception: ").append(x.getMessage());
            }
            try {
                sb = new StringBuffer(new String(this.m_aData, 0, this.m_iLength, this.serverLocale));
            }
            catch (UnsupportedEncodingException e) {
                sb = new StringBuffer(new String(this.m_aData, 0, this.m_iLength));
            }
        }
        try {
            this.m_pos = mpos;
            this.m_len = mlen;
            this.m_iLength = milen;
            this.setReadPosition(pos);
        }
        catch (SQLException x) {
            // empty catch block
        }
        return sb.toString();
    }

    private void verboseHeader(StringBuffer sb) {
        int len = SysList.read4ByteInt(this.m_aData, 0);
        int count = SysList.read4ByteInt(this.m_aData, 4);
        int id = SysList.read4ByteInt(this.m_aData, 8);
        sb.append('[').append(len).append(',').append(count).append(',').append(id).append(',').append((char)this.m_aData[12]).append((char)this.m_aData[13]).append(']');
    }

    private void toStringBuffer(StringBuffer sb) throws SQLException {
        Object x = this.grabParameter();
        if (x instanceof byte[]) {
            SysList s = new SysList((byte[])x);
            StringBuffer sb1 = new StringBuffer("$lb(");
            try {
                if (!s.isEnd()) {
                    s.toStringBuffer(sb1);
                }
                while (!s.isEnd()) {
                    sb1.append(',');
                    s.toStringBuffer(sb1);
                }
                sb1.append(')');
                sb.append(sb1);
            }
            catch (SQLException ex) {
                try {
                    sb.append(new String((byte[])x, this.serverLocale));
                }
                catch (UnsupportedEncodingException e) {
                    sb.append(new String((byte[])x));
                }
            }
        } else {
            sb.append(x);
        }
    }

    void moveToEnd() throws SQLException {
        int i = this.m_iLastOffset;
        while (i < this.m_iLength) {
            if (this.m_aData[i] == 0) {
                if (i + 3 > this.m_iLength) {
                    throw new SQLException("Incorrect list format: " + (i + 3) + " > " + this.m_iLength, "S1000");
                }
                int len = this.m_aData[i + 1] & 0xFF | (this.m_aData[i + 2] & 0xFF) << 8;
                if (len == 0) {
                    len = (this.m_aData[i += 3] & 0xFF | (this.m_aData[i + 1] & 0xFF) << 8 | (this.m_aData[i + 2] & 0xFF) << 16 | (this.m_aData[i + 3] & 0xFF) << 24) + 3;
                }
                i += len + 3;
            } else {
                i += this.m_aData[i] & 0xFF;
            }
            ++this.m_iLastIndex;
        }
        if (i != this.m_iLength) {
            throw new SQLException("Incorrect list format: " + i + " > " + this.m_iLength, "S1000");
        }
        this.m_iLastOffset = this.m_iLength;
    }

    SysList cloneMe() {
        SysList list = new SysList();
        list.setList(this.getData());
        list.m_iLength = this.m_iLength;
        list.m_iLastIndex = this.m_iLastIndex;
        list.m_iLastOffset = this.m_iLastOffset;
        list.m_len = this.m_len;
        list.m_pos = this.m_pos;
        list.m_header = this.m_header;
        list.currentRowIndex = this.currentRowIndex;
        list.currentRowOffset = this.currentRowOffset;
        list.maxFieldSize = this.maxFieldSize;
        list.setConnectionInfo(this.connectionInfo);
        return list;
    }

    synchronized void reset() {
        this.m_iLastIndex = 0;
        this.m_iLastOffset = 0;
    }

    synchronized void resetHeader() {
        this.m_iLastIndex = 0;
        this.m_iLastOffset = 14;
        this.m_iLength = 14;
        this.m_header = true;
    }

    public static int read4ByteInt(byte[] ba, int offset) {
        int val = ba[offset] & 0xFF;
        val |= (ba[offset + 1] & 0xFF) << 8;
        val |= (ba[offset + 2] & 0xFF) << 16;
        return val |= (ba[offset + 3] & 0xFF) << 24;
    }

    static void write4ByteInt(byte[] ba, int offset, int val) {
        ba[offset] = (byte)val;
        ba[offset + 1] = (byte)(val >> 8);
        ba[offset + 2] = (byte)(val >> 16);
        ba[offset + 3] = (byte)(val >> 24);
    }

    public int hashCode() {
        int result = 0;
        for (int i = 0; i < this.m_iLength; ++i) {
            result += 29 * this.m_aData[i];
        }
        return result;
    }

    public static int writeStream(InputStream in, int streamType, int sqlType, byte[] data, int len, int offset, int lengthOffest, String serverLocale) throws IOException {
        int bytesWritten;
        int charsRead = 0;
        if (streamType == 0) {
            int maxlen = data.length - offset - 1;
            byte[] buffer = new byte[32768];
            while (len > charsRead) {
                int charsread = len > 32768 ? 32768 : len - charsRead;
                if ((charsread = in.read(buffer, 0, charsread)) != -1) {
                    boolean resizeRequired = false;
                    for (int i = 0; i < charsread; ++i) {
                        int utf8bytes = ListUtil.getUTF8FromAscii(buffer, i, data, offset + bytesWritten, maxlen - bytesWritten, serverLocale);
                        if (utf8bytes == 0) {
                            resizeRequired = true;
                            break;
                        }
                        ++charsRead;
                        bytesWritten += utf8bytes;
                    }
                    if (!resizeRequired) continue;
                }
                break;
            }
        } else if (streamType == 1) {
            int bytes;
            for (bytesWritten = 0; len > bytesWritten && (bytes = in.read(data, offset + bytesWritten, len - bytesWritten)) != -1; bytesWritten += bytes) {
            }
            charsRead = bytesWritten;
        } else {
            throw new IOException("Unsupported Stream type: " + streamType);
        }
        if (lengthOffest >= 0) {
            data[lengthOffest] = (byte)charsRead;
            data[lengthOffest + 1] = (byte)(charsRead >> 8);
            data[lengthOffest + 2] = (byte)(charsRead >> 16);
            data[lengthOffest + 3] = (byte)(charsRead >> 24);
        }
        return bytesWritten;
    }

    public boolean isValid() {
        int offset;
        int count = 0;
        for (offset = 0; offset < this.m_iLength; ++offset) {
            int elemLength;
            ++count;
            if (this.m_aData[offset] == 0) {
                if (offset + 3 > this.m_iLength) {
                    return false;
                }
                elemLength = this.m_aData[offset + 1] & 0xFF | (this.m_aData[offset + 2] & 0xFF) << 8;
                offset += 3;
                if (elemLength == 0) {
                    elemLength = this.m_aData[offset] & 0xFF | (this.m_aData[offset + 1] & 0xFF) << 8 | (this.m_aData[offset + 2] & 0xFF) << 16 | (this.m_aData[offset + 3] & 0xFF) << 24;
                    offset += 4;
                }
                --elemLength;
            } else if (this.m_aData[offset] == 1) {
                ++offset;
                elemLength = 0;
            } else {
                elemLength = (this.m_aData[offset++] & 0xFF) - 2;
            }
            if (elemLength > 0 && (this.m_aData[offset] < 1 || this.m_aData[offset] > 8)) {
                return false;
            }
            if (offset + elemLength >= this.m_iLength) {
                return false;
            }
            offset += elemLength;
        }
        return offset == this.m_iLength;
    }

    static class NoMoreDataException
    extends SQLException {
        NoMoreDataException() {
            super("Invalid column number", "S1002");
        }
    }
}

