/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheBufferUtils;

class CacheMsgHeader {
    static final int HEADER_SIZE = 14;
    byte[] hBuffer;

    CacheMsgHeader() {
        this.hBuffer = new byte[14];
    }

    CacheMsgHeader(byte[] buffer) throws Exception {
        if (buffer.length != 14) {
            throw new Exception("CacheMsgHeader buffer must be 14 bytes!");
        }
        this.hBuffer = buffer;
    }

    static void setMessageLength(byte[] buffer, int value) {
        CacheBufferUtils.setRaw4ByteInt(buffer, 0, value);
    }

    int getMessageLength() {
        return CacheBufferUtils.get4ByteIntRaw(this.hBuffer, 0);
    }

    static void setCount(byte[] buffer, int value) {
        CacheBufferUtils.setRaw4ByteInt(buffer, 4, value);
    }

    int getCount() {
        return CacheBufferUtils.get4ByteIntRaw(this.hBuffer, 4);
    }

    static void setStatementID(byte[] buffer, int value) {
        CacheBufferUtils.setRaw4ByteInt(buffer, 8, value);
    }

    int getStatementID() {
        return CacheBufferUtils.get4ByteIntRaw(this.hBuffer, 8) & Integer.MAX_VALUE;
    }

    static void setMsgType(byte[] buffer, byte[] value) {
        buffer[12] = value[0];
        buffer[13] = value[1];
    }

    void setError(int value) {
        CacheBufferUtils.set2ByteIntRaw(this.hBuffer, 12, (short)value);
    }

    int getError() {
        return this.hBuffer[12] & 0xFF | (this.hBuffer[13] & 0xFF) << 8;
    }

    int getMsgType() {
        return this.hBuffer[12] & 0xFF | this.hBuffer[13] & 0xFF;
    }

    int getHighBit() {
        return CacheBufferUtils.get4ByteIntRaw(this.hBuffer, 8) & Integer.MIN_VALUE;
    }
}

