/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.dynamodb.exec;

import com.dbeaver.db.dynamodb.exec.DynamoBaseStatement;
import com.dbeaver.db.dynamodb.exec.DynamoResultIterable;
import com.dbeaver.db.dynamodb.exec.DynamoSQL;
import com.dbeaver.db.dynamodb.exec.DynamoSession;
import com.dbeaver.db.dynamodb.model.DynamoDataSource;
import com.dbeaver.db.dynamodb.model.DynamoTable;
import java.util.Iterator;
import net.sf.jsqlparser.expression.Expression;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.parser.SQLSemanticProcessor;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.paginators.ScanIterable;

public class DynamoScanStatement
extends DynamoBaseStatement {
    @NotNull
    private final DynamoTable table;
    @NotNull
    private ScanRequest scanRequest;
    protected Throwable executeError;
    @Nullable
    private DBDDataFilter dataFilter;
    @NotNull
    private DynamoResultIterable resultSet;

    public DynamoScanStatement(@NotNull DynamoSession session, @NotNull DynamoTable table) {
        super(session);
        this.table = table;
    }

    @Override
    @NotNull
    public DynamoTable getSourceEntity() {
        return this.table;
    }

    @NotNull
    public String getQueryString() {
        return "SELECT * FROM " + DBUtils.getObjectFullName((DBPNamedObject)this.table, (DBPEvaluationContext)DBPEvaluationContext.DML) + " -- scan";
    }

    public boolean executeStatement() throws DBCException {
        if (((DynamoSession)this.getSession()).isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementExecuteBegin((DBCStatement)this);
        }
        try {
            ScanRequest.Builder srBuilder = ScanRequest.builder().tableName(this.table.getName());
            long totalRows = this.limit;
            if (totalRows > 0L && this.offset > 0L) {
                totalRows += this.offset;
            }
            if (totalRows > 0L) {
                srBuilder.limit(Integer.valueOf((int)totalRows));
            }
            if (this.dataFilter != null && this.dataFilter.hasConditions()) {
                try {
                    this.addScanConditions(srBuilder, this.dataFilter);
                }
                catch (DBException e) {
                    throw new DBCException("Can't generate scan conditions", (Throwable)e);
                }
            }
            if (this.dataFilter != null && this.dataFilter.hasOrdering()) {
                Iterator e = this.dataFilter.getOrderConstraints().iterator();
                while (e.hasNext()) {
                    DBDAttributeConstraint cfr_ignored_0 = (DBDAttributeConstraint)e.next();
                }
            }
            ScanRequest scanRequest = (ScanRequest)srBuilder.build();
            ScanIterable scanResponses = ((DynamoDataSource)this.table.getDataSource()).getClient().scanPaginator(scanRequest);
            this.resultSet = new DynamoResultIterable(this, (Iterable<?>)scanResponses, totalRows);
            if (this.offset > 0L) {
                int i = 0;
                while ((long)i < this.offset) {
                    if (!this.resultSet.nextRow()) {
                        break;
                    }
                    ++i;
                }
            }
            return true;
        }
        finally {
            if (((DynamoSession)this.getSession()).isLoggingEnabled()) {
                QMUtils.getDefaultHandler().handleStatementExecuteEnd((DBCStatement)this, -1L, this.executeError);
            }
        }
    }

    @NotNull
    public DynamoResultIterable openResultSet() throws DBCException {
        return this.resultSet;
    }

    public void setDataFilter(@NotNull DBDDataFilter dataFilter) {
        this.dataFilter = dataFilter;
    }

    private void addScanConditions(@NotNull ScanRequest.Builder srBuilder, @NotNull DBDDataFilter dataFilter) throws DBException {
        StringBuilder condString = new StringBuilder();
        SQLUtils.appendConditionString((DBDDataFilter)dataFilter, (DBPDataSource)((DynamoSession)this.getSession()).getDataSource(), null, (StringBuilder)condString, (boolean)true);
        Expression expr = SQLSemanticProcessor.parseCondExpression((String)condString.toString());
        DynamoSQL.RequestConditionsInfo condition = DynamoSQL.preparePartialScanConditions(this.table, expr);
        if (condition.getFilterExpression().length() > 0) {
            srBuilder.filterExpression(condition.getFilterExpression());
        }
        if (!condition.getExprAttrNames().isEmpty()) {
            srBuilder.expressionAttributeNames(condition.getExprAttrNames());
        }
        if (!condition.getExprAttrValues().isEmpty()) {
            srBuilder.expressionAttributeValues(condition.getExprAttrValues());
        }
        if (!condition.getKeyValues().isEmpty()) {
            srBuilder.exclusiveStartKey(condition.getKeyValues());
        }
    }
}

