/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.auth.gcp.prefs;

import com.dbeaver.net.auth.gcp.AuthModelGCPPreferences;
import com.dbeaver.ui.auth.gcp.AuthModelGCPMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TextWithOpen;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFile;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.utils.HelpUtils;
import org.jkiss.dbeaver.utils.PrefUtils;

public class PrefPageGCPConfigurator
extends AbstractPrefPage
implements IWorkbenchPreferencePage {
    public static final String PAGE_ID = "com.dbeaver.preferences.gcp";
    private TextWithOpen gcpCliExecutablePath;

    public PrefPageGCPConfigurator() {
        this.setTitle("GCP preferences");
    }

    public void init(IWorkbench workbench) {
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Group cliGroup = UIUtils.createControlGroup((Composite)parent, (String)AuthModelGCPMessages.pref_gcp_config_cli_group, (int)2, (int)768, (int)0);
        UIUtils.createControlLabel((Composite)cliGroup, (String)AuthModelGCPMessages.pref_gcp_config_cli_executable_label);
        this.gcpCliExecutablePath = new TextWithOpenFile((Composite)cliGroup, AuthModelGCPMessages.pref_gcp_config_cli_executable_title, new String[]{"*.cmd", "*.sh", "*"}, true, false);
        this.gcpCliExecutablePath.setLayoutData((Object)new GridData(4, 1, true, false));
        this.gcpCliExecutablePath.setText(AuthModelGCPPreferences.getPreferences().getString("gcp.cli.executable"));
        UIUtils.createInfoLabel((Composite)cliGroup, (String)AuthModelGCPMessages.pref_gcp_config_cli_tip, (int)768, (int)2);
        Link ssoDocsLink = new Link((Composite)cliGroup, 0);
        ssoDocsLink.setText(NLS.bind((String)AuthModelGCPMessages.pref_gcp_config_cli_link, (Object)"<a>", (Object)"</a>"));
        ssoDocsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShellUtils.launchProgram((String)HelpUtils.getHelpExternalReference((String)"GCP-SSO"));
            }
        });
        return cliGroup;
    }

    protected void performDefaults() {
        this.gcpCliExecutablePath.setText("");
        super.performDefaults();
    }

    public boolean performOk() {
        DBPPreferenceStore store = AuthModelGCPPreferences.getPreferences();
        store.setValue("gcp.cli.executable", this.gcpCliExecutablePath.getText());
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
        return true;
    }
}

