/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.security;

import com.vertica.security.CertStoreResolver;
import com.vertica.support.ILogger;
import com.vertica.support.LogUtilities;
import java.io.File;

public class TrustStoreResolver
extends CertStoreResolver {
    public TrustStoreResolver(ILogger iLogger) {
        super(TrustStoreResolver.resolveDefaultPath(iLogger), TrustStoreResolver.resolveDefaultPassword(iLogger), true, iLogger);
    }

    public TrustStoreResolver(String string, String string2, ILogger iLogger) {
        super(string, string2, false, iLogger);
    }

    private static String resolveDefaultPath(ILogger iLogger) {
        String string = System.getProperty("javax.net.ssl.trustStore");
        if (string == null || string.equals("")) {
            File[] fileArray;
            String string2 = File.separator;
            String string3 = System.getProperty("java.home");
            for (File file : fileArray = new File[]{new File(string3 + string2 + "security" + string2 + "jssecacerts"), new File(string3 + string2 + "security" + string2 + "cacerts"), new File(string3 + string2 + "lib" + string2 + "security" + string2 + "jssecacerts"), new File(string3 + string2 + "lib" + string2 + "security" + string2 + "cacerts")}) {
                if (!file.exists()) continue;
                return file.getAbsolutePath();
            }
            if (iLogger != null) {
                LogUtilities.logWarning("cannot find truststore file in default location, will use empty store, might cause connection problem if TLS is enabled", iLogger);
            }
        }
        return string;
    }

    private static String resolveDefaultPassword(ILogger iLogger) {
        String string = System.getProperty("javax.net.ssl.trustStorePassword");
        if (iLogger != null) {
            LogUtilities.logDebug(String.format("default trustStore password %s is used", string), iLogger);
        }
        return System.getProperty("javax.net.ssl.trustStorePassword");
    }
}

