/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.common;

import com.vertica.dsi.core.impl.DSIDriver;
import com.vertica.dsi.core.impl.DSIDriverSingleton;
import com.vertica.dsi.core.interfaces.IConnection;
import com.vertica.dsi.core.interfaces.IStatement;
import com.vertica.dsi.dataengine.impl.DSISimpleRowCountResult;
import com.vertica.dsi.dataengine.interfaces.IArray;
import com.vertica.dsi.dataengine.interfaces.IColumn;
import com.vertica.dsi.dataengine.interfaces.IDataEngine;
import com.vertica.dsi.dataengine.interfaces.IErrorResult;
import com.vertica.dsi.dataengine.interfaces.IResultSet;
import com.vertica.dsi.dataengine.interfaces.IResults;
import com.vertica.dsi.dataengine.interfaces.IRowCountResult;
import com.vertica.dsi.dataengine.interfaces.IStreamQueryExecutor;
import com.vertica.dsi.dataengine.utilities.ColumnMetadata;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.dataengine.utilities.ExecutionContexts;
import com.vertica.dsi.dataengine.utilities.ExecutionResult;
import com.vertica.dsi.dataengine.utilities.ExecutionResultType;
import com.vertica.dsi.dataengine.utilities.Nullable;
import com.vertica.dsi.dataengine.utilities.ParameterGeneratedValues;
import com.vertica.dsi.dataengine.utilities.ParameterInputValue;
import com.vertica.dsi.dataengine.utilities.ParameterMetadata;
import com.vertica.dsi.dataengine.utilities.ParameterType;
import com.vertica.dsi.dataengine.utilities.TimeTz;
import com.vertica.dsi.dataengine.utilities.TimestampTz;
import com.vertica.dsi.dataengine.utilities.TypeMetadata;
import com.vertica.dsi.dataengine.utilities.TypeUtilities;
import com.vertica.dsi.exceptions.BadDefaultParamException;
import com.vertica.dsi.exceptions.IncorrectTypeException;
import com.vertica.dsi.exceptions.InputOutputException;
import com.vertica.dsi.utilities.DSIMessageKey;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.jdbc.common.SArray;
import com.vertica.jdbc.common.SConnection;
import com.vertica.jdbc.common.SForwardResultSet;
import com.vertica.jdbc.common.SParameterMetaData;
import com.vertica.jdbc.common.SResultSetMetaData;
import com.vertica.jdbc.common.SStatement;
import com.vertica.streams.parameters.AbstractParameterStream;
import com.vertica.streams.parameters.AsciiParameterStream;
import com.vertica.streams.parameters.BinaryParameterStream;
import com.vertica.streams.parameters.CharacterParameterStream;
import com.vertica.streams.parameters.UnicodeParameterStream;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogUtilities;
import com.vertica.support.Pair;
import com.vertica.support.conv.ConversionResult;
import com.vertica.support.conv.ExactNumConverter;
import com.vertica.support.exceptions.DataException;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.support.exceptions.ExceptionType;
import com.vertica.utilities.FunctionID;
import com.vertica.utilities.ReferenceEqualityWrapper;
import com.vertica.utilities.conversion.TypeConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class SPreparedStatement
extends SStatement
implements PreparedStatement {
    private static final Map<Integer, Set<Integer>> s_stringRepCompatibilityLookup = SPreparedStatement.initializeStringRepCompatibilityLookup();
    protected ArrayList<ParameterMetadata> m_parameterMetadata;
    protected final int m_numParameters;
    protected List<ParameterType> m_parameterTypes;
    protected Map<Integer, DataWrapper> m_parameterInputValues = new TreeMap<Integer, DataWrapper>();
    protected Map<Integer, AbstractParameterStream> m_parameterInputStreamData = new TreeMap<Integer, AbstractParameterStream>();
    protected boolean m_hasParameterBatch = false;
    protected List<Map<Integer, DataWrapper>> m_batchParameterInputValues = new ArrayList<Map<Integer, DataWrapper>>();
    protected List<Map<Integer, AbstractParameterStream>> m_batchParameterInputStreamData = new ArrayList<Map<Integer, AbstractParameterStream>>();
    private final List<Pair<Integer, SQLException>> m_batchParamConversionExceptions = new ArrayList<Pair<Integer, SQLException>>();
    private int m_numSuccessfulBatches = 0;
    protected String m_preparedSql = "";
    protected SResultSetMetaData m_metadata = null;
    protected SParameterMetaData m_openParamMetaData = null;
    private List<DataWrapper> m_cachedDataWrappers = null;
    private boolean m_supportStreamingBatches = false;
    private HashSet<ReferenceEqualityWrapper> m_currExecutionStreamSet = new HashSet();
    private HashSet<ReferenceEqualityWrapper> m_lastStreamsExecuted = new HashSet();
    private int m_nextParamSetForStream = 0;
    protected HashMap<Integer, TypeMetadata> m_setMetadata;
    protected boolean m_isSetMetadataFinal = false;
    private final int UNKNOWN_TYPE = 2000;

    protected SPreparedStatement(String sql, IStatement statement, SConnection conn, int concurrency) throws SQLException {
        super(statement, conn, concurrency);
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, sql, statement, conn);
            this.m_preparedSql = sql;
            this.checkIfNullSQL(sql);
            IDataEngine dataEngine = this.m_statement.createDataEngine();
            if (this.m_escapeProcessingEnabled && DSIDriverSingleton.getInstance().getProperty(10).getInt() == 1) {
                sql = conn.nativeSQL(sql);
            }
            this.m_warningListener.clearAndSetFunction(FunctionID.STATEMENT_PREPARE);
            this.replaceQueryExecutor(dataEngine, dataEngine.prepare(sql));
            this.m_parameterMetadata = this.m_queryExecutor.getMetadataForParameters();
            if (null == this.m_parameterMetadata) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.NULL_PARAM_METADATA, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            }
            this.m_numParameters = this.m_parameterMetadata.size();
            this.m_setMetadata = new HashMap();
            this.m_cachedDataWrappers = new ArrayList<DataWrapper>(this.m_numParameters);
            this.m_parameterTypes = new ArrayList<ParameterType>(this.m_numParameters);
            boolean areMaxValuesNotSet = true;
            for (int i = 0; i < this.m_numParameters; ++i) {
                ParameterMetadata paramMeta = this.m_parameterMetadata.get(i);
                if (areMaxValuesNotSet && paramMeta.getTypeMetadata().isCharacterOrBinaryType()) {
                    areMaxValuesNotSet = false;
                    this.m_parentConnection.setMaxTypeValues();
                }
                this.m_parameterTypes.add(paramMeta.getParameterType());
                this.m_cachedDataWrappers.add(new DataWrapper());
            }
            this.checkParameters(this.m_parameterMetadata);
            this.clearParameters();
            if (this.m_parentConnection.getConnection().getProperty(1006).getString().equals("Y")) {
                if (!(this.m_queryExecutor instanceof IStreamQueryExecutor)) {
                    this.getLogger().logWarning("com.vertica.jdbc.common", "SPreparedStatement", "SPreparedStatement", "ConnPropertyKey.DSI_SUPPORTS_STREAMED_BATCH_PREPARED_STMTS is set to 'Y', but IStreamQueryExecutor interface is not implemented. Batched parameters will not be streamed.");
                } else {
                    this.m_supportStreamingBatches = true;
                }
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void addBatch() throws SQLException {
        block9: {
            try {
                LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
                this.checkIfOpen();
                this.m_queryExecutor.clearCancel();
                if (!this.allInputParameterValuesPopulated()) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_NUMBER_PARAMS, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
                }
                this.updateParameterMetadata();
                this.m_cachedDataWrappers.clear();
                for (int i = 0; i < this.m_numParameters; ++i) {
                    this.m_cachedDataWrappers.add(new DataWrapper());
                }
                this.m_hasParameterBatch = true;
                if (!this.m_supportStreamingBatches) {
                    this.m_batchParameterInputValues.add(this.m_parameterInputValues);
                    this.m_batchParameterInputStreamData.add(this.m_parameterInputStreamData);
                    this.m_parameterInputValues = new TreeMap<Integer, DataWrapper>(this.m_parameterInputValues);
                    this.m_parameterInputStreamData = new TreeMap<Integer, AbstractParameterStream>();
                    break block9;
                }
                IStreamQueryExecutor sb_queryExecutor = (IStreamQueryExecutor)this.m_queryExecutor;
                if (0 == this.m_nextParamSetForStream) {
                    this.m_batchParamConversionExceptions.clear();
                    this.m_warningListener.clearAndSetFunction(FunctionID.STATEMENT_EXECUTE);
                    this.m_parentConnection.beginTransaction();
                    this.clearResults();
                    ++this.m_nextParamSetForStream;
                }
                ArrayList<ParameterInputValue> inputValues = null;
                try {
                    inputValues = this.getInputParameterValues(this.m_parameterInputValues, this.m_parameterInputStreamData);
                }
                catch (SQLException e) {
                    this.m_batchParamConversionExceptions.add(new Pair<Integer, SQLException>(this.m_numSuccessfulBatches, e));
                    this.m_numSuccessfulBatches = 0;
                }
                if (inputValues != null) {
                    sb_queryExecutor.startParamSet(inputValues, this.m_warningListener);
                    this.pushClearSingleBatchSetStreams();
                    sb_queryExecutor.finalizeParamSet(this.m_warningListener);
                    ++this.m_numSuccessfulBatches;
                }
            }
            catch (Exception e) {
                throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
            }
        }
    }

    @Override
    public synchronized void addBatch(String sql) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, sql);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void clearBatch() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
        this.doClearBatch();
    }

    private void doClearBatch() throws SQLException {
        try {
            this.m_isSetMetadataFinal = false;
            this.m_setMetadata.clear();
            for (int i = 0; i < this.m_batchParameterInputValues.size(); ++i) {
                this.clearParameters(this.m_batchParameterInputValues.get(i), this.m_batchParameterInputStreamData.get(i));
            }
            this.clearParameters(this.m_parameterInputValues, this.m_parameterInputStreamData);
            if (null != this.m_queryExecutor) {
                if (this.m_supportStreamingBatches) {
                    IStreamQueryExecutor sb_queryExecutor = (IStreamQueryExecutor)this.m_queryExecutor;
                    this.m_nextParamSetForStream = 0;
                    this.m_numSuccessfulBatches = 0;
                    sb_queryExecutor.clearBatch();
                } else {
                    this.m_queryExecutor.clearPushedParamData();
                    this.m_batchParameterInputStreamData.clear();
                    this.m_batchParameterInputValues.clear();
                }
            }
            this.m_hasParameterBatch = false;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void clearParameters() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            this.m_isSetMetadataFinal = false;
            this.m_setMetadata.clear();
            this.clearParameters(this.m_parameterInputValues, this.m_parameterInputStreamData);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void close() throws SQLException {
        try {
            this.doClearBatch();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        super.close();
        if (null != this.m_queryExecutor) {
            this.m_queryExecutor.close();
            this.m_queryExecutor = null;
        }
        if (null != this.m_metadata) {
            this.m_metadata = null;
        }
        if (null != this.m_openParamMetaData) {
            this.m_openParamMetaData.close();
        }
    }

    @Override
    public synchronized boolean execute() throws SQLException {
        try {
            boolean hasResultSet;
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            this.m_queryExecutor.clearCancel();
            if (this.m_hasParameterBatch) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.BATCH_NOT_EMPTY, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
            }
            if (!this.allInputParameterValuesPopulated()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_NUMBER_PARAMS, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
            }
            if (!this.m_lastStreamsExecuted.isEmpty()) {
                throw new InputOutputException(1, JDBCMessageKey.STREAM_REUSED.name());
            }
            this.updateParameterMetadata();
            this.m_parentConnection.beginTransaction();
            this.m_warningListener.clearAndSetFunction(FunctionID.STATEMENT_EXECUTE);
            this.pushParameterStreams();
            this.clearResults();
            IResults execResults = this.executeWithParams(this.m_parameterMetadata, this.getInputParameterValues(), this.m_generatedParams, SStatement.ThrowCondition.None);
            this.m_resultIterator = execResults.getResultItr();
            if (!this.m_resultIterator.hasNext()) {
                boolean bl = false;
                return bl;
            }
            ExecutionResult execResult = this.moveToNextResult();
            this.addResultPair(this.createResultPair(execResult));
            SStatement.ResultContext firstContext = (SStatement.ResultContext)this.m_resultSets.get(0);
            if (ExecutionResultType.ERROR_RESULT_SET == firstContext.m_resultType || ExecutionResultType.ERROR_ROW_COUNT == firstContext.m_resultType) {
                throw ((IErrorResult)firstContext.m_result).getError();
            }
            boolean bl = hasResultSet = ExecutionResultType.RESULT_SET == firstContext.m_resultType;
            if (hasResultSet) {
                this.setResultSetMetadata(this.createResultSetMetaData((IResultSet)execResult.getResult()));
            }
            boolean bl2 = hasResultSet;
            return bl2;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
        finally {
            this.m_isSetMetadataFinal = false;
        }
    }

    @Override
    public synchronized boolean execute(String sql) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, sql);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, sql, autoGeneratedKeys);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized boolean execute(String sql, int[] columnIndexes) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, sql, columnIndexes);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized boolean execute(String sql, String[] columnNames) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, sql, columnNames);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int[] executeBatch() throws SQLException, BatchUpdateException {
        this.m_numSuccessfulBatches = 0;
        try {
            BatchExecResult result = this.executePreparedAnyBatch();
            switch (result) {
                case BATCH_EXEC_NO_BATCHES: {
                    return new int[0];
                }
                case BATCH_EXEC_SUCCEEDED: {
                    return this.processBatchResults(this.m_queryExecutor.getResults(), this.m_batchParamConversionExceptions, SStatement.BatchType.MULTI_PARAM_SET);
                }
                case BATCH_EXEC_ALL_FAILED_INPUT_CONVERSION: {
                    return this.processBatchResults(null, this.m_batchParamConversionExceptions, SStatement.BatchType.MULTI_PARAM_SET);
                }
            }
            throw new RuntimeException("Invalid enum value: " + result.name());
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    private ExecutionContexts createExecutionContextsForBatchExec() {
        int batchInputSize = this.m_batchParameterInputValues.size();
        ArrayList<ArrayList<ParameterInputValue>> inputParamValues = new ArrayList<ArrayList<ParameterInputValue>>(batchInputSize);
        this.m_batchParamConversionExceptions.clear();
        int successfulParamsets = 0;
        for (int i = 0; i < batchInputSize; ++i) {
            try {
                inputParamValues.add(this.getInputParameterValues(this.m_batchParameterInputValues.get(i), this.m_batchParameterInputStreamData.get(i)));
                ++successfulParamsets;
                continue;
            }
            catch (SQLException e) {
                this.m_batchParamConversionExceptions.add(new Pair<Integer, SQLException>(successfulParamsets, e));
                successfulParamsets = 0;
            }
        }
        if (inputParamValues.isEmpty()) {
            return null;
        }
        return new ExecutionContexts(this.m_parameterMetadata, inputParamValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized BatchExecResult executePreparedAnyBatch() throws SQLException, BatchUpdateException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            Object object = this.m_cancelLock;
            synchronized (object) {
                this.m_isInCancelableFunction = true;
            }
            if (!this.m_lastStreamsExecuted.isEmpty()) {
                throw new InputOutputException(1, JDBCMessageKey.STREAM_REUSED.name());
            }
            this.m_queryExecutor.clearCancel();
            if (!this.m_supportStreamingBatches) {
                this.m_parentConnection.beginTransaction();
                this.m_warningListener.clearAndSetFunction(FunctionID.STATEMENT_EXECUTE);
                this.clearResults();
                if (!this.m_hasParameterBatch && 0 < this.m_numParameters) {
                    this.addResultPair(new SStatement.ResultContext(new DSISimpleRowCountResult(0L)));
                    object = BatchExecResult.BATCH_EXEC_NO_BATCHES;
                    return object;
                }
                this.pushBatchParameterStreams();
                ExecutionContexts execContexts = this.createExecutionContextsForBatchExec();
                if (execContexts == null) {
                    object = BatchExecResult.BATCH_EXEC_ALL_FAILED_INPUT_CONVERSION;
                    return object;
                }
                object = this.m_cancelLock;
                synchronized (object) {
                    if (this.m_isCanceled) {
                        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.OPERATION_CANCELED, (IWarningListener)this.m_warningListener, ExceptionType.TRANSIENT, new Object[0]);
                    }
                }
                this.m_queryExecutor.execute(execContexts, this.m_warningListener);
            } else {
                this.m_currExecutionStreamSet.clear();
                this.m_queryExecutor.finalizePushedParamData();
                IStreamQueryExecutor sb_queryExecutor = (IStreamQueryExecutor)this.m_queryExecutor;
                if (!this.m_hasParameterBatch && 0 < this.m_numParameters) {
                    this.clearResults();
                    this.addResultPair(new SStatement.ResultContext(new DSISimpleRowCountResult(0L)));
                    BatchExecResult batchExecResult = BatchExecResult.BATCH_EXEC_NO_BATCHES;
                    return batchExecResult;
                }
                Object object2 = this.m_cancelLock;
                synchronized (object2) {
                    if (this.m_isCanceled) {
                        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.OPERATION_CANCELED, (IWarningListener)this.m_warningListener, ExceptionType.TRANSIENT, new Object[0]);
                    }
                }
                sb_queryExecutor.execute(this.m_warningListener);
            }
            object = BatchExecResult.BATCH_EXEC_SUCCEEDED;
            return object;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
        finally {
            Object object = this.m_cancelLock;
            synchronized (object) {
                this.m_isCanceled = false;
                this.m_isInCancelableFunction = false;
            }
            this.clearBatch();
        }
    }

    @Override
    public synchronized ResultSet executeQuery() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            this.m_queryExecutor.clearCancel();
            if (this.m_hasParameterBatch) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.BATCH_NOT_EMPTY, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
            }
            if (!this.allInputParameterValuesPopulated()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_NUMBER_PARAMS, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
            }
            if (!this.m_lastStreamsExecuted.isEmpty()) {
                throw new InputOutputException(1, JDBCMessageKey.STREAM_REUSED.name());
            }
            this.updateParameterMetadata();
            this.m_parentConnection.beginTransaction();
            this.m_warningListener.clearAndSetFunction(FunctionID.STATEMENT_EXECUTE);
            this.pushParameterStreams();
            this.clearResults();
            long stateMachineMode = DSIDriverSingleton.getInstance().getProperty(36).getLong();
            IResults execResults = this.executeWithParams(this.m_parameterMetadata, this.getInputParameterValues(), this.m_generatedParams, SPreparedStatement.GetConditionForAfterPrepare(stateMachineMode, true));
            this.m_resultIterator = execResults.getResultItr();
            ExecutionResult execResult = this.checkAndMoveToNextResult(this.m_preparedSql, execResults, SPreparedStatement.GetConditionForAfterExecute(stateMachineMode, true));
            if (ExecutionResultType.ERROR_RESULT_SET == execResult.getType()) {
                this.addResultPair(this.createResultPair(execResult));
                throw ((IErrorResult)execResult.getResult()).getError();
            }
            this.setResultSetMetadata(this.createResultSetMetaData((IResultSet)execResult.getResult()));
            ResultSet resultSet = this.createResultSet(execResult);
            ((SForwardResultSet)resultSet).initializeColumnNameMap();
            this.addResultSet(resultSet);
            ResultSet resultSet2 = resultSet;
            return resultSet2;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
        finally {
            this.m_isSetMetadataFinal = false;
        }
    }

    @Override
    public synchronized ResultSet executeQuery(String sql) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, sql);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int executeUpdate() throws SQLException {
        return this.executeAnyUpdate();
    }

    public synchronized int executeAnyUpdate() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            this.m_queryExecutor.clearCancel();
            if (this.m_hasParameterBatch) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.BATCH_NOT_EMPTY, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
            }
            if (!this.allInputParameterValuesPopulated()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_NUMBER_PARAMS, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
            }
            if (!this.m_lastStreamsExecuted.isEmpty()) {
                throw new InputOutputException(1, JDBCMessageKey.STREAM_REUSED.name());
            }
            this.updateParameterMetadata();
            this.m_parentConnection.beginTransaction();
            this.m_warningListener.clearAndSetFunction(FunctionID.STATEMENT_EXECUTE);
            this.pushParameterStreams();
            this.clearResults();
            long stateMachineMode = DSIDriverSingleton.getInstance().getProperty(36).getLong();
            IResults execResults = this.executeWithParams(this.m_parameterMetadata, this.getInputParameterValues(), this.m_generatedParams, SPreparedStatement.GetConditionForAfterPrepare(stateMachineMode, false));
            this.m_resultIterator = execResults.getResultItr();
            ExecutionResult execResult = this.checkAndMoveToNextResult(this.m_preparedSql, execResults, SPreparedStatement.GetConditionForAfterExecute(stateMachineMode, false));
            if (ExecutionResultType.ERROR_ROW_COUNT == execResult.getType()) {
                this.addResultPair(this.createResultPair(execResult));
                throw ((IErrorResult)execResult.getResult()).getError();
            }
            IRowCountResult result = (IRowCountResult)execResult.getResult();
            this.addResultPair(this.createResultPair(execResult));
            if (result.hasRowCount()) {
                long rc = result.getRowCount();
                int n = rc > Integer.MAX_VALUE ? -2 : (int)rc;
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
        finally {
            this.m_isSetMetadataFinal = false;
        }
    }

    @Override
    public synchronized int executeUpdate(String sql) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, sql);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, sql, autoGeneratedKeys);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, sql, columnIndexes);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized int executeUpdate(String sql, String[] columnNames) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, sql, columnNames);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_STMT_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public abstract ResultSetMetaData getMetaData() throws SQLException;

    public SResultSetMetaData getResultSetMetaData() {
        return this.m_metadata;
    }

    @Override
    public abstract ParameterMetaData getParameterMetaData() throws SQLException;

    @Override
    public synchronized void setArray(int parameterIndex, Array value) throws SQLException {
        block6: {
            try {
                IArray dsiArray;
                LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex, value);
                this.checkIfOpen();
                this.checkValidParameterIndex(parameterIndex);
                SArray dsiArr = (SArray)value;
                if (null == value) {
                    this.setNull(parameterIndex, 2003);
                    break block6;
                }
                IArray iarray = dsiArr.getDSIArray();
                TypeMetadata metadata = TypeUtilities.getNestedMetadata(iarray);
                Object[] elements = TypeConverter.convertToObjectArray(value.getArray());
                IConnection conn = this.getParentConnection().getConnection();
                try {
                    dsiArray = conn.createArrayOf(metadata.getTypeName(), elements);
                }
                catch (DataException e) {
                    dsiArray = conn.createArrayOf(TypeUtilities.sqlTypeToString(metadata.getType()), elements);
                }
                DataWrapper data = this.m_cachedDataWrappers.get(parameterIndex - 1);
                data.setArray(dsiArray);
                this.setParameterInputData(parameterIndex, data);
                if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(parameterIndex - 1)) {
                    TypeMetadata arrayTypeMetadata = TypeMetadata.createTypeMetadata(2003);
                    TypeMetadata baseTypeMetadata = dsiArray.getBaseColumn().getTypeMetadata();
                    ArrayList<IColumn> nestedColumnMetadataList = new ArrayList<IColumn>();
                    ColumnMetadata nestedColumnMetadata = new ColumnMetadata(baseTypeMetadata);
                    nestedColumnMetadataList.add(nestedColumnMetadata);
                    arrayTypeMetadata.setNestedColumnList(nestedColumnMetadataList);
                    this.m_setMetadata.put(parameterIndex - 1, arrayTypeMetadata);
                }
            }
            catch (Exception e) {
                throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
            }
        }
    }

    @Override
    public synchronized void setAsciiStream(int parameterIndex, InputStream value, int length) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex, value, length);
            this.checkIfOpen();
            this.checkValidParameterIndex(parameterIndex);
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(parameterIndex - 1)) {
                this.m_setMetadata.put(parameterIndex - 1, TypeMetadata.createTypeMetadata(-1));
            } else if (TypeConverter.canConvertStreamTo(this.m_setMetadata.get(parameterIndex - 1).getType(), -1)) {
                this.m_setMetadata.put(parameterIndex - 1, TypeMetadata.createTypeMetadata(-1));
            }
            if (null == value) {
                this.setNull(parameterIndex, this.m_setMetadata.get(parameterIndex - 1).getType());
            } else {
                AsciiParameterStream stream = new AsciiParameterStream(value, length);
                this.setParameterInputStream(parameterIndex, stream);
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setBigDecimal(int parameterIndex, BigDecimal value) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex, value);
            this.checkIfOpen();
            this.checkValidParameterIndex(parameterIndex);
            TypeMetadata t = this.createExactNumMetadata(value, 2);
            if (null == value) {
                this.setNull(parameterIndex, 2);
            } else {
                DataWrapper data = this.m_cachedDataWrappers.get(parameterIndex - 1);
                data.setNumeric(value);
                this.setParameterInputData(parameterIndex, data);
            }
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(parameterIndex - 1)) {
                this.m_setMetadata.put(parameterIndex - 1, t);
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setBinaryStream(int parameterIndex, InputStream value, int length) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex, value, length);
            this.checkIfOpen();
            this.checkValidParameterIndex(parameterIndex);
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(parameterIndex - 1)) {
                this.m_setMetadata.put(parameterIndex - 1, TypeMetadata.createTypeMetadata(-4));
            } else if (TypeConverter.canConvertStreamTo(this.m_setMetadata.get(parameterIndex - 1).getType(), -4)) {
                this.m_setMetadata.put(parameterIndex - 1, TypeMetadata.createTypeMetadata(-4));
            }
            if (null == value) {
                this.setNull(parameterIndex, -4);
            } else {
                BinaryParameterStream stream = new BinaryParameterStream(value, length);
                this.setParameterInputStream(parameterIndex, stream);
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setBlob(int parameterIndex, Blob value) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex, value);
            this.checkIfOpen();
            this.checkValidParameterIndex(parameterIndex);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setBoolean(int parameterIndex, boolean value) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex, value);
            this.checkIfOpen();
            this.checkValidParameterIndex(parameterIndex);
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(parameterIndex - 1)) {
                this.m_setMetadata.put(parameterIndex - 1, TypeMetadata.createTypeMetadata(16));
            }
            DataWrapper data = this.m_cachedDataWrappers.get(parameterIndex - 1);
            data.setBoolean(value);
            this.setParameterInputData(parameterIndex, data);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setByte(int parameterIndex, byte value) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex, value);
            this.checkIfOpen();
            this.checkValidParameterIndex(parameterIndex);
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(parameterIndex - 1)) {
                this.m_setMetadata.put(parameterIndex - 1, TypeMetadata.createTypeMetadata(-6, true));
            }
            DataWrapper data = this.m_cachedDataWrappers.get(parameterIndex - 1);
            data.setTinyInt(value);
            this.setParameterInputData(parameterIndex, data);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setBytes(int parameterIndex, byte[] value) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex, value);
            this.checkIfOpen();
            this.checkValidParameterIndex(parameterIndex);
            int type = null == value || value.length <= this.m_parentConnection.m_maxVarcharSize ? -3 : -4;
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(parameterIndex - 1)) {
                this.m_setMetadata.put(parameterIndex - 1, TypeMetadata.createTypeMetadata(type));
            }
            DataWrapper data = this.m_cachedDataWrappers.get(parameterIndex - 1);
            if (null == value) {
                data.setNull(type);
            } else if (type == -4) {
                data.setLongVarBinary(value);
            } else {
                data.setVarBinary(value);
            }
            this.setParameterInputData(parameterIndex, data);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex, reader, length);
            this.checkIfOpen();
            this.checkValidParameterIndex(parameterIndex);
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(parameterIndex - 1)) {
                this.m_setMetadata.put(parameterIndex - 1, TypeMetadata.createTypeMetadata(-1));
            } else if (TypeConverter.canConvertStreamTo(this.m_setMetadata.get(parameterIndex - 1).getType(), -1)) {
                this.m_setMetadata.put(parameterIndex - 1, TypeMetadata.createTypeMetadata(-1));
            }
            if (null == reader) {
                this.setNull(parameterIndex, -1);
            } else {
                CharacterParameterStream stream = new CharacterParameterStream(reader, (long)length);
                this.setParameterInputStream(parameterIndex, stream);
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setClob(int parameterIndex, Clob value) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex, value);
            this.checkIfOpen();
            this.checkValidParameterIndex(parameterIndex);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setDate(int parameterIndex, Date value) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex, value);
            this.checkIfOpen();
            this.checkValidParameterIndex(parameterIndex);
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(parameterIndex - 1)) {
                this.m_setMetadata.put(parameterIndex - 1, TypeMetadata.createTypeMetadata(91));
            }
            if (null == value) {
                this.setNull(parameterIndex, 91);
            } else {
                DataWrapper data = this.m_cachedDataWrappers.get(parameterIndex - 1);
                data.setDate(value);
                this.setParameterInputData(parameterIndex, data);
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setDate(int parameterIndex, Date value, Calendar cal) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex, value);
        this.checkIfOpen();
        this.checkValidParameterIndex(parameterIndex);
        try {
            if (null == cal || null == value) {
                this.setDate(parameterIndex, value);
            } else {
                cal.clear();
                cal.setTimeInMillis(value.getTime());
                Calendar local = Calendar.getInstance();
                local.clear();
                local.set(cal.get(1), cal.get(2), cal.get(5), 0, 0, 0);
                local.set(14, 0);
                this.setDate(parameterIndex, new Date(local.getTimeInMillis()));
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setDouble(int parameterIndex, double value) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex, value);
            this.checkIfOpen();
            this.checkValidParameterIndex(parameterIndex);
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(parameterIndex - 1)) {
                this.m_setMetadata.put(parameterIndex - 1, TypeMetadata.createTypeMetadata(8));
            }
            DataWrapper data = this.m_cachedDataWrappers.get(parameterIndex - 1);
            data.setDouble(value);
            this.setParameterInputData(parameterIndex, data);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setFloat(int parameterIndex, float value) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex, Float.valueOf(value));
            this.checkIfOpen();
            this.checkValidParameterIndex(parameterIndex);
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(parameterIndex - 1)) {
                this.m_setMetadata.put(parameterIndex - 1, TypeMetadata.createTypeMetadata(7));
            }
            DataWrapper data = this.m_cachedDataWrappers.get(parameterIndex - 1);
            data.setReal(value);
            this.setParameterInputData(parameterIndex, data);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setInt(int parameterIndex, int value) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex, value);
            this.checkIfOpen();
            this.checkValidParameterIndex(parameterIndex);
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(parameterIndex - 1)) {
                this.m_setMetadata.put(parameterIndex - 1, TypeMetadata.createTypeMetadata(4, true));
            }
            DataWrapper data = this.m_cachedDataWrappers.get(parameterIndex - 1);
            data.setInteger(value);
            this.setParameterInputData(parameterIndex, data);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setLong(int parameterIndex, long value) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex, value);
            this.checkIfOpen();
            this.checkValidParameterIndex(parameterIndex);
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(parameterIndex - 1)) {
                this.m_setMetadata.put(parameterIndex - 1, TypeMetadata.createTypeMetadata(-5, true));
            }
            DataWrapper data = this.m_cachedDataWrappers.get(parameterIndex - 1);
            data.setBigInt(BigInteger.valueOf(value));
            this.setParameterInputData(parameterIndex, data);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setNull(int parameterIndex, int sqlType) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex, sqlType);
            this.checkIfOpen();
            this.checkValidParameterIndex(parameterIndex);
            this.checkTypeSupported(sqlType);
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(parameterIndex - 1)) {
                this.m_setMetadata.put(parameterIndex - 1, this.createMetadataForSqlType(sqlType));
            }
            DataWrapper data = this.m_cachedDataWrappers.get(parameterIndex - 1);
            data.setNull(sqlType);
            this.setParameterInputData(parameterIndex, data);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex, sqlType, typeName);
        this.setNull(parameterIndex, sqlType);
    }

    @Override
    public synchronized void setObject(int parameterIndex, Object value) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex, value);
            this.checkIfOpen();
            this.checkValidParameterIndex(parameterIndex);
            DataWrapper data = this.m_cachedDataWrappers.get(parameterIndex - 1);
            if (null == value) {
                data.setNull(2000);
            } else {
                int sqlType = TypeConverter.getSqlType(value);
                data.setData(sqlType, value);
                if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(parameterIndex - 1)) {
                    TypeMetadata t = value instanceof BigDecimal && (2 == sqlType || 3 == sqlType) ? this.createExactNumMetadata((BigDecimal)value, sqlType) : this.createMetadataForSqlType(sqlType);
                    this.m_setMetadata.put(parameterIndex - 1, t);
                }
            }
            this.setParameterInputData(parameterIndex, data);
        }
        catch (IncorrectTypeException ite) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.PARAM_OBJECT_MISMATCH, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(value));
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setObject(int parameterIndex, Object value, int targetSqlType) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex, value, targetSqlType);
            int scale = 0;
            if (value instanceof BigDecimal) {
                scale = this.createExactNumMetadata((BigDecimal)value, 2).getScale();
            }
            this.setObject(parameterIndex, value, targetSqlType, scale);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        block11: {
            try {
                LogUtilities.logFunctionEntrance(this.getLogger(), parameterIndex, x, targetSqlType, scale);
                this.checkIfOpen();
                this.checkValidParameterIndex(parameterIndex);
                DataWrapper data = this.m_cachedDataWrappers.get(parameterIndex - 1);
                if (null == x) {
                    this.setNull(parameterIndex, targetSqlType);
                    break block11;
                }
                try {
                    int objSqlType = TypeConverter.getSqlType(x);
                    data.setData(objSqlType, x);
                    if (targetSqlType != objSqlType) {
                        data = x instanceof BigDecimal && (2 == targetSqlType || 3 == targetSqlType) ? TypeConverter.toType(data, this.createExactNumMetadata((BigDecimal)x, targetSqlType), (IWarningListener)this.getWarningListener()) : TypeConverter.toType(data, x, targetSqlType, this.getWarningListener());
                    }
                    TypeMetadata dataMetadata = null;
                    switch (targetSqlType) {
                        case 2: {
                            BigDecimal d = data.getNumeric().setScale(scale, 4);
                            dataMetadata = this.createExactNumMetadata(d, targetSqlType);
                            data.setNumeric(d);
                            break;
                        }
                        case 3: {
                            BigDecimal d = data.getDecimal().setScale(scale, 4);
                            dataMetadata = this.createExactNumMetadata(d, targetSqlType);
                            data.setDecimal(d);
                            break;
                        }
                        default: {
                            dataMetadata = this.createMetadataForSqlType(targetSqlType);
                        }
                    }
                    if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(parameterIndex - 1)) {
                        this.m_setMetadata.put(parameterIndex - 1, dataMetadata);
                    }
                }
                catch (IncorrectTypeException e) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.PARAM_OBJECT_MISMATCH, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(x));
                }
                this.setParameterInputData(parameterIndex, data);
            }
            catch (Exception e) {
                throw ExceptionConverter.getInstance().toSQLException(e, this.getWarningListener(), this.getLogger());
            }
        }
    }

    public void setParameterInputStream(int parameterIndex, AbstractParameterStream inputStream) throws SQLException {
        ParameterMetadata paramMeta = this.m_parameterMetadata.get(parameterIndex - 1);
        if (ParameterType.OUTPUT == paramMeta.getParameterType()) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_SET_TYPE, (IWarningListener)this.getWarningListener(), ExceptionType.DATA, String.valueOf(parameterIndex));
        }
        this.m_parameterInputValues.remove(parameterIndex);
        AbstractParameterStream stream = this.m_parameterInputStreamData.get(parameterIndex);
        if (null != stream) {
            this.m_lastStreamsExecuted.remove(stream.getEqualityStreamWrapper());
            stream.close();
        }
        this.m_parameterInputStreamData.put(parameterIndex, inputStream);
    }

    public void setResultSetMetadata(SResultSetMetaData metadata) {
        this.m_metadata = metadata;
    }

    @Override
    public synchronized void setRef(int parameterIndex, Ref value) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex, value);
            this.checkIfOpen();
            this.checkValidParameterIndex(parameterIndex);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setShort(int parameterIndex, short value) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex, value);
            this.checkIfOpen();
            this.checkValidParameterIndex(parameterIndex);
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(parameterIndex - 1)) {
                this.m_setMetadata.put(parameterIndex - 1, TypeMetadata.createTypeMetadata(5, true));
            }
            DataWrapper data = this.m_cachedDataWrappers.get(parameterIndex - 1);
            data.setSmallInt(value);
            this.setParameterInputData(parameterIndex, data);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setString(int parameterIndex, String value) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex, value);
            this.checkIfOpen();
            this.checkValidParameterIndex(parameterIndex);
            int type = null == value || value.length() <= this.m_parentConnection.m_maxVarcharSize ? 12 : -1;
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(parameterIndex - 1)) {
                this.m_setMetadata.put(parameterIndex - 1, TypeMetadata.createTypeMetadata(type));
            }
            DataWrapper data = this.m_cachedDataWrappers.get(parameterIndex - 1);
            if (null == value) {
                data.setNull(12);
            } else if (-1 == type) {
                data.setLongVarChar(value);
            } else {
                data.setVarChar(value);
            }
            this.setParameterInputData(parameterIndex, data);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setTime(int parameterIndex, Time value) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex, value);
            this.checkIfOpen();
            this.checkValidParameterIndex(parameterIndex);
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(parameterIndex - 1)) {
                this.m_setMetadata.put(parameterIndex - 1, this.createTimeMetadata());
            }
            if (null == value) {
                this.setNull(parameterIndex, 92);
            } else {
                DataWrapper data = this.m_cachedDataWrappers.get(parameterIndex - 1);
                data.setTime(value);
                this.setParameterInputData(parameterIndex, data);
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setTime(int parameterIndex, Time value, Calendar cal) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex, value);
            this.checkIfOpen();
            this.checkValidParameterIndex(parameterIndex);
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(parameterIndex - 1)) {
                this.m_setMetadata.put(parameterIndex - 1, this.createTimeMetadata());
            }
            if (null == value) {
                this.setNull(parameterIndex, 92);
            } else {
                DataWrapper data = this.m_cachedDataWrappers.get(parameterIndex - 1);
                data.setTime(new TimeTz(value, cal));
                this.setParameterInputData(parameterIndex, data);
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setTimestamp(int parameterIndex, Timestamp value) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex, value);
            this.checkIfOpen();
            this.checkValidParameterIndex(parameterIndex);
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(parameterIndex - 1)) {
                this.m_setMetadata.put(parameterIndex - 1, this.createTimestampMetadata());
            }
            if (null == value) {
                this.setNull(parameterIndex, 93);
            } else {
                DataWrapper data = this.m_cachedDataWrappers.get(parameterIndex - 1);
                data.setTimestamp(value);
                this.setParameterInputData(parameterIndex, data);
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setTimestamp(int parameterIndex, Timestamp value, Calendar cal) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex, value, cal);
            this.checkIfOpen();
            this.checkValidParameterIndex(parameterIndex);
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(parameterIndex - 1)) {
                this.m_setMetadata.put(parameterIndex - 1, this.createTimestampMetadata());
            }
            if (null == value) {
                this.setNull(parameterIndex, 93);
            } else {
                DataWrapper data = this.m_cachedDataWrappers.get(parameterIndex - 1);
                data.setTimestamp(new TimestampTz(value, cal));
                this.setParameterInputData(parameterIndex, data);
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setUnicodeStream(int parameterIndex, InputStream value, int length) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex, value, length);
            this.checkIfOpen();
            this.checkValidParameterIndex(parameterIndex);
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(parameterIndex - 1)) {
                this.m_setMetadata.put(parameterIndex - 1, TypeMetadata.createTypeMetadata(-1));
            } else if (TypeConverter.canConvertStreamTo(this.m_setMetadata.get(parameterIndex - 1).getType(), -1)) {
                this.m_setMetadata.put(parameterIndex - 1, TypeMetadata.createTypeMetadata(-1));
            }
            if (null == value) {
                this.setNull(parameterIndex, -1);
            } else {
                UnicodeParameterStream stream = new UnicodeParameterStream(value, length);
                this.setParameterInputStream(parameterIndex, stream);
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void setURL(int parameterIndex, URL value) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, parameterIndex, value);
        this.checkIfOpen();
        this.checkValidParameterIndex(parameterIndex);
        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException, SQLFeatureNotSupportedException {
        this.setAsciiStream(parameterIndex, x, -1);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), parameterIndex, x, length);
            this.checkIfOpen();
            this.checkValidParameterIndex(parameterIndex);
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(parameterIndex - 1)) {
                this.m_setMetadata.put(parameterIndex - 1, TypeMetadata.createTypeMetadata(-1));
            } else if (TypeConverter.canConvertStreamTo(this.m_setMetadata.get(parameterIndex - 1).getType(), -1)) {
                this.m_setMetadata.put(parameterIndex - 1, TypeMetadata.createTypeMetadata(-1));
            }
            if (null == x) {
                this.setNull(parameterIndex, -1);
            } else {
                AsciiParameterStream stream = new AsciiParameterStream(x, length);
                this.setParameterInputStream(parameterIndex, stream);
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException, SQLFeatureNotSupportedException {
        this.setBinaryStream(parameterIndex, x, -1);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), parameterIndex, x, length);
            this.checkIfOpen();
            this.checkValidParameterIndex(parameterIndex);
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(parameterIndex - 1)) {
                this.m_setMetadata.put(parameterIndex - 1, TypeMetadata.createTypeMetadata(-4));
            } else if (TypeConverter.canConvertStreamTo(this.m_setMetadata.get(parameterIndex - 1).getType(), -4)) {
                this.m_setMetadata.put(parameterIndex - 1, TypeMetadata.createTypeMetadata(-4));
            }
            if (null == x) {
                this.setNull(parameterIndex, -4);
            } else {
                BinaryParameterStream stream = new BinaryParameterStream(x, length);
                this.setParameterInputStream(parameterIndex, stream);
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public void setBlob(int parameterIndex, InputStream x) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), parameterIndex, x);
        this.checkIfOpen();
        this.checkValidParameterIndex(parameterIndex);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), parameterIndex, inputStream, length);
        this.checkIfOpen();
        this.checkValidParameterIndex(parameterIndex);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        this.setCharacterStream(parameterIndex, reader, -1);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), parameterIndex, reader, length);
            this.checkIfOpen();
            this.checkValidParameterIndex(parameterIndex);
            if (!this.m_isSetMetadataFinal || null == this.m_setMetadata.get(parameterIndex - 1)) {
                this.m_setMetadata.put(parameterIndex - 1, TypeMetadata.createTypeMetadata(-1));
            } else if (TypeConverter.canConvertStreamTo(this.m_setMetadata.get(parameterIndex - 1).getType(), -1)) {
                this.m_setMetadata.put(parameterIndex - 1, TypeMetadata.createTypeMetadata(-1));
            }
            if (null == reader) {
                this.setNull(parameterIndex, -1);
            } else {
                CharacterParameterStream stream = new CharacterParameterStream(reader, length);
                this.setParameterInputStream(parameterIndex, stream);
            }
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), parameterIndex, reader);
        this.checkIfOpen();
        this.checkValidParameterIndex(parameterIndex);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), parameterIndex, reader, length);
        this.checkIfOpen();
        this.checkValidParameterIndex(parameterIndex);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), parameterIndex, value);
        this.checkIfOpen();
        this.checkValidParameterIndex(parameterIndex);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), parameterIndex, value, length);
        this.checkIfOpen();
        this.checkValidParameterIndex(parameterIndex);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), parameterIndex, value);
        this.checkIfOpen();
        this.checkValidParameterIndex(parameterIndex);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), parameterIndex, reader);
        this.checkIfOpen();
        this.checkValidParameterIndex(parameterIndex);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), parameterIndex, reader, length);
        this.checkIfOpen();
        this.checkValidParameterIndex(parameterIndex);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), parameterIndex, value);
        this.checkIfOpen();
        this.checkValidParameterIndex(parameterIndex);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), parameterIndex, x);
        this.checkIfOpen();
        this.checkValidParameterIndex(parameterIndex);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), parameterIndex, xmlObject);
        this.checkIfOpen();
        this.checkValidParameterIndex(parameterIndex);
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.getLogger());
        throw exception;
    }

    @Override
    void closeIfPrepared() throws SQLException {
        this.close();
    }

    protected boolean allInputParameterValuesPopulated() {
        return this.m_parameterInputStreamData.size() + this.m_parameterInputValues.size() == this.m_numParameters;
    }

    protected void checkParameters(List<ParameterMetadata> paramMetadata) throws SQLException {
        for (int i = 0; i < paramMetadata.size(); ++i) {
            if (ParameterType.INPUT == this.m_parameterTypes.get(i)) continue;
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_INPUT_ONLY, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(paramMetadata.get(i).getParameterNumber()));
        }
    }

    protected void checkTypeSupported(int sqlType) throws SQLException {
        switch (sqlType) {
            case -11: 
            case -7: 
            case -6: 
            case -5: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 91: 
            case 92: 
            case 93: 
            case 1111: 
            case 2000: 
            case 2003: {
                break;
            }
            default: {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
            }
        }
    }

    protected void checkValidParameterIndex(int parameterIndex) throws SQLException {
        if (1 > parameterIndex || this.m_numParameters < parameterIndex) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_INDEX, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, String.valueOf(parameterIndex));
        }
    }

    protected void clearParameters(Map<Integer, DataWrapper> parameterInputValues, Map<Integer, AbstractParameterStream> parameterInputStreams) {
        parameterInputValues.clear();
        for (AbstractParameterStream stream : parameterInputStreams.values()) {
            if (null == stream) continue;
            this.m_lastStreamsExecuted.remove(stream.getEqualityStreamWrapper());
            stream.close();
        }
        parameterInputStreams.clear();
    }

    protected IResults executeWithParams(ArrayList<ParameterMetadata> metadata, ArrayList<ArrayList<ParameterInputValue>> inputValues, SStatement.ThrowCondition throwCondition) throws SQLException {
        return this.executeWithParams(metadata, inputValues, null, throwCondition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IResults executeWithParams(ArrayList<ParameterMetadata> metadata, ArrayList<ArrayList<ParameterInputValue>> inputValues, ParameterGeneratedValues generatedParams, SStatement.ThrowCondition throwCondition) throws SQLException {
        try {
            Object object = this.m_cancelLock;
            synchronized (object) {
                this.m_isInCancelableFunction = true;
            }
            this.checkCondition(this.m_preparedSql, throwCondition);
            ExecutionContexts execContexts = new ExecutionContexts(metadata, inputValues, generatedParams);
            Object object2 = this.m_cancelLock;
            synchronized (object2) {
                if (this.m_isCanceled) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.OPERATION_CANCELED, (IWarningListener)this.m_warningListener, ExceptionType.TRANSIENT, new Object[0]);
                }
            }
            this.m_warningListener.setCurrentFunction(FunctionID.STATEMENT_EXECUTE);
            this.m_queryExecutor.execute(execContexts, this.m_warningListener);
            this.m_metadata = null;
            object2 = this.m_queryExecutor.getResults();
            return object2;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener);
        }
        finally {
            Object object = this.m_cancelLock;
            synchronized (object) {
                this.m_isCanceled = false;
                this.m_isInCancelableFunction = false;
            }
        }
    }

    protected List<Pair<Integer, SQLException>> getBatchParamConversionErrors() {
        return this.m_batchParamConversionExceptions;
    }

    protected SParameterMetaData getOpenParamMetaData() {
        return this.m_openParamMetaData;
    }

    protected ArrayList<ParameterMetadata> getParameterMetadataList() {
        return this.m_parameterMetadata;
    }

    protected void setOpenParamMetaData(SParameterMetaData openParameterMetadata) {
        this.m_openParamMetaData = openParameterMetadata;
    }

    protected abstract SResultSetMetaData createResultSetMetaData(IResultSet var1) throws SQLException;

    private DataWrapper convertValueToTypeAsString(DataWrapper data, TypeMetadata targetMetadata) throws IncorrectTypeException, SQLException {
        if (TypeUtilities.isCharacterType(data.getType())) {
            return data;
        }
        if (!this.stringRepresentationsCompatible(data.getType(), targetMetadata.getType())) {
            data = TypeConverter.toType(data, targetMetadata, (IWarningListener)this.m_warningListener);
        }
        data.setVarChar(TypeConverter.toString(data, targetMetadata));
        return data;
    }

    private void setParameterInputData(int parameterIndex, DataWrapper data) throws SQLException {
        if (ParameterType.OUTPUT == this.m_parameterTypes.get(parameterIndex - 1)) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(parameterIndex));
        }
        Integer intObj = parameterIndex;
        AbstractParameterStream stream = this.m_parameterInputStreamData.get(intObj);
        if (null != stream) {
            this.m_lastStreamsExecuted.remove(stream.getEqualityStreamWrapper());
            stream.close();
            this.m_parameterInputStreamData.remove(intObj);
        }
        this.m_parameterInputValues.put(intObj, data);
    }

    private ParameterInputValue createConvertedParameterInputValue(DataWrapper data, ParameterMetadata paramMeta) throws SQLException {
        assert (null != data);
        assert (null != paramMeta);
        try {
            TypeMetadata toTypeMetadata = paramMeta.getTypeMetadata();
            if (Nullable.NO_NULLS == paramMeta.getNullable() && data.isNull()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.PARAM_NOT_NULLABLE, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, String.valueOf(paramMeta.getParameterNumber()));
            }
            if (2000 == data.getType() && data.isNull()) {
                data.setNull(toTypeMetadata.getType());
            }
            data = paramMeta.shouldConvertInputToString() ? this.convertValueToTypeAsString(data, toTypeMetadata) : TypeConverter.toType(data, toTypeMetadata, (IWarningListener)this.m_warningListener);
            return new ParameterInputValue(paramMeta, data);
        }
        catch (IncorrectTypeException e) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONVERSION_ERROR_INPUT_PARAM, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(paramMeta.getParameterNumber()));
        }
    }

    private ParameterMetadata extractParameterMetadataForStream(int paramNum) throws SQLException {
        short toType = this.m_parameterMetadata.get(paramNum).getTypeMetadata().getType();
        TypeMetadata t = this.m_setMetadata.get(paramNum);
        int fromType = null != t ? (int)t.getType() : 2000;
        if (!TypeConverter.canConvertStreamTo(fromType, toType)) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_SET_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(paramNum + 1));
        }
        return this.m_parameterMetadata.get(paramNum);
    }

    private ArrayList<ArrayList<ParameterInputValue>> getInputParameterValues() throws SQLException {
        ArrayList<ParameterInputValue> currSetValues = this.getInputParameterValues(this.m_parameterInputValues, this.m_parameterInputStreamData);
        ArrayList<ArrayList<ParameterInputValue>> inputParamValues = new ArrayList<ArrayList<ParameterInputValue>>(1);
        inputParamValues.add(currSetValues);
        return inputParamValues;
    }

    private ArrayList<ParameterInputValue> getInputParameterValues(Map<Integer, DataWrapper> parameterValueMap, Map<Integer, AbstractParameterStream> parameterStreamMap) throws SQLException {
        ArrayList<ParameterInputValue> currSetValues = new ArrayList<ParameterInputValue>(this.m_numParameters);
        for (int i = 0; i < this.m_numParameters; ++i) {
            if (ParameterType.OUTPUT == this.m_parameterTypes.get(i) || ParameterType.RETURN_VALUE == this.m_parameterTypes.get(i)) continue;
            Integer intObj = i + 1;
            if (parameterValueMap.containsKey(intObj)) {
                DataWrapper dw = parameterValueMap.get(intObj);
                ParameterInputValue val = this.createConvertedParameterInputValue(dw, this.m_parameterMetadata.get(i));
                currSetValues.add(val);
                continue;
            }
            AbstractParameterStream parameterStream = parameterStreamMap.get(intObj);
            ParameterMetadata metadata = parameterStream.getMetadata();
            if (null == metadata) {
                metadata = this.extractParameterMetadataForStream(i);
            }
            currSetValues.add(new ParameterInputValue(metadata, true, null));
        }
        return currSetValues;
    }

    private void pushBatchParameterStreams() throws SQLException {
        try {
            int batchInputStreamSize = this.m_batchParameterInputStreamData.size();
            for (int i = 0; i < batchInputStreamSize; ++i) {
                this.pushParameterStreams(i + 1, this.m_batchParameterInputStreamData.get(i));
            }
            this.m_queryExecutor.finalizePushedParamData();
            this.m_currExecutionStreamSet.clear();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener);
        }
    }

    private void pushClearSingleBatchSetStreams() throws SQLException {
        try {
            for (Map.Entry<Integer, AbstractParameterStream> e : this.m_parameterInputStreamData.entrySet()) {
                AbstractParameterStream stream = e.getValue();
                int paramNum = e.getKey();
                if (!this.m_currExecutionStreamSet.add(stream.getEqualityStreamWrapper())) {
                    this.m_currExecutionStreamSet.clear();
                    throw new InputOutputException(1, JDBCMessageKey.STREAM_REUSED.name());
                }
                if (null == stream.getMetadata()) {
                    ParameterMetadata meta = this.extractParameterMetadataForStream(paramNum - 1);
                    stream.setParameterMetadata(meta);
                }
                while (stream.hasMoreData()) {
                    this.m_queryExecutor.pushParamData(this.m_nextParamSetForStream, stream.getNextValue());
                }
                this.m_lastStreamsExecuted.remove(stream.getEqualityStreamWrapper());
                stream.close();
            }
            this.m_parameterInputStreamData.clear();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener);
        }
        finally {
            ++this.m_nextParamSetForStream;
        }
    }

    private void pushParameterStreams() throws SQLException {
        try {
            this.pushParameterStreams(1, this.m_parameterInputStreamData);
            this.m_queryExecutor.finalizePushedParamData();
            this.m_currExecutionStreamSet.clear();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener);
        }
    }

    private void pushParameterStreams(int parameterSet, Map<Integer, AbstractParameterStream> parameterStreamMap) throws ErrorException, IOException, BadDefaultParamException, SQLException {
        for (Map.Entry<Integer, AbstractParameterStream> entry : parameterStreamMap.entrySet()) {
            AbstractParameterStream stream = entry.getValue();
            int paramNum = entry.getKey();
            if (!this.m_currExecutionStreamSet.add(stream.getEqualityStreamWrapper())) {
                this.m_currExecutionStreamSet.clear();
                throw new InputOutputException(1, JDBCMessageKey.STREAM_REUSED.name());
            }
            if (null == stream.getMetadata()) {
                short toType = this.m_parameterMetadata.get(paramNum - 1).getTypeMetadata().getType();
                TypeMetadata t = this.m_setMetadata.get(paramNum - 1);
                int fromType = null != t ? (int)t.getType() : 2000;
                if (!TypeConverter.canConvertStreamTo(fromType, toType)) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_PARAM_SET_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.DATA, String.valueOf(paramNum));
                }
                stream.setParameterMetadata(this.m_parameterMetadata.get(paramNum - 1));
            }
            this.m_lastStreamsExecuted.add(stream.getEqualityStreamWrapper());
            while (stream.hasMoreData()) {
                this.m_queryExecutor.pushParamData(parameterSet, stream.getNextValue());
            }
        }
    }

    private void updateParameterMetadata() throws ErrorException {
        if (!this.m_isSetMetadataFinal) {
            this.m_openParamMetaData = null;
            HashMap<Integer, TypeMetadata> meta = new HashMap<Integer, TypeMetadata>();
            for (Map.Entry<Integer, TypeMetadata> e : this.m_setMetadata.entrySet()) {
                meta.put(e.getKey(), TypeMetadata.copyOf(e.getValue()));
            }
            this.m_queryExecutor.pushMappedParamTypes(meta);
            this.m_parameterMetadata = this.m_queryExecutor.getMetadataForParameters();
            assert (this.m_numParameters == this.m_parameterMetadata.size());
            this.m_isSetMetadataFinal = true;
        }
    }

    private boolean stringRepresentationsCompatible(int sourceSqlType, int targetSqlType) {
        Set<Integer> compatibleTargetTypes = s_stringRepCompatibilityLookup.get(sourceSqlType);
        if (null == compatibleTargetTypes) {
            return false;
        }
        return compatibleTargetTypes.contains(targetSqlType);
    }

    protected TypeMetadata createExactNumMetadata(BigDecimal data, int targetType) throws ErrorException {
        if (2 != targetType && 3 != targetType) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.DATA_TYPE_UNSUPPORTED_NUM.name(), String.valueOf(targetType), ExceptionType.DATA);
        }
        if (null == data) {
            return TypeMetadata.createTypeMetadata(targetType, true);
        }
        ConversionResult cr = new ConversionResult();
        Pair<Short, Short> precScale = ExactNumConverter.calculateSQLPrecisionScale(data, cr);
        if (ConversionResult.TypeConversionState.SUCCESS != cr.getState()) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.NUMERIC_OVERFLOW.name(), String.valueOf(targetType), ExceptionType.DATA);
        }
        return TypeMetadata.createTypeMetadata(targetType, precScale.key(), precScale.value(), precScale.key().shortValue(), true);
    }

    private TypeMetadata createMetadataForSqlType(int sqlType) throws ErrorException {
        TypeMetadata t = TypeUtilities.isIntegerType(sqlType) ? TypeMetadata.createTypeMetadata(sqlType, true) : (92 == sqlType ? this.createTimeMetadata() : (93 == sqlType ? this.createTimestampMetadata() : TypeMetadata.createTypeMetadata(sqlType)));
        return t;
    }

    private TypeMetadata createTimestampMetadata() throws ErrorException {
        return TypeMetadata.createTypeMetadata(93, (short)9, (short)0, 0, false);
    }

    private TypeMetadata createTimeMetadata() throws ErrorException {
        return TypeMetadata.createTypeMetadata(92, (short)3, (short)0, 0, false);
    }

    private static Map<Integer, Set<Integer>> initializeStringRepCompatibilityLookup() {
        List<Integer> charTypes = Arrays.asList(1, 12, -1, -8, -9, -10);
        HashMap<Integer, Set<Integer>> result = new HashMap<Integer, Set<Integer>>();
        for (Integer sourceType : TypeUtilities.getSupportedSqlTypes()) {
            HashSet<Integer> targetTypes = new HashSet<Integer>(charTypes);
            targetTypes.add(sourceType);
            for (Integer targetType : TypeUtilities.getSupportedSqlTypes()) {
                if ((!TypeUtilities.isBinaryType(sourceType) || !TypeUtilities.isBinaryType(targetType)) && (!TypeUtilities.isIntegerType(sourceType) || !TypeUtilities.isIntegerType(targetType) && !TypeUtilities.isNumberType(targetType)) && (!TypeUtilities.isApproximateNumericType(sourceType) && !TypeUtilities.isExactNumericType(sourceType) || !TypeUtilities.isApproximateNumericType(targetType) && !TypeUtilities.isExactNumericType(targetType)) && (-7 != sourceType && 16 != sourceType || -7 != targetType && 16 != targetType)) continue;
                targetTypes.add(targetType);
            }
            result.put(sourceType, targetTypes);
        }
        return result;
    }

    protected static enum BatchExecResult {
        BATCH_EXEC_SUCCEEDED,
        BATCH_EXEC_ALL_FAILED_INPUT_CONVERSION,
        BATCH_EXEC_NO_BATCHES;

    }
}

