/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.utils;

import com.dbeaver.jdbc.base.ColumnInfo;
import com.dbeaver.jdbc.files.api.FFJdbcDriver;
import com.dbeaver.jdbc.files.database.FFTableProperties;
import com.dbeaver.jdbc.files.database.FFTableStructure;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.jsqlparser.statement.Statement;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public final class FFDriverUtils {
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    public static final SimpleDateFormat TIME_FORMAT_LONG = new SimpleDateFormat("HH:mm:ss.SSS");
    public static final SimpleDateFormat TIME_FORMAT_SHORT = new SimpleDateFormat("HH:mm:ss");
    public static final SimpleDateFormat TIMESTAMP_FORMAT_LONG = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    public static final SimpleDateFormat TIMESTAMP_FORMAT_SHORT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    private FFDriverUtils() {
    }

    public static void closeAll(AutoCloseable ... closeables) throws Exception {
        ArrayList<Exception> suppressedExceptions = new ArrayList<Exception>();
        AutoCloseable[] autoCloseableArray = closeables;
        int n = closeables.length;
        int n2 = 0;
        while (n2 < n) {
            AutoCloseable closeable = autoCloseableArray[n2];
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (Exception e) {
                    suppressedExceptions.add(e);
                }
            }
            ++n2;
        }
        if (!suppressedExceptions.isEmpty()) {
            Exception exception = new Exception("Failed to close some resources");
            for (Exception suppressedException : suppressedExceptions) {
                exception.addSuppressed(suppressedException);
            }
            throw exception;
        }
    }

    @NotNull
    public static String formatStatements(@NotNull List<Statement> statements) {
        StringBuilder sb = new StringBuilder();
        for (Statement statement : statements) {
            sb.append(statement.toString()).append(System.lineSeparator());
        }
        return sb.toString();
    }

    @NotNull
    public static String quote(@NotNull String value) {
        return "\"" + value + "\"";
    }

    @NotNull
    public static String unquote(@NotNull String value) {
        boolean isQuoted = FFJdbcDriver.QUOTE_CHARS.stream().anyMatch(quoteChar -> quoteChar.equals(Character.valueOf(value.charAt(0))) && quoteChar.equals(Character.valueOf(value.charAt(value.length() - 1))));
        if (isQuoted) {
            return value.substring(1, value.length() - 1);
        }
        return value.trim();
    }

    public static Object extractColumnValueByType(int type, ResultSet resultSet, int columnIndex) throws SQLException {
        return switch (type) {
            case 16 -> resultSet.getBoolean(columnIndex);
            case -6 -> resultSet.getByte(columnIndex);
            case 5 -> resultSet.getShort(columnIndex);
            case -7, 4 -> resultSet.getInt(columnIndex);
            case -5 -> resultSet.getLong(columnIndex);
            case 6, 7 -> Float.valueOf(resultSet.getFloat(columnIndex));
            case 8 -> resultSet.getDouble(columnIndex);
            case 2, 3 -> resultSet.getBigDecimal(columnIndex);
            case 93 -> resultSet.getTimestamp(columnIndex);
            case 91 -> resultSet.getDate(columnIndex);
            case 92 -> resultSet.getTime(columnIndex);
            default -> resultSet.getString(columnIndex);
        };
    }

    public static <T, TP extends FFTableProperties> FFTableStructure<T, TP> mergeStructures(@NotNull FFTableStructure<T, TP> dateStructure, @NotNull FFTableStructure<T, TP> externalStructure) {
        List<ColumnInfo<T>> columns = dateStructure.columns();
        List<ColumnInfo<T>> externalColumns = externalStructure.columns();
        if (columns.size() != externalColumns.size()) {
            throw new IllegalArgumentException("Mismatched number of columns: data structure has " + columns.size() + " columns, external metadata has " + externalColumns.size() + " columns.");
        }
        TP mergedTableProperties = FFDriverUtils.mergeTableProperties(dateStructure.properties(), externalStructure.properties());
        return new FFTableStructure<T, TP>(externalStructure.primaryKey(), FFDriverUtils.mergeColumns(columns, externalColumns), externalStructure.indices(), mergedTableProperties, externalStructure.ddl());
    }

    @NotNull
    private static <T> List<ColumnInfo<T>> mergeColumns(@NotNull List<ColumnInfo<T>> columns, @NotNull List<ColumnInfo<T>> externalColumns) {
        ArrayList<ColumnInfo<T>> mergedColumns = new ArrayList<ColumnInfo<T>>(columns.size());
        int i = 0;
        while (i < columns.size()) {
            ColumnInfo<T> column = columns.get(i);
            ColumnInfo<T> externalColumn = externalColumns.get(i);
            mergedColumns.add(i, new ColumnInfo(externalColumn.tableName(), externalColumn.schemaName(), externalColumn.tableName(), column.columnName(), externalColumn.columnLabel(), externalColumn.type(), externalColumn.typeName(), externalColumn.precision(), column.reader(), externalColumn.nullable()));
            ++i;
        }
        return mergedColumns;
    }

    private static <TP extends FFTableProperties> TP mergeTableProperties(@NotNull TP dataProperties, @NotNull TP externalProperties) {
        return externalProperties;
    }

    @NotNull
    public static Pattern convertSqlPatternToRegexPattern(@Nullable String sqlPattern) {
        if (sqlPattern == null) {
            return Pattern.compile(".*");
        }
        String regex = sqlPattern.replaceAll("([\\\\^$.|?*+()\\[\\]{}])", "\\\\$1");
        regex = regex.replace("%", ".*");
        regex = regex.replace("_", ".");
        return Pattern.compile(regex);
    }
}

