/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.utils;

import com.dbeaver.jdbc.files.database.FFSQLType;
import java.sql.Date;
import java.sql.SQLType;
import java.sql.Time;
import java.sql.Timestamp;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public final class FFDataTypeUtils {
    private FFDataTypeUtils() {
    }

    @NotNull
    public static SQLType determineCommonDataType(@NotNull SQLType type1, @NotNull SQLType type2) {
        if (type1 == type2) {
            return type1;
        }
        if (type1 == FFSQLType.NULL) {
            return type2;
        }
        if (type2 == FFSQLType.NULL) {
            return type1;
        }
        return FFSQLType.VARCHAR;
    }

    @NotNull
    public static SQLType determineDataType(@Nullable Object value) {
        if (value == null) {
            return FFSQLType.NULL;
        }
        if (value instanceof Boolean) {
            return FFSQLType.BOOLEAN;
        }
        if (value instanceof Number) {
            return FFSQLType.NUMERIC;
        }
        if (value instanceof Date) {
            return FFSQLType.DATE;
        }
        if (value instanceof Time) {
            return FFSQLType.TIME;
        }
        if (value instanceof Timestamp) {
            return FFSQLType.TIMESTAMP;
        }
        if (value instanceof byte[]) {
            return FFSQLType.BINARY;
        }
        if (value instanceof String) {
            return FFDataTypeUtils.determineDataType((String)value);
        }
        return FFSQLType.VARCHAR;
    }

    @NotNull
    public static SQLType determineDataType(@Nullable String value) {
        if (value == null) {
            return FFSQLType.NULL;
        }
        if (FFDataTypeUtils.isLong(value) || FFDataTypeUtils.isDouble(value)) {
            return FFSQLType.NUMERIC;
        }
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
            return FFSQLType.BOOLEAN;
        }
        return FFSQLType.VARCHAR;
    }

    private static boolean isLong(@NotNull String value) {
        try {
            Long.parseLong(value);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static boolean isDouble(@NotNull String value) {
        try {
            Double.parseDouble(value);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }
}

