/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.database;

import com.dbeaver.jdbc.base.ColumnInfo;
import com.dbeaver.jdbc.files.database.FFChecksumable;
import com.dbeaver.jdbc.files.database.FFIndex;
import com.dbeaver.jdbc.files.database.FFPrimaryKey;
import com.dbeaver.jdbc.files.database.FFTableProperties;
import com.dbeaver.jdbc.files.utils.FFByteUtils;
import java.util.List;
import java.util.zip.CRC32;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public record FFTableStructure<T, P extends FFTableProperties>(@Nullable FFPrimaryKey primaryKey, @NotNull List<ColumnInfo<T>> columns, @NotNull List<FFIndex> indices, @NotNull P properties, @Nullable String ddl) implements FFChecksumable
{
    public FFTableStructure(@NotNull List<ColumnInfo<T>> columns, @NotNull P properties) {
        this(null, columns, List.of(), properties, null);
    }

    public FFTableStructure<T, P> withPrimaryKey(@Nullable FFPrimaryKey primaryKey) {
        return new FFTableStructure<T, P>(primaryKey, this.columns, this.indices, this.properties, this.ddl);
    }

    public FFTableStructure<T, P> withColumns(@NotNull List<ColumnInfo<T>> columns) {
        return new FFTableStructure<T, P>(this.primaryKey, columns, this.indices, this.properties, this.ddl);
    }

    public FFTableStructure<T, P> withIndices(@NotNull List<FFIndex> indexes) {
        return new FFTableStructure<T, P>(this.primaryKey, this.columns, indexes, this.properties, this.ddl);
    }

    public FFTableStructure<T, P> withProperties(@NotNull P properties) {
        return new FFTableStructure<T, P>(this.primaryKey, this.columns, this.indices, properties, this.ddl);
    }

    public FFTableStructure<T, P> withDDL(@Nullable String ddl) {
        return new FFTableStructure<T, P>(this.primaryKey, this.columns, this.indices, this.properties, ddl);
    }

    @Override
    public long checksum() {
        CRC32 crc32 = new CRC32();
        for (ColumnInfo<T> column : this.columns) {
            crc32.update(column.columnName().getBytes());
            crc32.update(column.columnLabel().getBytes());
            crc32.update(column.type());
        }
        for (FFIndex index : this.indices) {
            crc32.update(FFByteUtils.longToBytes(index.checksum()));
        }
        if (this.ddl != null) {
            crc32.update(this.ddl.getBytes());
        }
        return crc32.getValue();
    }
}

