/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.database;

import com.dbeaver.jdbc.base.ColumnInfo;
import com.dbeaver.jdbc.files.FFTableReader;
import com.dbeaver.jdbc.files.FFTableReaderFactory;
import com.dbeaver.jdbc.files.database.FFIndex;
import com.dbeaver.jdbc.files.database.FFTableName;
import com.dbeaver.jdbc.files.database.FFTableProperties;
import com.dbeaver.jdbc.files.database.FFTableSource;
import com.dbeaver.jdbc.files.database.FFTableStructure;
import com.dbeaver.jdbc.files.utils.FFByteUtils;
import com.dbeaver.jdbc.files.utils.FFLazyValue;
import java.io.IOException;
import java.util.List;
import java.util.zip.CRC32;

public class FFTable<T, P extends FFTableProperties> {
    private final FFTableName tableName;
    private final FFLazyValue<FFTableStructure<T, P>, IOException> structure;
    private final FFTableSource tableSource;
    private final FFTableReaderFactory<T, P> readerFactory;

    public FFTable(FFTableName tableName, FFLazyValue<FFTableStructure<T, P>, IOException> structure, FFTableSource tableSource, FFTableReaderFactory<T, P> readerFactory) {
        this.tableName = tableName;
        this.structure = structure;
        this.tableSource = tableSource;
        this.readerFactory = readerFactory;
    }

    public FFTableName tableName() {
        return this.tableName;
    }

    public FFTableStructure<T, P> structure() throws IOException {
        return this.structure.evaluate();
    }

    public FFTableSource tableSource() {
        return this.tableSource;
    }

    public FFTableReader<T> reader() throws IOException {
        return this.readerFactory.createReader(this);
    }

    public FFTableReaderFactory<T, P> readerFactory() {
        return this.readerFactory;
    }

    public String remarks() {
        return this.tableSource.remarks();
    }

    public long checksum() throws IOException {
        CRC32 crc32 = new CRC32();
        crc32.update(this.tableName.asString().getBytes());
        crc32.update(FFByteUtils.longToBytes(this.structure.evaluate().checksum()));
        crc32.update(FFByteUtils.longToBytes(this.tableSource.checksum()));
        return crc32.getValue();
    }

    public FFTable<T, P> rename(final FFTableName newTableName) {
        return new FFTable<T, P>(newTableName, new FFLazyValue<FFTableStructure<T, P>, IOException>(){

            @Override
            protected FFTableStructure<T, P> initialize() throws IOException {
                FFTableStructure oldStructure = FFTable.this.structure.evaluate();
                List columns = oldStructure.columns().stream().map(column -> new ColumnInfo(null, newTableName.schema().name(), newTableName.name(), column.columnName(), column.columnLabel(), column.type(), column.typeName(), column.precision(), column.reader(), column.nullable())).toList();
                List<FFIndex> indices = oldStructure.indices().stream().map(index -> new FFIndex(newTableName, index.indexName(), index.columnNames(), index.expression(), index.unique())).toList();
                return new FFTableStructure(oldStructure.primaryKey(), columns, indices, oldStructure.properties(), oldStructure.ddl());
            }
        }, this.tableSource, this.readerFactory);
    }
}

