/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.api;

import com.dbeaver.jdbc.files.api.FFPropertyInfo;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public abstract class FFProperties {
    @NotNull
    protected final Properties properties;
    public static final FFPropertyInfo<String> SUBFOLDER_NAME_SEPARATOR_PROPERTY = FFPropertyInfo.builder().withName("subfolderNameSeparator").withValue("__").withDescription("Defines the separator used in subfolder names within schema names").withParser(Function.identity()).build();
    public static final FFPropertyInfo<Boolean> SCAN_SUBFOLDERS_PROPERTY = FFPropertyInfo.builder().withName("scanSubfolders").withValue(Boolean.TRUE).withChoices((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.FALSE}).withDescription("Scan subfolders for data files").withParser(Boolean::parseBoolean).build();
    public static final FFPropertyInfo<String> DEFAULT_SCHEMA_PROPERTY = FFPropertyInfo.builder().withName("defaultSchema").withValue("default").withDescription("Default schema name").withParser(Function.identity()).build();
    public static final FFPropertyInfo<Boolean> USE_INTERNAL_DATABASE_PROPERTY = FFPropertyInfo.builder().withName("useInternalDb").withValue(Boolean.TRUE).withChoices((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.FALSE}).withDescription("Use internal database for complex queries").withParser(Boolean::parseBoolean).isOverridable(false).build();
    public static final FFPropertyInfo<Path> INTERNAL_DATABASE_DIR_PROPERTY = FFPropertyInfo.builder().withName("internalDbPath").withDescription("Internal database directory path").withParser(FFProperties::parsePath).isOverridable(false).build();
    public static final FFPropertyInfo<Integer> INTERNAL_DATABASE_BATCH_SIZE_PROPERTY = FFPropertyInfo.builder().withName("internalDbBatchSize").withValue(1000).withDescription("Internal database batch size").withParser(Integer::parseInt).isOverridable(false).build();
    public static final FFPropertyInfo<Integer> INTERNAL_DATABASE_TRANSACTION_SIZE_PROPERTY = FFPropertyInfo.builder().withName("internalDbTransactionSize").withValue(10).withDescription("A number of batches in a single transaction").withParser(Integer::parseInt).isOverridable(false).build();
    public static final FFPropertyInfo<Path> LICENSE_PATH_PROPERTY = FFPropertyInfo.builder().withName("licensePath").withDescription("Path to the license file").withParser(FFProperties::parsePath).isOverridable(false).build();

    protected FFProperties(@NotNull Map<String, String> properties) {
        this.properties = new Properties();
        this.properties.putAll(properties);
    }

    protected FFProperties(@NotNull Properties properties) {
        this.properties = properties;
    }

    public Map<String, String> toMap() {
        return this.properties.stringPropertyNames().stream().collect(Collectors.toMap(name -> name, this.properties::getProperty));
    }

    public abstract String wildcard();

    public String subfolderNameSeparator() {
        return this.getProperty(SUBFOLDER_NAME_SEPARATOR_PROPERTY);
    }

    public boolean scanSubfolders() {
        return this.getProperty(SCAN_SUBFOLDERS_PROPERTY);
    }

    public String defaultSchema() {
        return this.getProperty(DEFAULT_SCHEMA_PROPERTY);
    }

    public boolean useInternalDatabase() {
        return this.getProperty(USE_INTERNAL_DATABASE_PROPERTY);
    }

    @Nullable
    public Path internalDatabaseDir() {
        return this.getProperty(INTERNAL_DATABASE_DIR_PROPERTY);
    }

    public int internalDatabaseBatchSize() {
        return this.getProperty(INTERNAL_DATABASE_BATCH_SIZE_PROPERTY);
    }

    public int internalDatabaseTransactionSize() {
        return this.getProperty(INTERNAL_DATABASE_TRANSACTION_SIZE_PROPERTY);
    }

    public Path licensePath() {
        return this.getProperty(LICENSE_PATH_PROPERTY);
    }

    @NotNull
    public List<FFPropertyInfo<?>> defaultProperties() {
        return Stream.concat(this.commonProperties().stream(), this.implementationProperties().stream()).toList();
    }

    @NotNull
    public List<FFPropertyInfo<?>> commonProperties() {
        return List.of(SUBFOLDER_NAME_SEPARATOR_PROPERTY, SCAN_SUBFOLDERS_PROPERTY, DEFAULT_SCHEMA_PROPERTY, USE_INTERNAL_DATABASE_PROPERTY, INTERNAL_DATABASE_DIR_PROPERTY, INTERNAL_DATABASE_BATCH_SIZE_PROPERTY, INTERNAL_DATABASE_TRANSACTION_SIZE_PROPERTY, LICENSE_PATH_PROPERTY);
    }

    @NotNull
    public abstract List<FFPropertyInfo<?>> implementationProperties();

    @NotNull
    public List<FFPropertyInfo<?>> propertyInfos() {
        Map<String, FFPropertyInfo> defaultProperties = this.defaultProperties().stream().collect(Collectors.toMap(FFPropertyInfo::name, prop -> prop));
        for (String key : this.properties.stringPropertyNames()) {
            String value = this.properties.getProperty(key);
            defaultProperties.compute(key, (name, prop) -> {
                if (prop == null) {
                    return FFPropertyInfo.builder().withName(key).withValue(value).build();
                }
                return FFPropertyInfo.from(prop).withValue(prop.parser().apply(value)).build();
            });
        }
        return defaultProperties.values().stream().toList();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object o) {
        void that;
        if (this == o) {
            return true;
        }
        if (!(o instanceof FFProperties)) {
            return false;
        }
        FFProperties fFProperties = (FFProperties)o;
        return Objects.equals(this.toMap(), that.toMap());
    }

    public int hashCode() {
        return this.toMap().hashCode();
    }

    public String toString() {
        return this.properties.toString();
    }

    @Nullable
    protected <T> T getProperty(@NotNull FFPropertyInfo<T> property) {
        String value = this.properties.getProperty(property.name());
        if (value == null) {
            return property.value();
        }
        return property.parser().apply(value);
    }

    protected static Path parsePath(String path) {
        return path == null || path.isBlank() ? null : Path.of(path, new String[0]);
    }

    protected static FFPropertyInfo<String> buildWildcardProperty(String defaultWildCard) {
        return FFPropertyInfo.builder().withName("wildcard").withValue(defaultWildCard).withDescription("Wildcard for file names").isRequired(true).withParser(Function.identity()).build();
    }

    protected static FFPropertyInfo<Integer> buildSampleRowsProperty(int number) {
        return FFPropertyInfo.builder().withName("sampleRows").withValue(number).withDescription("Number of rows to extract metadata from").withParser(Integer::parseInt).build();
    }
}

