/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.api;

import com.dbeaver.jdbc.base.BaseJdbcUtils;
import com.dbeaver.jdbc.files.FFPropertiesFactory;
import com.dbeaver.jdbc.files.api.FFDataSource;
import com.dbeaver.jdbc.files.api.FFProperties;
import com.dbeaver.jdbc.files.api.FFPropertyInfo;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.api.ObjectWithContextParameters;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public record FFJdbcUrl<P extends FFProperties>(@NotNull String prefix, @NotNull List<FFDataSource<P>> dataSources) {
    public static final String DATA_SOURCE_SEPARATOR = ";";
    public static final String PARAMETER_VALUE_SEPARATOR = "=";
    public static final String PARAMETER_SEPARATOR = "&";

    public String toURL() {
        String s = this.dataSources.stream().map(FFDataSource::toURL).reduce((a, b) -> a + DATA_SOURCE_SEPARATOR + b).orElse("");
        return this.prefix + s;
    }

    @NotNull
    public static <P extends FFProperties> FFJdbcUrl<P> parse(@NotNull ObjectWithContextParameters object, @NotNull String prefix, @NotNull String url, @NotNull P defaultProperties, @NotNull FFPropertiesFactory<P> propertiesFactory) throws IOException {
        ArrayList<FFDataSource<P>> dataSources = new ArrayList<FFDataSource<P>>();
        String[] stringArray = FFJdbcUrl.definitions(prefix, url);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            String definition = s.trim();
            FFDataSource<P> pffDataSource = FFJdbcUrl.parseDataSource(object, definition, defaultProperties, propertiesFactory);
            dataSources.add(pffDataSource);
            ++n2;
        }
        if (dataSources.isEmpty()) {
            throw new MalformedURLException("No valid data sources found in the JDBC URL.");
        }
        return new FFJdbcUrl<P>(prefix, dataSources);
    }

    private static <P extends FFProperties> FFDataSource<P> parseDataSource(@NotNull ObjectWithContextParameters object, @NotNull String dataSourceDefinition, @NotNull P defaultProperties, @NotNull FFPropertiesFactory<P> propertiesFactory) throws IOException {
        String[] parts = dataSourceDefinition.split("\\?", 2);
        String sourcePathString = parts[0].trim();
        String queryParametersString = parts.length > 1 ? parts[1].trim() : "";
        Map<String, String> queryParameters = FFJdbcUrl.parseQueryParameters(queryParametersString);
        P properties = FFJdbcUrl.mergeProperties(defaultProperties, queryParameters, propertiesFactory);
        return new FFDataSource<P>(BaseJdbcUtils.resolvePathByStringOrUri((ObjectWithContextParameters)object, (String)sourcePathString), properties);
    }

    @NotNull
    private static String[] definitions(@NotNull String urlPrefix, @NotNull String jdbcUrl) throws MalformedURLException {
        if (!jdbcUrl.startsWith(urlPrefix)) {
            throw new MalformedURLException("JDBC URL does not start with the expected prefix: " + urlPrefix);
        }
        String dataPathSegment = jdbcUrl.substring(urlPrefix.length()).trim();
        if (dataPathSegment.isEmpty()) {
            throw new MalformedURLException("No data path specified in the JDBC URL.");
        }
        return dataPathSegment.split(DATA_SOURCE_SEPARATOR);
    }

    @NotNull
    private static Map<String, String> parseQueryParameters(@Nullable String queryParameters) throws MalformedURLException {
        String[] keyValuePairs;
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        if (queryParameters == null || queryParameters.isEmpty()) {
            return parameterMap;
        }
        String[] stringArray = keyValuePairs = queryParameters.split(PARAMETER_SEPARATOR);
        int n = keyValuePairs.length;
        int n2 = 0;
        while (n2 < n) {
            String pair = stringArray[n2];
            String[] keyAndValue = pair.split(PARAMETER_VALUE_SEPARATOR, 2);
            if (keyAndValue.length != 2) {
                throw new MalformedURLException("Invalid parameter format: " + pair);
            }
            String key = keyAndValue[0].trim();
            String value = keyAndValue[1].trim();
            if (key.isEmpty() || value.isEmpty()) {
                throw new MalformedURLException("Empty key or value in parameter: " + pair);
            }
            parameterMap.put(key, value);
            ++n2;
        }
        return parameterMap;
    }

    private static <P extends FFProperties> P mergeProperties(@NotNull P defaultProperties, @NotNull Map<String, String> queryParameters, @NotNull FFPropertiesFactory<P> propertiesFactory) {
        HashMap<String, String> mergedParameters = new HashMap<String, String>(defaultProperties.toMap());
        defaultProperties.defaultProperties().stream().filter(FFPropertyInfo::overridable).forEach(it -> {
            String overrideValue = (String)queryParameters.get(it.name());
            if (overrideValue != null) {
                mergedParameters.put(it.name(), overrideValue);
            }
        });
        return propertiesFactory.createProperties(mergedParameters);
    }
}

