/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.api;

import com.dbeaver.jdbc.base.CachedJdbcResultSet;
import com.dbeaver.jdbc.base.CachedJdbcResultSetMetaData;
import com.dbeaver.jdbc.base.ColumnInfo;
import com.dbeaver.jdbc.files.FFPropertiesFactory;
import com.dbeaver.jdbc.files.api.FFConnection;
import com.dbeaver.jdbc.files.api.FFIndexInfo;
import com.dbeaver.jdbc.files.api.FFPrimaryKeyInfo;
import com.dbeaver.jdbc.files.api.FFProperties;
import com.dbeaver.jdbc.files.api.FFPropertyInfo;
import com.dbeaver.jdbc.files.database.FFDatabase;
import com.dbeaver.jdbc.files.database.FFIndex;
import com.dbeaver.jdbc.files.database.FFPrimaryKey;
import com.dbeaver.jdbc.files.database.FFSQLType;
import com.dbeaver.jdbc.files.database.FFSchemaName;
import com.dbeaver.jdbc.files.database.FFTable;
import com.dbeaver.jdbc.files.database.FFTypeInfo;
import com.dbeaver.jdbc.files.utils.FFDriverUtils;
import com.dbeaver.jdbc.files.utils.FFExceptionUtils;
import com.dbeaver.jdbc.model.AbstractJdbcConnection;
import com.dbeaver.jdbc.model.AbstractJdbcDatabaseMetaData;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public abstract class FFDatabaseMetaData
extends AbstractJdbcDatabaseMetaData<FFConnection> {
    @NotNull
    private final FFDatabase database;
    @NotNull
    private final FFPropertiesFactory<?> propertiesFactory;

    public FFDatabaseMetaData(@NotNull FFConnection connection, @NotNull String url, @NotNull FFDatabase database, @NotNull FFPropertiesFactory<?> propertiesFactory) {
        super((AbstractJdbcConnection)connection, url);
        this.database = database;
        this.propertiesFactory = propertiesFactory;
    }

    public boolean isCatalogAtStart() throws SQLException {
        ((FFConnection)this.connection).ensureOpen();
        return true;
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        ((FFConnection)this.connection).ensureOpen();
        return true;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        ((FFConnection)this.connection).ensureOpen();
        return true;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        ((FFConnection)this.connection).ensureOpen();
        return true;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        ((FFConnection)this.connection).ensureOpen();
        return true;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        ((FFConnection)this.connection).ensureOpen();
        return true;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    public ResultSet getProcedures(@Nullable String catalog, @Nullable String schemaPattern, @NotNull String procedureNamePattern) throws SQLException {
        ((FFConnection)this.connection).ensureOpen();
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo("PROCEDURE_CAT", (SQLType)FFSQLType.VARCHAR, row -> row[0]), new ColumnInfo("PROCEDURE_SCHEM", (SQLType)FFSQLType.VARCHAR, row -> row[1]), new ColumnInfo("PROCEDURE_NAME", (SQLType)FFSQLType.VARCHAR, row -> row[2]), new ColumnInfo("RESERVED1", (SQLType)FFSQLType.VARCHAR, row -> null), new ColumnInfo("RESERVED2", (SQLType)FFSQLType.VARCHAR, row -> null), new ColumnInfo("RESERVED3", (SQLType)FFSQLType.VARCHAR, row -> null), new ColumnInfo("REMARKS", (SQLType)FFSQLType.VARCHAR, row -> row[3]), new ColumnInfo("PROCEDURE_TYPE", (SQLType)FFSQLType.INTEGER, row -> row[4]), new ColumnInfo("SPECIFIC_NAME", (SQLType)FFSQLType.VARCHAR, row -> row[5])};
        CachedJdbcResultSetMetaData resultSetMetaData = new CachedJdbcResultSetMetaData(null, columns);
        return new CachedJdbcResultSet(null, resultSetMetaData, (Object[])new Object[0][]);
    }

    public ResultSet getProcedureColumns(@Nullable String catalog, @Nullable String schemaPattern, @NotNull String procedureNamePattern, @NotNull String columnNamePattern) throws SQLException {
        ((FFConnection)this.connection).ensureOpen();
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo("PROCEDURE_CAT", (SQLType)FFSQLType.VARCHAR, row -> row[0]), new ColumnInfo("PROCEDURE_SCHEM", (SQLType)FFSQLType.VARCHAR, row -> row[1]), new ColumnInfo("PROCEDURE_NAME", (SQLType)FFSQLType.VARCHAR, row -> row[2]), new ColumnInfo("COLUMN_NAME", (SQLType)FFSQLType.VARCHAR, row -> row[3]), new ColumnInfo("COLUMN_TYPE", (SQLType)FFSQLType.INTEGER, row -> row[4]), new ColumnInfo("DATA_TYPE", (SQLType)FFSQLType.INTEGER, row -> row[5]), new ColumnInfo("TYPE_NAME", (SQLType)FFSQLType.VARCHAR, row -> row[6]), new ColumnInfo("PRECISION", (SQLType)FFSQLType.INTEGER, row -> row[7]), new ColumnInfo("LENGTH", (SQLType)FFSQLType.INTEGER, row -> row[8]), new ColumnInfo("SCALE", (SQLType)FFSQLType.INTEGER, row -> row[9]), new ColumnInfo("RADIX", (SQLType)FFSQLType.INTEGER, row -> row[10]), new ColumnInfo("NULLABLE", (SQLType)FFSQLType.INTEGER, row -> row[11]), new ColumnInfo("REMARKS", (SQLType)FFSQLType.VARCHAR, row -> row[12]), new ColumnInfo("COLUMN_DEF", (SQLType)FFSQLType.VARCHAR, row -> row[13]), new ColumnInfo("SQL_DATA_TYPE", (SQLType)FFSQLType.INTEGER, row -> row[14]), new ColumnInfo("SQL_DATETIME_SUB", (SQLType)FFSQLType.INTEGER, row -> row[15]), new ColumnInfo("CHAR_OCTET_LENGTH", (SQLType)FFSQLType.INTEGER, row -> row[16]), new ColumnInfo("ORDINAL_POSITION", (SQLType)FFSQLType.INTEGER, row -> row[17]), new ColumnInfo("IS_NULLABLE", (SQLType)FFSQLType.VARCHAR, row -> row[18]), new ColumnInfo("SPECIFIC_NAME", (SQLType)FFSQLType.VARCHAR, row -> row[19])};
        CachedJdbcResultSetMetaData resultSetMetaData = new CachedJdbcResultSetMetaData(null, columns);
        return new CachedJdbcResultSet(null, resultSetMetaData, (Object[])new Object[0][]);
    }

    public ResultSet getClientInfoProperties() throws SQLException {
        ((FFConnection)this.connection).ensureOpen();
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo("NAME", (SQLType)FFSQLType.VARCHAR, FFPropertyInfo::name), new ColumnInfo("MAX_LEN", (SQLType)FFSQLType.INTEGER, it -> null), new ColumnInfo("DEFAULT_VALUE", (SQLType)FFSQLType.VARCHAR, FFPropertyInfo::value), new ColumnInfo("DESCRIPTION", (SQLType)FFSQLType.VARCHAR, FFPropertyInfo::description)};
        CachedJdbcResultSetMetaData resultSetMetaData = new CachedJdbcResultSetMetaData(null, columns);
        Object[] driverProperties = (FFPropertyInfo[])((FFProperties)this.propertiesFactory.createProperties(new Properties())).propertyInfos().stream().sorted(Comparator.comparing(FFPropertyInfo::name)).toArray(FFPropertyInfo[]::new);
        return new CachedJdbcResultSet(null, resultSetMetaData, driverProperties);
    }

    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        ((FFConnection)this.connection).ensureOpen();
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo("FUNCTION_CAT", (SQLType)FFSQLType.VARCHAR, row -> row[0]), new ColumnInfo("FUNCTION_SCHEM", (SQLType)FFSQLType.VARCHAR, row -> row[1]), new ColumnInfo("FUNCTION_NAME", (SQLType)FFSQLType.VARCHAR, row -> row[2]), new ColumnInfo("REMARKS", (SQLType)FFSQLType.VARCHAR, row -> row[3]), new ColumnInfo("FUNCTION_TYPE", (SQLType)FFSQLType.INTEGER, row -> row[4]), new ColumnInfo("SPECIFIC_NAME", (SQLType)FFSQLType.VARCHAR, row -> row[5])};
        CachedJdbcResultSetMetaData resultSetMetaData = new CachedJdbcResultSetMetaData(null, columns);
        return new CachedJdbcResultSet(null, resultSetMetaData, (Object[])new Object[0][]);
    }

    public ResultSet getFunctionColumns(@Nullable String catalog, @Nullable String schemaPattern, @NotNull String functionNamePattern, @NotNull String columnNamePattern) throws SQLException {
        ((FFConnection)this.connection).ensureOpen();
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo("FUNCTION_CAT", (SQLType)FFSQLType.VARCHAR, row -> row[0]), new ColumnInfo("FUNCTION_SCHEM", (SQLType)FFSQLType.VARCHAR, row -> row[1]), new ColumnInfo("FUNCTION_NAME", (SQLType)FFSQLType.VARCHAR, row -> row[2]), new ColumnInfo("COLUMN_NAME", (SQLType)FFSQLType.VARCHAR, row -> row[3]), new ColumnInfo("COLUMN_TYPE", (SQLType)FFSQLType.INTEGER, row -> row[4]), new ColumnInfo("DATA_TYPE", (SQLType)FFSQLType.INTEGER, row -> row[5]), new ColumnInfo("TYPE_NAME", (SQLType)FFSQLType.VARCHAR, row -> row[6]), new ColumnInfo("PRECISION", (SQLType)FFSQLType.INTEGER, row -> row[7]), new ColumnInfo("LENGTH", (SQLType)FFSQLType.INTEGER, row -> row[8]), new ColumnInfo("SCALE", (SQLType)FFSQLType.INTEGER, row -> row[9]), new ColumnInfo("RADIX", (SQLType)FFSQLType.INTEGER, row -> row[10]), new ColumnInfo("NULLABLE", (SQLType)FFSQLType.INTEGER, row -> row[11]), new ColumnInfo("REMARKS", (SQLType)FFSQLType.VARCHAR, row -> row[12]), new ColumnInfo("CHAR_OCTET_LENGTH", (SQLType)FFSQLType.INTEGER, row -> row[13]), new ColumnInfo("ORDINAL_POSITION", (SQLType)FFSQLType.INTEGER, row -> row[14]), new ColumnInfo("IS_NULLABLE", (SQLType)FFSQLType.VARCHAR, row -> row[15]), new ColumnInfo("SPECIFIC_NAME", (SQLType)FFSQLType.VARCHAR, row -> row[16])};
        CachedJdbcResultSetMetaData resultSetMetaData = new CachedJdbcResultSetMetaData(null, columns);
        return new CachedJdbcResultSet(null, resultSetMetaData, (Object[])new Object[0][]);
    }

    public ResultSet getCatalogs() throws SQLException {
        ((FFConnection)this.connection).ensureOpen();
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo("TABLE_CAT", (SQLType)FFSQLType.VARCHAR, it -> it)};
        CachedJdbcResultSetMetaData resultSetMetaData = new CachedJdbcResultSetMetaData(null, columns);
        return new CachedJdbcResultSet(null, resultSetMetaData, (Object[])new String[0]);
    }

    public ResultSet getTableTypes() throws SQLException {
        ((FFConnection)this.connection).ensureOpen();
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo("TABLE_TYPE", (SQLType)FFSQLType.VARCHAR, it -> it)};
        CachedJdbcResultSetMetaData resultSetMetaData = new CachedJdbcResultSetMetaData(null, columns);
        return new CachedJdbcResultSet(null, resultSetMetaData, (Object[])new String[]{"TABLE"});
    }

    @NotNull
    public ResultSet getSchemas() throws SQLException {
        ((FFConnection)this.connection).ensureOpen();
        return this.getSchemas(null, null);
    }

    @NotNull
    public ResultSet getSchemas(@Nullable String catalog, @Nullable String schemaPattern) throws SQLException {
        ((FFConnection)this.connection).ensureOpen();
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo("TABLE_SCHEM", (SQLType)FFSQLType.VARCHAR, FFSchemaName::name), new ColumnInfo("TABLE_CATALOG", (SQLType)FFSQLType.VARCHAR, ignored -> null)};
        CachedJdbcResultSetMetaData resultSetMetaData = new CachedJdbcResultSetMetaData(null, columns);
        Object[] rows = (FFSchemaName[])this.database.schemas(catalog, FFDriverUtils.convertSqlPatternToRegexPattern(schemaPattern)).toArray(FFSchemaName[]::new);
        return new CachedJdbcResultSet(null, resultSetMetaData, rows);
    }

    public ResultSet getTables(@Nullable String catalog, @Nullable String schemaPattern, @Nullable String tableNamePattern, @Nullable String[] types) throws SQLException {
        ((FFConnection)this.connection).ensureOpen();
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo("TABLE_CAT", (SQLType)FFSQLType.VARCHAR, metadata -> null), new ColumnInfo("TABLE_SCHEM", (SQLType)FFSQLType.VARCHAR, metadata -> metadata.tableName().schema().name()), new ColumnInfo("TABLE_NAME", (SQLType)FFSQLType.VARCHAR, metadata -> metadata.tableName().name()), new ColumnInfo("TABLE_TYPE", (SQLType)FFSQLType.VARCHAR, metadata -> "TABLE"), new ColumnInfo("REMARKS", (SQLType)FFSQLType.VARCHAR, FFTable::remarks), new ColumnInfo("TYPE_CAT", (SQLType)FFSQLType.VARCHAR, metadata -> null), new ColumnInfo("TYPE_SCHEM", (SQLType)FFSQLType.VARCHAR, metadata -> null), new ColumnInfo("TYPE_NAME", (SQLType)FFSQLType.VARCHAR, metadata -> null), new ColumnInfo("SELF_REFERENCING_COL_NAME", (SQLType)FFSQLType.VARCHAR, metadata -> null), new ColumnInfo("REF_GENERATION", (SQLType)FFSQLType.VARCHAR, metadata -> null)};
        CachedJdbcResultSetMetaData resultSetMetaData = new CachedJdbcResultSetMetaData(null, columns);
        Object[] rows = (FFTable[])this.database.tables(catalog, FFDriverUtils.convertSqlPatternToRegexPattern(schemaPattern), FFDriverUtils.convertSqlPatternToRegexPattern(tableNamePattern)).toArray(FFTable[]::new);
        return new CachedJdbcResultSet(null, resultSetMetaData, rows);
    }

    @NotNull
    public ResultSet getColumns(@Nullable String catalog, @Nullable String schemaPattern, @Nullable String tablePattern, @Nullable String columnPattern) throws SQLException {
        ((FFConnection)this.connection).ensureOpen();
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo("TABLE_CAT", (SQLType)FFSQLType.VARCHAR, ColumnInfo::catalogName), new ColumnInfo("TABLE_SCHEM", (SQLType)FFSQLType.VARCHAR, ColumnInfo::schemaName), new ColumnInfo("TABLE_NAME", (SQLType)FFSQLType.VARCHAR, ColumnInfo::tableName), new ColumnInfo("COLUMN_NAME", (SQLType)FFSQLType.VARCHAR, ColumnInfo::columnLabel), new ColumnInfo("DATA_TYPE", (SQLType)FFSQLType.INTEGER, ColumnInfo::type), new ColumnInfo("TYPE_NAME", (SQLType)FFSQLType.VARCHAR, ColumnInfo::typeName), new ColumnInfo("COLUMN_SIZE", (SQLType)FFSQLType.INTEGER, ColumnInfo::precision), new ColumnInfo("BUFFER_LENGTH", (SQLType)FFSQLType.INTEGER, columnInfo -> null), new ColumnInfo("DECIMAL_DIGITS", (SQLType)FFSQLType.INTEGER, columnInfo -> 0), new ColumnInfo("NUM_PREC_RADIX", (SQLType)FFSQLType.INTEGER, columnInfo -> null), new ColumnInfo("NULLABLE", (SQLType)FFSQLType.INTEGER, ColumnInfo::nullable), new ColumnInfo("REMARKS", (SQLType)FFSQLType.VARCHAR, columnInfo -> null), new ColumnInfo("COLUMN_DEF", (SQLType)FFSQLType.VARCHAR, columnInfo -> null), new ColumnInfo("SQL_DATA_TYPE", (SQLType)FFSQLType.INTEGER, columnInfo -> null), new ColumnInfo("SQL_DATETIME_SUB", (SQLType)FFSQLType.INTEGER, columnInfo -> null), new ColumnInfo("CHAR_OCTET_LENGTH", (SQLType)FFSQLType.INTEGER, ColumnInfo::precision), new ColumnInfo("ORDINAL_POSITION", (SQLType)FFSQLType.INTEGER, columnInfo -> null), new ColumnInfo("IS_NULLABLE", (SQLType)FFSQLType.VARCHAR, ColumnInfo::nullable), new ColumnInfo("SCOPE_CATALOG", (SQLType)FFSQLType.VARCHAR, columnInfo -> null), new ColumnInfo("SCOPE_SCHEMA", (SQLType)FFSQLType.VARCHAR, columnInfo -> null), new ColumnInfo("SCOPE_TABLE", (SQLType)FFSQLType.VARCHAR, columnInfo -> null), new ColumnInfo("SOURCE_DATA_TYPE", (SQLType)FFSQLType.INTEGER, columnInfo -> null), new ColumnInfo("IS_AUTOINCREMENT", (SQLType)FFSQLType.VARCHAR, columnInfo -> "NO"), new ColumnInfo("IS_GENERATEDCOLUMN", (SQLType)FFSQLType.VARCHAR, columnInfo -> "NO")};
        CachedJdbcResultSetMetaData resultSetMetaData = new CachedJdbcResultSetMetaData(null, columns);
        Object[] rows = (ColumnInfo[])this.database.columns(catalog, FFDriverUtils.convertSqlPatternToRegexPattern(schemaPattern), FFDriverUtils.convertSqlPatternToRegexPattern(tablePattern), FFDriverUtils.convertSqlPatternToRegexPattern(columnPattern)).toArray(ColumnInfo[]::new);
        return new CachedJdbcResultSet(null, resultSetMetaData, rows);
    }

    public ResultSet getPrimaryKeys(@Nullable String catalog, @Nullable String schema, @NotNull String table) throws SQLException {
        ((FFConnection)this.connection).ensureOpen();
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo("TABLE_CAT", (SQLType)FFSQLType.VARCHAR, FFPrimaryKeyInfo::tableCatalog), new ColumnInfo("TABLE_SCHEM", (SQLType)FFSQLType.VARCHAR, FFPrimaryKeyInfo::tableSchema), new ColumnInfo("TABLE_NAME", (SQLType)FFSQLType.VARCHAR, FFPrimaryKeyInfo::tableName), new ColumnInfo("COLUMN_NAME", (SQLType)FFSQLType.VARCHAR, FFPrimaryKeyInfo::columnName), new ColumnInfo("KEY_SEQ", (SQLType)FFSQLType.INTEGER, FFPrimaryKeyInfo::keySeq), new ColumnInfo("PK_NAME", (SQLType)FFSQLType.VARCHAR, FFPrimaryKeyInfo::pkName)};
        CachedJdbcResultSetMetaData resultSetMetaData = new CachedJdbcResultSetMetaData(null, columns);
        List<FFTable<?, ?>> tables = this.database.tables(catalog, FFDriverUtils.convertSqlPatternToRegexPattern(schema), FFDriverUtils.convertSqlPatternToRegexPattern(table));
        ArrayList<FFPrimaryKeyInfo> rows = new ArrayList<FFPrimaryKeyInfo>();
        for (FFTable<?, ?> ffTable : tables) {
            rows.addAll(this.getPrimaryKeyInfo(ffTable));
        }
        return new CachedJdbcResultSet(null, resultSetMetaData, (Object[])rows.toArray(new FFPrimaryKeyInfo[0]));
    }

    @NotNull
    private List<FFPrimaryKeyInfo> getPrimaryKeyInfo(@NotNull FFTable<?, ?> table) throws SQLException {
        try {
            FFPrimaryKey primaryKey = table.structure().primaryKey();
            if (primaryKey == null) {
                return List.of();
            }
            return FFPrimaryKeyInfo.of(primaryKey);
        }
        catch (IOException e) {
            throw FFExceptionUtils.wrapException(e);
        }
    }

    public ResultSet getImportedKeys(@Nullable String catalog, @Nullable String schema, @NotNull String table) throws SQLException {
        ((FFConnection)this.connection).ensureOpen();
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo("PKTABLE_CAT", (SQLType)FFSQLType.VARCHAR, row -> row[0]), new ColumnInfo("PKTABLE_SCHEM", (SQLType)FFSQLType.VARCHAR, row -> row[1]), new ColumnInfo("PKTABLE_NAME", (SQLType)FFSQLType.VARCHAR, row -> row[2]), new ColumnInfo("PKCOLUMN_NAME", (SQLType)FFSQLType.VARCHAR, row -> row[3]), new ColumnInfo("FKTABLE_CAT", (SQLType)FFSQLType.VARCHAR, row -> row[4]), new ColumnInfo("FKTABLE_SCHEM", (SQLType)FFSQLType.VARCHAR, row -> row[5]), new ColumnInfo("FKTABLE_NAME", (SQLType)FFSQLType.VARCHAR, row -> row[6]), new ColumnInfo("FKCOLUMN_NAME", (SQLType)FFSQLType.VARCHAR, row -> row[7]), new ColumnInfo("KEY_SEQ", (SQLType)FFSQLType.INTEGER, row -> row[8]), new ColumnInfo("UPDATE_RULE", (SQLType)FFSQLType.INTEGER, row -> row[9]), new ColumnInfo("DELETE_RULE", (SQLType)FFSQLType.INTEGER, row -> row[10]), new ColumnInfo("FK_NAME", (SQLType)FFSQLType.VARCHAR, row -> row[11]), new ColumnInfo("PK_NAME", (SQLType)FFSQLType.VARCHAR, row -> row[12]), new ColumnInfo("DEFERRABILITY", (SQLType)FFSQLType.INTEGER, row -> row[13])};
        CachedJdbcResultSetMetaData resultSetMetaData = new CachedJdbcResultSetMetaData(null, columns);
        return new CachedJdbcResultSet(null, resultSetMetaData, (Object[])new Object[0][]);
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        ((FFConnection)this.connection).ensureOpen();
        return true;
    }

    @NotNull
    public String getIdentifierQuoteString() throws SQLException {
        ((FFConnection)this.connection).ensureOpen();
        return String.valueOf('\"');
    }

    public ResultSet getTypeInfo() throws SQLException {
        ((FFConnection)this.connection).ensureOpen();
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo("TYPE_NAME", (SQLType)FFSQLType.VARCHAR, row -> row.jdbcType().getName()), new ColumnInfo("DATA_TYPE", (SQLType)FFSQLType.INTEGER, row -> row.jdbcType().getVendorTypeNumber()), new ColumnInfo("PRECISION", (SQLType)FFSQLType.INTEGER, FFTypeInfo::precision), new ColumnInfo("LITERAL_PREFIX", (SQLType)FFSQLType.VARCHAR, FFTypeInfo::literalPrefix), new ColumnInfo("LITERAL_SUFFIX", (SQLType)FFSQLType.VARCHAR, FFTypeInfo::literalSuffix), new ColumnInfo("CREATE_PARAMS", (SQLType)FFSQLType.VARCHAR, FFTypeInfo::createParams), new ColumnInfo("NULLABLE", (SQLType)FFSQLType.INTEGER, FFTypeInfo::nullable), new ColumnInfo("CASE_SENSITIVE", (SQLType)FFSQLType.BOOLEAN, FFTypeInfo::caseSensitive), new ColumnInfo("SEARCHABLE", (SQLType)FFSQLType.INTEGER, FFTypeInfo::searchable), new ColumnInfo("UNSIGNED_ATTRIBUTE", (SQLType)FFSQLType.BOOLEAN, FFTypeInfo::unsigned), new ColumnInfo("FIXED_PREC_SCALE", (SQLType)FFSQLType.BOOLEAN, FFTypeInfo::fixedPrecScale), new ColumnInfo("AUTO_INCREMENT", (SQLType)FFSQLType.BOOLEAN, FFTypeInfo::autoIncrement), new ColumnInfo("LOCAL_TYPE_NAME", (SQLType)FFSQLType.VARCHAR, FFTypeInfo::localTypeName), new ColumnInfo("MINIMUM_SCALE", (SQLType)FFSQLType.INTEGER, FFTypeInfo::minimumScale), new ColumnInfo("MAXIMUM_SCALE", (SQLType)FFSQLType.INTEGER, FFTypeInfo::maximumScale), new ColumnInfo("SQL_DATA_TYPE", (SQLType)FFSQLType.INTEGER, row -> 0), new ColumnInfo("SQL_DATETIME_SUB", (SQLType)FFSQLType.INTEGER, row -> 0), new ColumnInfo("NUM_PREC_RADIX", (SQLType)FFSQLType.INTEGER, FFTypeInfo::radix)};
        CachedJdbcResultSetMetaData resultSetMetaData = new CachedJdbcResultSetMetaData(null, columns);
        Object[] sortedTypes = (FFTypeInfo[])Arrays.stream(FFSQLType.values()).map(FFTypeInfo::of).sorted(Comparator.comparingInt(info -> info.jdbcType().getVendorTypeNumber())).toArray(FFTypeInfo[]::new);
        return new CachedJdbcResultSet(null, resultSetMetaData, sortedTypes);
    }

    public ResultSet getIndexInfo(@Nullable String catalog, @Nullable String schema, String tableName, boolean unique, boolean approximate) throws SQLException {
        ((FFConnection)this.connection).ensureOpen();
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo("TABLE_CAT", (SQLType)FFSQLType.VARCHAR, FFIndexInfo::tableCatalog), new ColumnInfo("TABLE_SCHEM", (SQLType)FFSQLType.VARCHAR, FFIndexInfo::tableSchema), new ColumnInfo("TABLE_NAME", (SQLType)FFSQLType.VARCHAR, FFIndexInfo::tableName), new ColumnInfo("NON_UNIQUE", (SQLType)FFSQLType.BOOLEAN, FFIndexInfo::nonUnique), new ColumnInfo("INDEX_QUALIFIER", (SQLType)FFSQLType.VARCHAR, FFIndexInfo::indexQualifier), new ColumnInfo("INDEX_NAME", (SQLType)FFSQLType.VARCHAR, FFIndexInfo::indexName), new ColumnInfo("TYPE", (SQLType)FFSQLType.INTEGER, FFIndexInfo::type), new ColumnInfo("ORDINAL_POSITION", (SQLType)FFSQLType.INTEGER, FFIndexInfo::ordinalPosition), new ColumnInfo("COLUMN_NAME", (SQLType)FFSQLType.VARCHAR, FFIndexInfo::columnName), new ColumnInfo("ASC_OR_DESC", (SQLType)FFSQLType.VARCHAR, FFIndexInfo::ascOrDesc), new ColumnInfo("CARDINALITY", (SQLType)FFSQLType.INTEGER, FFIndexInfo::cardinality), new ColumnInfo("PAGES", (SQLType)FFSQLType.INTEGER, FFIndexInfo::pages), new ColumnInfo("FILTER_CONDITION", (SQLType)FFSQLType.VARCHAR, FFIndexInfo::filterCondition)};
        CachedJdbcResultSetMetaData resultSetMetaData = new CachedJdbcResultSetMetaData(null, columns);
        List<FFTable<?, ?>> tables = this.database.tables(catalog, FFDriverUtils.convertSqlPatternToRegexPattern(schema), FFDriverUtils.convertSqlPatternToRegexPattern(tableName));
        ArrayList<FFIndexInfo> rows = new ArrayList<FFIndexInfo>();
        for (FFTable<?, ?> table : tables) {
            rows.addAll(this.getIndexInfo(table));
        }
        return new CachedJdbcResultSet(null, resultSetMetaData, (Object[])rows.toArray(new FFIndexInfo[0]));
    }

    @NotNull
    private List<FFIndexInfo> getIndexInfo(@NotNull FFTable<?, ?> table) throws SQLException {
        try {
            ArrayList<FFIndexInfo> indexInfos = new ArrayList<FFIndexInfo>();
            for (FFIndex index : table.structure().indices()) {
                indexInfos.addAll(FFIndexInfo.of(index));
            }
            return indexInfos;
        }
        catch (IOException e) {
            throw FFExceptionUtils.wrapException(e);
        }
    }

    public boolean isReadOnly() throws SQLException {
        ((FFConnection)this.connection).ensureOpen();
        return true;
    }

    public abstract String getDatabaseProductName() throws SQLException;

    public abstract String getDatabaseProductVersion() throws SQLException;
}

