/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files;

import com.dbeaver.jdbc.files.FFDataFileMetadataReader;
import com.dbeaver.jdbc.files.FFExternalMetadataReader;
import com.dbeaver.jdbc.files.FFFileScanner;
import com.dbeaver.jdbc.files.FFStructureMappingStrategy;
import com.dbeaver.jdbc.files.FFTableNameFactory;
import com.dbeaver.jdbc.files.FFTableReaderFactory;
import com.dbeaver.jdbc.files.api.FFDataSource;
import com.dbeaver.jdbc.files.database.FFSchemaName;
import com.dbeaver.jdbc.files.database.FFTable;
import com.dbeaver.jdbc.files.database.FFTableDefinition;
import com.dbeaver.jdbc.files.database.FFTableName;
import com.dbeaver.jdbc.files.database.FFTableProperties;
import com.dbeaver.jdbc.files.database.FFTableSource;
import com.dbeaver.jdbc.files.database.FFTableStructure;
import com.dbeaver.jdbc.files.exception.FFMappingException;
import com.dbeaver.jdbc.files.utils.FFDriverUtils;
import com.dbeaver.jdbc.files.utils.FFLazyValue;
import com.dbeaver.jdbc.files.utils.FFMetadataUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.utils.Pair;

public class FFFileScannerImpl<T, TP extends FFTableProperties>
implements FFFileScanner<T, TP> {
    private static final String METADATA_FILE_EXTENSION = "ddl";
    @NotNull
    protected final FFTableNameFactory tableNameFactory;
    @NotNull
    private final FFDataFileMetadataReader<T, TP> metadataReader;
    @NotNull
    private final FFExternalMetadataReader<TP> externalMetadataReader;
    @NotNull
    private final FFTableReaderFactory<T, TP> tableReaderFactory;
    @NotNull
    private final FFStructureMappingStrategy<T, TP> structureMappingStrategy;

    public FFFileScannerImpl(@NotNull FFTableNameFactory tableNameFactory, @NotNull FFDataFileMetadataReader<T, TP> metadataReader, @NotNull FFExternalMetadataReader<TP> externalMetadataReader, @NotNull FFTableReaderFactory<T, TP> tableReaderFactory, @NotNull FFStructureMappingStrategy<T, TP> structureMappingStrategy) {
        this.tableNameFactory = tableNameFactory;
        this.metadataReader = metadataReader;
        this.externalMetadataReader = externalMetadataReader;
        this.tableReaderFactory = tableReaderFactory;
        this.structureMappingStrategy = structureMappingStrategy;
    }

    @Override
    @NotNull
    public List<FFTable<T, TP>> scan(@NotNull FFDataSource<?> dataSource, @NotNull Path dataFile) throws IOException {
        return this.performScan(dataSource, dataFile, FFFileScannerImpl.findMetadataFile(dataFile));
    }

    @NotNull
    private List<FFTable<T, TP>> performScan(@NotNull FFDataSource<?> dataSource, @NotNull Path dataFile, @Nullable Path metadataFile) throws IOException {
        List<String> tableSourceNames = this.metadataReader.getTableSourceNames(dataFile);
        if (tableSourceNames.isEmpty()) {
            return List.of();
        }
        List<FFTableName> tableNames = this.tableNameFactory.createTableNames(dataFile, tableSourceNames).stream().map(FFFileScannerImpl::normalizeTableName).toList();
        try {
            List<FFTableDefinition<T, TP>> definitions = metadataFile == null ? List.of() : this.externalMetadataReader.readTableDefinitions(tableNames.get(0).schema(), metadataFile);
            return this.buildTables(dataSource, dataFile, metadataFile, tableNames, tableSourceNames, definitions);
        }
        catch (Exception mappingException) {
            return this.buildFallbackTables(dataSource, dataFile, metadataFile, tableNames, tableSourceNames, mappingException);
        }
    }

    @NotNull
    private List<FFTable<T, TP>> buildTables(@NotNull FFDataSource<?> dataSource, @NotNull Path dataFile, @Nullable Path metadataFile, @NotNull List<FFTableName> tableNames, @NotNull List<String> tableSourceNames, @NotNull List<FFTableDefinition<T, TP>> definitions) throws FFMappingException {
        assert (tableNames.size() == tableSourceNames.size());
        List<Pair<String, FFTableDefinition<T, TP>>> mappedTables = this.structureMappingStrategy.map(tableSourceNames, definitions);
        ArrayList<FFTable<T, TP>> tables = new ArrayList<FFTable<T, TP>>();
        int i = 0;
        while (i < mappedTables.size()) {
            Pair<String, FFTableDefinition<T, TP>> mappedTable = mappedTables.get(i);
            String tableSource = (String)mappedTable.getFirst();
            FFTableDefinition definition = (FFTableDefinition)mappedTable.getSecond();
            FFTableName tableName = tableNames.get(i);
            FFTable table = new FFTable(definition != null ? definition.tableName() : tableName, this.buildTableStructureLazyValue(tableName.schema(), dataFile, tableSource, definition), new FFTableSource(dataSource, List.of(dataFile), tableSource, metadataFile), this.tableReaderFactory);
            tables.add(table);
            ++i;
        }
        return tables;
    }

    @NotNull
    private List<FFTable<T, TP>> buildFallbackTables(@NotNull FFDataSource<?> dataSource, @NotNull Path dataFile, @Nullable Path metadataFile, @NotNull List<FFTableName> tableNames, @NotNull List<String> tableSourceNames, final @NotNull Exception mappingException) {
        assert (tableNames.size() == tableSourceNames.size());
        FFLazyValue lazyValue = new FFLazyValue<FFTableStructure<T, TP>, IOException>(){

            @Override
            protected FFTableStructure<T, TP> initialize() throws IOException {
                throw new IOException("Failed to map table definitions to data sources", mappingException);
            }
        };
        ArrayList<FFTable<T, TP>> tables = new ArrayList<FFTable<T, TP>>();
        int i = 0;
        while (i < tableNames.size()) {
            FFTableName tableName = tableNames.get(i);
            String tableSource = tableSourceNames.get(i);
            FFTable<T, TP> table = new FFTable<T, TP>(tableName, lazyValue, new FFTableSource(dataSource, List.of(dataFile), tableSource, metadataFile), this.tableReaderFactory);
            tables.add(table);
            ++i;
        }
        return tables;
    }

    private FFLazyValue<FFTableStructure<T, TP>, IOException> buildTableStructureLazyValue(final @NotNull FFSchemaName schemaName, final @NotNull Path dataFile, final @NotNull String dataSourceName, final @Nullable FFTableDefinition<T, TP> definition) {
        if (definition != null) {
            return new FFLazyValue<FFTableStructure<T, TP>, IOException>(){

                @Override
                protected FFTableStructure<T, TP> initialize() throws IOException {
                    return FFDriverUtils.mergeStructures(FFFileScannerImpl.this.metadataReader.getTableStructure(schemaName, dataFile, dataSourceName), definition.tableStructure());
                }
            };
        }
        return new FFLazyValue<FFTableStructure<T, TP>, IOException>(){

            @Override
            protected FFTableStructure<T, TP> initialize() throws IOException {
                return FFFileScannerImpl.this.metadataReader.getTableStructure(schemaName, dataFile, dataSourceName);
            }
        };
    }

    @Nullable
    private static Path findMetadataFile(@NotNull Path dataFile) {
        String ddlFileName = String.valueOf(dataFile.getFileName()) + ".ddl";
        Path metadataFilePath = dataFile.resolveSibling(ddlFileName);
        if (Files.isRegularFile(metadataFilePath, new LinkOption[0])) {
            return metadataFilePath;
        }
        return null;
    }

    @NotNull
    private static FFTableName normalizeTableName(@NotNull FFTableName ffTableName) {
        FFSchemaName schemaName = ffTableName.schema();
        String tableName = ffTableName.name();
        return new FFTableName(new FFSchemaName(FFMetadataUtils.normalizeObjectName(schemaName.name())), FFMetadataUtils.normalizeObjectName(tableName));
    }
}

