/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.net.auth.profile;

import com.dbeaver.net.auth.profile.AuthModelProfileCredentials;
import java.util.Map;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceURLProvider;
import org.jkiss.dbeaver.model.access.DBAAuthCredentials;
import org.jkiss.dbeaver.model.access.DBAAuthModel;
import org.jkiss.dbeaver.model.access.DBAAuthProfile;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.connection.DBPAuthModelDescriptor;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class AuthModelProfile
implements DBAAuthModel<AuthModelProfileCredentials>,
DBPDataSourceURLProvider {
    private static final Log log = Log.getLog(AuthModelProfile.class);

    @NotNull
    public AuthModelProfileCredentials createCredentials() {
        return new AuthModelProfileCredentials();
    }

    @NotNull
    public AuthModelProfileCredentials loadCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration) {
        AuthModelProfileCredentials credentials = new AuthModelProfileCredentials();
        try {
            credentials.setProfile(this.getAuthProfile(dataSource, configuration));
        }
        catch (DBException e) {
            log.debug((Object)e);
        }
        return credentials;
    }

    public void saveCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull AuthModelProfileCredentials credentials) {
        DBAAuthProfile profile = credentials.getProfile();
        configuration.setAuthProperty("profile-id", profile == null ? null : profile.getProfileId());
    }

    public Object initAuthentication(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull AuthModelProfileCredentials credentials, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) throws DBException {
        DBAAuthProfile authProfile = credentials.getProfile();
        if (authProfile == null) {
            String profileProperty = configuration.getAuthProperty("profile-id");
            if (CommonUtils.isEmpty((String)profileProperty)) {
                throw new DBException("The connection profile is not selected. Please select a profile from the list or create it using a profile manager.");
            }
            throw new DBException("Auth profile '" + profileProperty + "' not found");
        }
        DBPAuthModelDescriptor authModel = authProfile.getAuthModel();
        if (authModel == null) {
            throw new DBException("Authentication model not specified");
        }
        DBPProject project = authProfile.getProject();
        if (project != null && project.isUseSecretStorage()) {
            DBSSecretController secretController = DBSSecretController.getProjectSecretController((DBPProject)project);
            authProfile.resolveSecrets(secretController);
        }
        Map oldAuthProperties = configuration.getAuthProperties();
        String oldUserName = configuration.getUserName();
        String oldUserPassword = configuration.getUserPassword();
        boolean oldSavePassword = dataSource.getContainer().isSavePassword();
        configuration.setAuthProperties(authProfile.getProperties());
        if (!CommonUtils.isEmpty((String)authProfile.getUserName())) {
            configuration.setUserName(authProfile.getUserName());
        }
        if (!CommonUtils.isEmpty((String)authProfile.getUserPassword())) {
            configuration.setUserPassword(authProfile.getUserPassword());
        }
        if (authProfile.isSavePassword()) {
            dataSource.getContainer().setSavePassword(authProfile.isSavePassword());
        }
        try {
            DBAAuthModel authModelInstance = authModel.getInstance();
            DBAAuthCredentials amCredentials = authModelInstance.loadCredentials(dataSource.getContainer(), configuration);
            authModelInstance.initAuthentication(monitor, dataSource, amCredentials, configuration, connProperties);
            DBAAuthCredentials dBAAuthCredentials = amCredentials;
            return dBAAuthCredentials;
        }
        finally {
            configuration.setAuthProperties(oldAuthProperties);
            configuration.setUserName(oldUserName);
            configuration.setUserPassword(oldUserPassword);
            dataSource.getContainer().setSavePassword(oldSavePassword);
        }
    }

    public void endAuthentication(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) {
        block5: {
            try {
                DBAAuthProfile authProfile = this.getAuthProfile(dataSource, configuration);
                DBPAuthModelDescriptor authModel = authProfile.getAuthModel();
                if (authModel == null) break block5;
                Map oldAuthProperties = configuration.getAuthProperties();
                try {
                    authModel.getInstance().endAuthentication(dataSource, configuration, connProperties);
                }
                finally {
                    configuration.setAuthProperties(oldAuthProperties);
                }
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        }
    }

    public void refreshCredentials(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull AuthModelProfileCredentials credentials) throws DBException {
        DBPAuthModelDescriptor authModelDesc = this.getConfiguredAuthModel(dataSource, configuration);
        DBAAuthModel authModel = authModelDesc.getInstance();
        DBAAuthCredentials amCreds = authModel.loadCredentials(dataSource, configuration);
        authModel.refreshCredentials(monitor, dataSource, configuration, amCreds);
    }

    @NotNull
    private DBPAuthModelDescriptor getConfiguredAuthModel(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration) throws DBException {
        DBAAuthProfile authProfile = this.getAuthProfile(dataSource, configuration);
        DBPAuthModelDescriptor authModel = authProfile.getAuthModel();
        if (authModel == null) {
            throw new DBException("Authentication model not specified");
        }
        return authModel;
    }

    @NotNull
    private DBAAuthProfile getAuthProfile(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration) throws DBException {
        String profileName = this.getProfileName(configuration);
        return this.getDBAAuthProfile(profileName, dataSource.getProject());
    }

    @NotNull
    private DBAAuthProfile getAuthProfileFromCurrentProject(@NotNull DBPConnectionConfiguration configuration) throws DBException {
        String profileName = this.getProfileName(configuration);
        DBPProject activeProject = DBWorkbench.getPlatform().getWorkspace().getActiveProject();
        if (activeProject == null) {
            throw new DBException("Can't find active project.");
        }
        return this.getDBAAuthProfile(profileName, activeProject);
    }

    @NotNull
    private DBAAuthProfile getDBAAuthProfile(String profileName, DBPProject activeProject) throws DBException {
        DBAAuthProfile authProfile = activeProject.getDataSourceRegistry().getAuthProfile(profileName);
        if (authProfile == null) {
            throw new DBException("Profile '" + profileName + "' no found");
        }
        return authProfile;
    }

    @NotNull
    private String getProfileName(@NotNull DBPConnectionConfiguration configuration) throws DBException {
        String profileName = configuration.getAuthProperty("profile-id");
        if (CommonUtils.isEmpty((String)profileName)) {
            throw new DBException("Profile ID not specified");
        }
        return profileName;
    }

    @NotNull
    public String getConnectionURL(@NotNull DBPDriver driver, @NotNull DBPConnectionConfiguration connectionInfo) {
        try {
            DBAAuthProfile authProfile = this.getAuthProfileFromCurrentProject(connectionInfo);
            DBAAuthModel instance = authProfile.getAuthModel().getInstance();
            if (instance instanceof DBPDataSourceURLProvider) {
                return ((DBPDataSourceURLProvider)instance).getConnectionURL(driver, connectionInfo);
            }
        }
        catch (DBException e) {
            log.debug((Object)"Can't find authentication profile", (Throwable)e);
        }
        return null;
    }
}

