/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringJoiner;
import org.eclipse.core.internal.runtime.Activator;
import org.eclipse.core.internal.runtime.CommonMessages;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.ServiceCaller;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.JobGroup;
import org.eclipse.osgi.service.localization.BundleLocalization;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.meta.ComponentReference;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableParametrizedWithProgress;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.runtime.DefaultProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.BeanUtils;
import org.jkiss.utils.CommonUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

public final class RuntimeUtils {
    private static final Log log = Log.getLog(RuntimeUtils.class);
    private static final boolean IS_OS_ARCH_AARCH64;
    private static final boolean IS_OS_ARCH_AMD64;
    private static final boolean IS_LINUX;
    private static final boolean IS_MACOS;
    private static final boolean IS_WINDOWS;
    private static final byte[] NULL_MAC_ADDRESS;

    static {
        NULL_MAC_ADDRESS = new byte[6];
        String arch = Platform.getOSArch();
        IS_OS_ARCH_AARCH64 = "aarch64".equals(arch);
        IS_OS_ARCH_AMD64 = "x86_64".equals(arch);
        String os = Platform.getOS();
        IS_LINUX = "linux".equals(os);
        IS_MACOS = "macosx".equals(os);
        IS_WINDOWS = "win32".equals(os);
    }

    private RuntimeUtils() {
    }

    @Nullable
    public static <T> T getObjectAdapter(@NotNull Object adapter, @NotNull Class<T> objectType) {
        return (T)Platform.getAdapterManager().getAdapter(adapter, objectType);
    }

    @Nullable
    public static <T> T getObjectAdapter(@NotNull Object adapter, @NotNull Class<T> objectType, boolean force) {
        IAdapterManager adapterManager = Platform.getAdapterManager();
        if (force) {
            adapterManager.loadAdapter(adapter, objectType.getName());
        }
        return (T)adapterManager.getAdapter(adapter, objectType);
    }

    @NotNull
    public static DBRProgressMonitor makeMonitor(@NotNull IProgressMonitor monitor) {
        if (monitor instanceof DBRProgressMonitor) {
            DBRProgressMonitor monitor1 = (DBRProgressMonitor)monitor;
            return monitor1;
        }
        return new DefaultProgressMonitor(monitor);
    }

    @NotNull
    public static IProgressMonitor getNestedMonitor(@NotNull DBRProgressMonitor monitor) {
        if (monitor instanceof IProgressMonitor) {
            IProgressMonitor monitor1 = (IProgressMonitor)monitor;
            return monitor1;
        }
        return monitor.getNestedMonitor();
    }

    @NotNull
    public static File getUserHomeDir() {
        String userHome = System.getProperty("user.home");
        if (userHome == null) {
            userHome = ".";
        }
        return new File(userHome);
    }

    @NotNull
    public static String getCurrentDate() {
        return new SimpleDateFormat("yyyyMMdd", Locale.ENGLISH).format(new Date());
    }

    @NotNull
    public static String getCurrentTime() {
        return new SimpleDateFormat("HHmmss", Locale.ENGLISH).format(new Date());
    }

    @NotNull
    public static String getCurrentTimeStamp() {
        return new SimpleDateFormat("yyyyMMddHHmm", Locale.ENGLISH).format(new Date());
    }

    public static boolean isTypeSupported(Class<?> type, Class<?>[] supportedTypes) {
        if (type == null || ArrayUtils.isEmpty((Object[])supportedTypes)) {
            return false;
        }
        Class<?>[] classArray = supportedTypes;
        int n = supportedTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> tmp = classArray[n2];
            if (tmp.isAssignableFrom(type)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @NotNull
    public static String getNativeBinaryName(String binName) {
        return RuntimeUtils.isWindows() ? binName + ".exe" : binName;
    }

    @NotNull
    public static File getNativeClientBinary(@NotNull DBPNativeClientLocation home, @Nullable String binFolder, @NotNull String binName) throws IOException {
        binName = RuntimeUtils.getNativeBinaryName(binName);
        File dumpBinary = new File(home.getPath(), (String)(binFolder == null ? binName : binFolder + "/" + binName));
        if (!dumpBinary.exists() && !(dumpBinary = new File(home.getPath(), binName)).exists()) {
            throw new IOException("Utility '" + binName + "' not found in client home '" + home.getDisplayName() + "' (" + home.getPath().getAbsolutePath() + ")");
        }
        return dumpBinary;
    }

    @NotNull
    public static IStatus stripStack(@NotNull IStatus status) {
        if (status instanceof MultiStatus) {
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                children[i] = RuntimeUtils.stripStack(children[i]);
                ++i;
            }
            return new MultiStatus(status.getPlugin(), status.getCode(), children, status.getMessage(), null);
        }
        if (status instanceof Status) {
            if (status.getException() != null && CommonUtils.isEmpty((String)status.getException().getMessage())) {
                String messagePrefix = status.getException().getClass().getName() + ": ";
                return new Status(status.getSeverity(), status.getPlugin(), status.getCode(), messagePrefix + status.getMessage(), null);
            }
            return status;
        }
        return status;
    }

    public static void pause(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            log.debug("Sleep interrupted", e);
        }
    }

    @NotNull
    public static String formatExecutionTime(long ms) {
        return RuntimeUtils.formatExecutionTime(Duration.ofMillis(ms));
    }

    @NotNull
    public static String formatExecutionTime(@NotNull Duration duration) {
        long hours = duration.toHours();
        int minutes = duration.toMinutesPart();
        int seconds = duration.toSecondsPart();
        int millis = duration.toMillisPart();
        if (hours > 0L) {
            return String.format("%dh %dm %ds", hours, minutes, seconds);
        }
        if (minutes > 0) {
            return String.format("%dm %ds", minutes, seconds);
        }
        if (seconds >= 10) {
            return String.format("%ds", seconds);
        }
        return Lazy.EXECUTION_SECONDS_FORMAT.format((double)seconds + (double)millis * 0.001);
    }

    @NotNull
    public static String formatDuration(@NotNull Duration duration) {
        int seconds;
        int minutes;
        StringJoiner joiner = new StringJoiner(", ");
        long hours = duration.toHours();
        if (hours > 0L) {
            joiner.add(Lazy.DURATION_HOURS_FORMAT.format(new Object[]{hours}));
        }
        if ((minutes = duration.toMinutesPart()) > 0) {
            joiner.add(Lazy.DURATION_MINUTES_FORMAT.format(new Object[]{minutes}));
        }
        if ((seconds = duration.toSecondsPart()) > 0) {
            joiner.add(Lazy.DURATION_SECONDS_FORMAT.format(new Object[]{seconds}));
        }
        if (joiner.length() == 0) {
            joiner.add(Lazy.DURATION_MILLISECONDS_FORMAT.format(new Object[]{duration.toMillis()}));
        }
        return joiner.toString();
    }

    @NotNull
    public static File getPlatformFile(@NotNull String platformURL) throws IOException {
        URL url = new URL(platformURL);
        URL fileURL = FileLocator.toFileURL((URL)url);
        return RuntimeUtils.getLocalFileFromURL(fileURL);
    }

    @NotNull
    public static File getLocalFileFromURL(@NotNull URL fileURL) throws IOException {
        try {
            URI filePath = GeneralUtils.makeURIFromFilePath(fileURL.toString());
            if (filePath.getAuthority() != null) {
                return new File(filePath.getSchemeSpecificPart());
            }
            return new File(filePath);
        }
        catch (URISyntaxException e) {
            throw new IOException("Bad local file path: " + String.valueOf(fileURL), e);
        }
    }

    @NotNull
    public static Path getLocalPathFromURL(@NotNull URL fileURL) throws IOException {
        try {
            URI filePath = GeneralUtils.makeURIFromFilePath(fileURL.toString());
            if (filePath.getAuthority() != null) {
                return Path.of(filePath.getSchemeSpecificPart(), new String[0]);
            }
            return Path.of(filePath);
        }
        catch (URISyntaxException e) {
            throw new IOException("Bad local file path: " + String.valueOf(fileURL), e);
        }
    }

    public static boolean runTask(@NotNull DBRRunnableWithProgress task, @NotNull String taskName, long waitTime) {
        return RuntimeUtils.runTask(task, taskName, waitTime, false);
    }

    public static boolean runTask(@NotNull DBRRunnableWithProgress task, @NotNull String taskName, long waitTime, boolean hidden) {
        final MonitoringTask monitoringTask = new MonitoringTask(task);
        AbstractJob monitorJob = new AbstractJob(taskName, hidden){
            {
                super($anonymous0);
                this.setSystem(bl);
                this.setUser(!bl);
            }

            @Override
            protected IStatus run(DBRProgressMonitor monitor) {
                monitor.beginTask(this.getName(), 1);
                try {
                    try {
                        monitor.subTask("Execute task");
                        monitoringTask.run(monitor);
                    }
                    catch (InvocationTargetException e) {
                        log.error(this.getName() + " - error", e.getTargetException());
                        IStatus iStatus = Status.OK_STATUS;
                        monitor.done();
                        return iStatus;
                    }
                    catch (InterruptedException interruptedException) {
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        monitorJob.schedule();
        RuntimeUtils.pause(10);
        boolean headlessMode = DBWorkbench.getPlatform().getApplication().isHeadlessMode();
        long startTime = System.currentTimeMillis();
        while (!monitoringTask.finished) {
            if (waitTime > 0L && System.currentTimeMillis() - startTime > waitTime) break;
            if (!headlessMode && DBWorkbench.getPlatformUI().readAndDispatchEvents()) continue;
            RuntimeUtils.pause(50);
        }
        return monitoringTask.finished;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static String executeProcess(@NotNull String binPath, String ... args) throws DBException {
        try {
            Object[] cmdBin = new String[]{binPath};
            Object[] cmd = args == null ? cmdBin : (String[])ArrayUtils.concatArrays((Object[])cmdBin, (Object[])args);
            Process p = Runtime.getRuntime().exec((String[])cmd);
            try {
                StringBuilder out = new StringBuilder();
                RuntimeUtils.readStringToBuffer(p.getInputStream(), out);
                if (out.isEmpty()) {
                    StringBuilder err = new StringBuilder();
                    RuntimeUtils.readStringToBuffer(p.getErrorStream(), err);
                    String string = err.toString();
                    return string;
                }
                String string = out.toString();
                return string;
            }
            finally {
                p.destroy();
            }
        }
        catch (Exception ex) {
            throw new DBException("Error executing process " + binPath, ex);
        }
    }

    @NotNull
    public static String executeProcessAndCheckResult(@NotNull String binPath, String ... args) throws DBException {
        try {
            Object[] cmdBin = new String[]{binPath};
            Object[] cmd = args == null ? cmdBin : (String[])ArrayUtils.concatArrays((Object[])cmdBin, (Object[])args);
            Process p = Runtime.getRuntime().exec((String[])cmd);
            return RuntimeUtils.getProcessResults(p);
        }
        catch (Exception ex) {
            if (ex instanceof DBException) {
                DBException dbe = (DBException)ex;
                throw dbe;
            }
            throw new DBException("Error executing process " + binPath, ex);
        }
    }

    @NotNull
    public static String getProcessResults(@NotNull Process p) throws IOException, InterruptedException, DBException {
        try {
            StringBuilder out = new StringBuilder();
            RuntimeUtils.readStringToBuffer(p.getInputStream(), out);
            StringBuilder err = new StringBuilder();
            RuntimeUtils.readStringToBuffer(p.getErrorStream(), err);
            p.waitFor();
            if (p.exitValue() != 0) {
                throw new DBException(err.toString());
            }
            String string = out.toString();
            return string;
        }
        finally {
            p.destroy();
        }
    }

    private static void readStringToBuffer(@NotNull InputStream is, @NotNull StringBuilder out) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader input = new BufferedReader(new InputStreamReader(is));){
            String line;
            while ((line = input.readLine()) != null) {
                if (!out.isEmpty()) {
                    out.append("\n");
                }
                out.append(line);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static boolean isWindows() {
        return IS_WINDOWS;
    }

    public static boolean isWindowsStoreApplication() {
        if (!IS_WINDOWS) {
            return false;
        }
        String property = System.getProperty("dbeaver.windows.store.app");
        return property != null && property.equalsIgnoreCase("true");
    }

    public static boolean isMacOS() {
        return IS_MACOS;
    }

    public static boolean isLinux() {
        return IS_LINUX;
    }

    public static boolean isWayland() {
        return RuntimeUtils.isLinux() && CommonUtils.isNotEmpty((String)System.getenv("WAYLAND_DISPLAY"));
    }

    public static boolean isOSArchAArch64() {
        return IS_OS_ARCH_AARCH64;
    }

    public static boolean isOSArchAMD64() {
        return IS_OS_ARCH_AMD64;
    }

    @NotNull
    public static Version getOSVersion() {
        String version = System.getProperty("os.version");
        if (version != null) {
            try {
                return new Version(version);
            }
            catch (IllegalArgumentException e) {
                log.debug("Error parsing OS version: " + version, e);
            }
        }
        return Version.emptyVersion;
    }

    public static boolean isOSVersionAtLeast(int major, int minor, int micro) {
        Version expected = new Version(major, minor, micro);
        Version actual = RuntimeUtils.getOSVersion();
        return actual.compareTo(expected) >= 0;
    }

    public static void setThreadName(@NotNull String name) {
        Thread.currentThread().setName("DBeaver: " + name);
    }

    @NotNull
    public static byte[] getLocalMacAddress() throws IOException {
        Enumeration<NetworkInterface> niEnum;
        InetAddress localHost = RuntimeUtils.getLocalHostOrLoopback();
        NetworkInterface ni = NetworkInterface.getByInetAddress(localHost);
        if (ni == null && (niEnum = NetworkInterface.getNetworkInterfaces()).hasMoreElements()) {
            ni = niEnum.nextElement();
        }
        return ni == null || ni.getHardwareAddress() == null ? NULL_MAC_ADDRESS : ni.getHardwareAddress();
    }

    @NotNull
    public static InetAddress getLocalHostOrLoopback() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            log.debug("Error resolving localhost address: " + e.getMessage());
            return InetAddress.getLoopbackAddress();
        }
    }

    @NotNull
    public static List<String> splitCommandLine(@NotNull String input, boolean escapesSupported) {
        ArrayList<String> arguments = new ArrayList<String>();
        StringBuilder argument = new StringBuilder();
        CommandLineState state = CommandLineState.NONE;
        boolean escaped = false;
        int index = 0;
        while (index < input.length()) {
            char quote;
            char ch = input.charAt(index);
            char c = quote = state == CommandLineState.SINGLE_QUOTE ? (char)'\'' : '\"';
            if (escaped) {
                argument.append(ch);
                escaped = false;
            } else {
                switch (state) {
                    case NONE: 
                    case NORMAL: {
                        if (ch == '\'') {
                            state = CommandLineState.SINGLE_QUOTE;
                            break;
                        }
                        if (ch == '\"') {
                            state = CommandLineState.DOUBLE_QUOTE;
                            break;
                        }
                        if (ch == '\\' && escapesSupported) {
                            escaped = true;
                            state = CommandLineState.NORMAL;
                            break;
                        }
                        if (!Character.isWhitespace(ch)) {
                            argument.append(ch);
                            state = CommandLineState.NORMAL;
                            break;
                        }
                        if (state != CommandLineState.NORMAL) break;
                        arguments.add(argument.toString());
                        argument.setLength(0);
                        state = CommandLineState.NONE;
                        break;
                    }
                    case SINGLE_QUOTE: 
                    case DOUBLE_QUOTE: {
                        if (ch == '\\' && escapesSupported) {
                            char next;
                            if ((next = input.charAt(++index)) != quote && next != '\\') {
                                argument.append(ch);
                            }
                            argument.append(next);
                            break;
                        }
                        if (ch == quote) {
                            state = CommandLineState.NORMAL;
                            break;
                        }
                        argument.append(ch);
                        break;
                    }
                }
            }
            ++index;
        }
        if (escaped) {
            argument.append('\\');
            arguments.add(argument.toString());
        } else if (state != CommandLineState.NONE) {
            arguments.add(argument.toString());
        }
        return arguments;
    }

    @NotNull
    public static String getWorkingDirectory(@NotNull String subPath) {
        String workingDirectory;
        if (RuntimeUtils.isWindows()) {
            String appData = System.getenv("AppData");
            if (appData == null) {
                appData = System.getProperty("user.home");
            }
            workingDirectory = appData + "\\" + subPath;
        } else if (RuntimeUtils.isMacOS()) {
            workingDirectory = System.getProperty("user.home") + "/Library/" + subPath;
        } else {
            Object dataHome = System.getProperty("XDG_DATA_HOME");
            if (dataHome == null) {
                dataHome = System.getProperty("user.home") + "/.local/share";
            }
            String badWorkingDir = (String)dataHome + "/." + subPath;
            String goodWorkingDir = (String)dataHome + "/" + subPath;
            workingDirectory = !new File(goodWorkingDir).exists() && new File(badWorkingDir).exists() ? badWorkingDir : goodWorkingDir;
        }
        return workingDirectory;
    }

    @NotNull
    public static ResourceBundle getBundleLocalization(@NotNull Bundle bundle, @NotNull String locale) throws MissingResourceException {
        ServiceCaller localizationTracker;
        Activator activator = Activator.getDefault();
        if (activator == null) {
            throw new MissingResourceException(CommonMessages.activator_resourceBundleNotStarted, bundle.getSymbolicName(), "");
        }
        try {
            localizationTracker = (ServiceCaller)BeanUtils.getFieldValue((Object)activator, (String)"localizationTracker");
        }
        catch (Throwable e) {
            throw new MissingResourceException("Resource bundle '" + bundle.getSymbolicName() + "' not found for locale " + locale, bundle.getSymbolicName(), e.getMessage());
        }
        BundleLocalization location = localizationTracker.current().orElse(null);
        ResourceBundle result = null;
        if (location != null) {
            result = location.getLocalization(bundle, locale);
        }
        if (result == null) {
            throw new MissingResourceException("Resource bundle '" + bundle.getSymbolicName() + "' not found for locale " + locale, bundle.getSymbolicName(), "");
        }
        return result;
    }

    public static <T> void executeJobsForEach(@NotNull Collection<? extends T> objects, final @NotNull DBRRunnableParametrizedWithProgress<? super T> task) {
        JobGroup jobGroup = new JobGroup("executeJobsForEach:" + String.valueOf(objects), 10, 1);
        for (final T object : objects) {
            AbstractJob job = new AbstractJob("Execute for " + String.valueOf(object)){
                {
                    super($anonymous0);
                    this.setSystem(true);
                    this.setUser(false);
                }

                @Override
                protected IStatus run(DBRProgressMonitor monitor) {
                    if (!monitor.isCanceled()) {
                        try {
                            task.run(monitor, object);
                        }
                        catch (InvocationTargetException e) {
                            log.debug(e.getTargetException());
                        }
                        catch (InterruptedException interruptedException) {
                            return Status.CANCEL_STATUS;
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setJobGroup(jobGroup);
            job.schedule();
        }
        try {
            while (!jobGroup.join(50L, (IProgressMonitor)new NullProgressMonitor())) {
                DBWorkbench.getPlatformUI().readAndDispatchEvents();
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    @Nullable
    public static String getSystemPropertyIgnoreCase(@NotNull String key) {
        Properties props = System.getProperties();
        for (String name : props.stringPropertyNames()) {
            if (!name.equalsIgnoreCase(key)) continue;
            return props.getProperty(key);
        }
        return null;
    }

    @Nullable
    public static String getSystemEnvIgnoreCase(@NotNull String key) {
        Map<String, String> env = System.getenv();
        for (Map.Entry<String, String> entry : env.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(key)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Nullable
    public static <T> T getBundleService(@NotNull Class<T> theClass, boolean required) throws IllegalStateException {
        Bundle bundle = FrameworkUtil.getBundle(theClass);
        BundleContext bundleContext = bundle.getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(theClass);
        if (serviceReference == null) {
            if (required) {
                throw new IllegalStateException("Service '" + theClass.getName() + "' is not registered");
            }
            return null;
        }
        Object service = bundleContext.getService(serviceReference);
        if (service == null) {
            if (required) {
                throw new IllegalStateException("Service '" + theClass.getName() + "' implementation not found");
            }
        } else {
            RuntimeUtils.injectComponentReferences(service);
        }
        return (T)service;
    }

    public static void injectComponentReferences(@NotNull Object object) {
        Class<?> aClass = object.getClass();
        Field[] fieldArray = aClass.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentReference refAnno;
            Field field = fieldArray[n2];
            if (!Modifier.isStatic(field.getModifiers()) && (refAnno = field.getAnnotation(ComponentReference.class)) != null) {
                Class<?> serviceClass = refAnno.service();
                if (serviceClass == Object.class) {
                    serviceClass = field.getType();
                }
                try {
                    Object fieldValue = field.get(object);
                    if (fieldValue == null) {
                        Object bundleService = RuntimeUtils.getBundleService(serviceClass, refAnno.required());
                        field.setAccessible(true);
                        field.set(object, bundleService);
                        if (bundleService != null && !CommonUtils.isEmpty((String)refAnno.postProcessMethod())) {
                            Method postProcessMethod = bundleService.getClass().getDeclaredMethod(refAnno.postProcessMethod(), new Class[0]);
                            postProcessMethod.setAccessible(true);
                            postProcessMethod.invoke(bundleService, new Object[0]);
                        }
                    }
                }
                catch (Exception e) {
                    log.debug("Error injecting field '" + field.getName() + "' in '" + String.valueOf(object) + "'", e);
                }
            }
            ++n2;
        }
    }

    public static Path getPluginStateLocation(Plugin plugin) {
        return InternalPlatform.getDefault().getStateLocation(plugin.getBundle(), false).toPath();
    }

    private static enum CommandLineState {
        NONE,
        NORMAL,
        SINGLE_QUOTE,
        DOUBLE_QUOTE;

    }

    private static class Lazy {
        static final Format DURATION_HOURS_FORMAT = new MessageFormat(ModelMessages.duration_hours);
        static final Format DURATION_MINUTES_FORMAT = new MessageFormat(ModelMessages.duration_minutes);
        static final Format DURATION_SECONDS_FORMAT = new MessageFormat(ModelMessages.duration_seconds);
        static final Format DURATION_MILLISECONDS_FORMAT = new MessageFormat(ModelMessages.duration_milliseconds);
        static final Format EXECUTION_SECONDS_FORMAT = new DecimalFormat("#.###s");

        private Lazy() {
        }
    }

    private static class MonitoringTask
    implements DBRRunnableWithProgress {
        private final DBRRunnableWithProgress task;
        volatile boolean finished;

        private MonitoringTask(DBRRunnableWithProgress task) {
            this.task = task;
        }

        @Override
        public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                this.task.run(monitor);
            }
            finally {
                this.finished = true;
            }
        }
    }
}

