/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.security.truststore;

import com.dbeaver.model.datasource.parameters.DBPParametersConfiguration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;

public class ExtendedCertificatesRegistry {
    private static final Log log = Log.getLog(ExtendedCertificatesRegistry.class);
    private static final String EXTENSION_ID = "com.dbeaver.extendedCertificates";
    private static final String CERTIFICATE_TAG = "certificate";
    private static ExtendedCertificatesRegistry instance = null;
    private final List<CertificateDescriptor> descriptors = new ArrayList<CertificateDescriptor>();
    private Map<String, DBPParametersConfiguration> providerConfigurations;

    public static synchronized ExtendedCertificatesRegistry getInstance() {
        if (instance == null) {
            instance = new ExtendedCertificatesRegistry();
            instance.loadExtensions(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private void loadExtensions(@NotNull IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor(EXTENSION_ID);
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if (CERTIFICATE_TAG.equals(ext.getName())) {
                this.descriptors.add(new CertificateDescriptor(ext));
            }
            ++n2;
        }
    }

    @NotNull
    public List<CertificateDescriptor> getCertificates() {
        return this.descriptors;
    }

    public record CertificateDescriptor(IContributor contributor, String localFolder, String url) {
        CertificateDescriptor(IConfigurationElement ext) {
            this(ext.getContributor(), ext.getAttribute("localFolder"), ext.getAttribute("url"));
        }
    }
}

