/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.net.proxy;

import com.github.markusbernhardt.proxy.ProxySearch;
import java.io.IOException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.runtime.net.GlobalProxySelector;
import org.jkiss.utils.CommonUtils;

public class DynamicProxySelector
extends GlobalProxySelector {
    private static final Log log = Log.getLog(DynamicProxySelector.class);
    private static final ProxySearch DEFAULT_PROXY_SEARCH = new ProxySearch();
    private volatile boolean isSearching = false;

    static {
        DEFAULT_PROXY_SEARCH.addStrategy(ProxySearch.Strategy.OS_DEFAULT);
        DEFAULT_PROXY_SEARCH.addStrategy(ProxySearch.Strategy.BROWSER);
        DEFAULT_PROXY_SEARCH.addStrategy(ProxySearch.Strategy.ENV_VAR);
        DEFAULT_PROXY_SEARCH.addStrategy(ProxySearch.Strategy.JAVA);
    }

    public DynamicProxySelector(ProxySelector parent) {
        super(parent);
    }

    public List<Proxy> select(URI uri) {
        List<Proxy> proxies;
        block18: {
            if (!this.canHandleURI(uri)) {
                return super.select(uri);
            }
            if (!this.isSearching) {
                this.isSearching = true;
                try {
                    DBPDataSourceContainer activeContext = this.getActiveDataSourceContainer(uri);
                    if (activeContext != null) {
                        List<Proxy> proxies2 = this.selectDataSourceProxy(uri, activeContext);
                        if (!proxies2.isEmpty()) {
                            log.debug((Object)("Proxy configuration detected: " + String.valueOf(proxies2)));
                        }
                        List<Proxy> list = proxies2;
                        return list;
                    }
                }
                catch (Throwable e) {
                    log.debug((Object)"Error selecting dynamic proxy", e);
                }
                finally {
                    this.isSearching = false;
                }
            }
            if (CommonUtils.isEmpty(proxies = this.getParent().select(uri)) || proxies.size() == 1 && proxies.get(0) == Proxy.NO_PROXY && !this.isSearching) {
                try {
                    try {
                        this.isSearching = true;
                        ProxySearch defProxySearcher = this.getDefaultProxySearcher();
                        ProxySelector polySelector = defProxySearcher.getProxySelector();
                        if (polySelector != null) {
                            proxies = polySelector.select(uri);
                        }
                    }
                    catch (Throwable e) {
                        log.debug((Object)"Default PAC error", e);
                        this.isSearching = false;
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    this.isSearching = false;
                    throw throwable;
                }
                this.isSearching = false;
            }
        }
        if (!(proxies.isEmpty() || proxies.size() == 1 && proxies.getFirst().type() == Proxy.Type.DIRECT)) {
            log.debug((Object)("Use default proxy configuration: " + String.valueOf(proxies)));
        }
        return proxies;
    }

    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        super.connectFailed(uri, sa, ioe);
        log.debug((Object)("Proxy connection failed for " + String.valueOf(uri)), (Throwable)ioe);
    }

    private List<Proxy> selectDataSourceProxy(URI uri, DBPDataSourceContainer activeContext) {
        DBWHandlerConfiguration proxyConfig = activeContext.getActualConnectionConfiguration().getHandler("dynamic_proxy");
        if (proxyConfig != null && proxyConfig.isEnabled()) {
            ProxySearch proxySearch;
            ProxySelector polySelector;
            if (proxyConfig.getBooleanProperty("pac_enabled") && (polySelector = (proxySearch = this.getProxySearcher(uri, proxyConfig)).getProxySelector()) != null) {
                return polySelector.select(uri);
            }
            List proxies = super.getProxiesForDataSource(uri, activeContext);
            if (proxies != null) {
                return proxies;
            }
        }
        return this.getParent().select(uri);
    }

    private boolean canHandleURI(URI uri) {
        String host = uri.getHost();
        return !"localhost".equals(host) && !"127.0.0.1".equals(host);
    }

    @NotNull
    private ProxySearch getProxySearcher(URI uri, DBWHandlerConfiguration proxyConfig) {
        ProxySearch proxySearch = new ProxySearch();
        if (proxyConfig.getBooleanProperty("pac_strategy_os")) {
            proxySearch.addStrategy(ProxySearch.Strategy.OS_DEFAULT);
        }
        if (proxyConfig.getBooleanProperty("pac_strategy_browser")) {
            proxySearch.addStrategy(ProxySearch.Strategy.BROWSER);
        }
        if (proxyConfig.getBooleanProperty("pac_strategy_env")) {
            proxySearch.addStrategy(ProxySearch.Strategy.ENV_VAR);
        }
        proxySearch.addStrategy(ProxySearch.Strategy.JAVA);
        return proxySearch;
    }

    @NotNull
    private ProxySearch getDefaultProxySearcher() {
        return DEFAULT_PROXY_SEARCH;
    }
}

