/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.document.handlers;

import com.dbeaver.model.document.data.DBMapValue;
import com.dbeaver.model.document.handlers.DocumentBaseValueHandler;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValueHandlerComposite;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class DocumentMapValueHandler
extends DocumentBaseValueHandler
implements DBDValueHandlerComposite {
    public static final DocumentMapValueHandler INSTANCE = new DocumentMapValueHandler();

    @NotNull
    public Class<Map> getValueObjectType(@NotNull DBSTypedObject attribute) {
        return Map.class;
    }

    @NotNull
    public String getValueDisplayString(@NotNull DBSTypedObject column, Object value, @NotNull DBDDisplayFormat format) {
        if (DBUtils.isNullValue((Object)value)) {
            return DBValueFormatting.getDefaultValueDisplayString(null, (DBDDisplayFormat)format);
        }
        if (value instanceof DBMapValue) {
            DBMapValue mapValue = (DBMapValue)((Object)value);
            return mapValue.toJson();
        }
        return String.valueOf(value);
    }

    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy, boolean validateValue) throws DBCException {
        if (object == null) {
            return new DBMapValue<DBPDataSource>(session.getDataSource(), null, null);
        }
        if (object instanceof DBMapValue) {
            return object;
        }
        if (object instanceof Map) {
            return new DBMapValue<DBPDataSource>(session.getDataSource(), null, (Map)object);
        }
        throw new DBCException("Unsupported struct type: " + object.getClass().getName());
    }

    @Override
    public final Object fetchValueObject(@NotNull DBCSession session, @NotNull DBCResultSet resultSet, @NotNull DBSTypedObject type, int index) throws DBCException {
        Object columnValue = super.fetchValueObject(session, resultSet, type, index);
        return this.getValueFromObject(session, type, columnValue, false, false);
    }

    public Object createNewValueObject(@NotNull DBCSession session, @NotNull DBSTypedObject type) {
        return new DBMapValue<DBPDataSource>(session.getDataSource(), null, new LinkedHashMap<String, Object>());
    }
}

