/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.datasource.parameters;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.utils.CommonUtils;

public class DBPParametersMappingRule {
    private final Map<String, String> rules = new LinkedHashMap<String, String>();

    public DBPParametersMappingRule() {
    }

    public DBPParametersMappingRule(@NotNull DBPParametersMappingRule mainRule, @NotNull DBPParametersMappingRule childRule) {
        this.rules.putAll(childRule.getRules());
        this.rules.putAll(mainRule.getRules());
    }

    @Property
    @NotNull
    public Map<String, String> getRules() {
        return Map.copyOf(this.rules);
    }

    public void addRule(@NotNull String externalParameterName, @NotNull String dbeaverParameterName) {
        this.rules.put(externalParameterName, dbeaverParameterName);
    }

    public void removeRule(@NotNull String externalParameterName) {
        this.rules.remove(externalParameterName);
    }

    @NotNull
    public String getExpectedKeyName(@NotNull String externalKeyName) {
        return this.rules.getOrDefault(externalKeyName, externalKeyName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DBPParametersMappingRule that = (DBPParametersMappingRule)o;
        return CommonUtils.equalObjects(this.rules, that.rules);
    }

    public int hashCode() {
        return this.rules.hashCode();
    }
}

