/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.ai.preferences;

import com.dbeaver.ui.ai.chat.AIChatUtils;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.ai.AICompletionSettings;
import org.jkiss.dbeaver.model.ai.AIContextSettings;
import org.jkiss.dbeaver.model.ai.AIDatabaseScope;
import org.jkiss.dbeaver.model.ai.utils.AIUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.preferences.TargetPrefPage;
import org.jkiss.utils.CommonUtils;

public class PrefPageDataSourceAI
extends TargetPrefPage
implements IWorkbenchPreferencePage {
    public static final String PAGE_ID = "com.dbeaver.preferences.datasource.ai";
    private Button enableAiCheck;
    private Combo metadataScopeCombo;
    private AIContextSettings settings;

    public void init(IWorkbench workbench) {
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1);
        DBPDataSourceContainer dataSourceContainer = this.getOriginalDataSourceContainer();
        if (dataSourceContainer != null) {
            Group settingsGroup = UIUtils.createControlGroup((Composite)composite, (String)"AI settings for the connection", (int)2, (int)32, (int)-1);
            this.enableAiCheck = UIUtils.createCheckbox((Composite)settingsGroup, (String)"Enable AI for this connection", (String)"Enable sending of database metadata to AI engine(s) for this connection", (boolean)false, (int)2);
            this.metadataScopeCombo = UIUtils.createLabelCombo((Composite)settingsGroup, (String)"Metadata scope", (String)"Set of metadata to send to AI by default", (int)12);
            AIDatabaseScope[] aIDatabaseScopeArray = AIDatabaseScope.values();
            int n = aIDatabaseScopeArray.length;
            int n2 = 0;
            while (n2 < n) {
                AIDatabaseScope scope = aIDatabaseScopeArray[n2];
                this.metadataScopeCombo.add(scope.getTitle());
                ++n2;
            }
            Button scopeButton = UIUtils.createDialogButton((Composite)settingsGroup, (String)"Configure custom scope", (SelectionListener)SelectionListener.widgetSelectedAdapter(selectionEvent -> this.configureCustomScope()));
            GridData gd = new GridData(32);
            gd.horizontalSpan = 2;
            scopeButton.setLayoutData((Object)gd);
        }
        UIUtils.createPreferenceLink((Composite)composite, (String)"<a>General AI configuration</a>", (String)"org.jkiss.dbeaver.preferences.ai.config", null, null).setLayoutData((Object)new GridData(32));
        return composite;
    }

    private void configureCustomScope() {
        DBPDataSourceContainer dataSourceContainer = this.getOriginalDataSourceContainer();
        if (dataSourceContainer != null) {
            AIChatUtils.chooseCustomScope(this.getShell(), this.settings, dataSourceContainer, ds -> DBUtils.getDefaultContext((DBSObject)ds, (boolean)false), null);
        }
    }

    protected boolean supportsGlobalOptions() {
        return false;
    }

    protected boolean hasDataSourceSpecificOptions(DBPDataSourceContainer dsContainer) {
        return true;
    }

    protected boolean supportsDataSourceSpecificOptions() {
        return true;
    }

    protected void loadPreferences(DBPPreferenceStore store) {
        DBPDataSourceContainer dataSourceContainer = this.getOriginalDataSourceContainer();
        if (dataSourceContainer == null) {
            return;
        }
        this.settings = new AICompletionSettings(dataSourceContainer);
        this.enableAiCheck.setSelection(this.settings.isMetaTransferConfirmed());
        if (this.settings.getScope() == null) {
            AIUtils.updateScopeSettingsIfNeeded((AIContextSettings)this.settings, (DBPDataSourceContainer)dataSourceContainer, (DBCExecutionContext)DBUtils.getDefaultContext((DBSObject)dataSourceContainer, (boolean)true));
        }
        if (this.settings.getScope() != null) {
            this.metadataScopeCombo.select(this.settings.getScope().ordinal());
        }
        this.enableAiCheck.setSelection(this.settings.isMetaTransferConfirmed());
    }

    protected void savePreferences(DBPPreferenceStore store) {
        DBPDataSourceContainer dataSourceContainer = this.getOriginalDataSourceContainer();
        if (dataSourceContainer == null) {
            return;
        }
        this.settings.setMetaTransferConfirmed(this.enableAiCheck.getSelection());
        int scopeIndex = this.metadataScopeCombo.getSelectionIndex();
        if (scopeIndex >= 0) {
            this.settings.setScope((AIDatabaseScope)CommonUtils.fromOrdinal(AIDatabaseScope.class, (int)scopeIndex));
        }
        try {
            this.settings.saveSettings();
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("AI settings ave", "Error saving AI settings", (Throwable)e);
        }
    }

    protected void clearPreferences(DBPPreferenceStore store) {
    }

    protected String getPropertyPageID() {
        return PAGE_ID;
    }
}

