/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.ai.preferences;

import com.dbeaver.ui.ai.messages.AIUIAdvancedMessages;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.ai.AISettings;
import org.jkiss.dbeaver.model.ai.registry.AISettingsManager;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.ui.validator.DoubleValidator;
import org.jkiss.dbeaver.ui.validator.IntegerValidator;
import org.jkiss.utils.CommonUtils;

public class AIPreferencePageChat
extends AbstractPrefPage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    private static final Log log = Log.getLog(AIPreferencePageChat.class);
    public static final String PAGE_ID = "com.dbeaver.preferences.ai.chat";
    private final AISettings settings = AISettingsManager.getInstance().getSettings();
    private Button useStreamMode;
    private Text aiConversationTtlText;
    private Text aiSilenceThreshold;
    private Text aiSilenceTimeout;
    private Text aiAudioMaxDuration;
    private Button useWebChatRenderer;

    public IAdaptable getElement() {
        return this.settings;
    }

    public void setElement(IAdaptable element) {
    }

    protected void performDefaults() {
        if (!this.hasAccessToPage()) {
            return;
        }
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        this.useStreamMode.setSelection(store.getBoolean("ai.useStreamMode"));
        int conversationTtlDays = CommonUtils.toInt((Object)store.getString("qmdb.ai.conversation.ttl"), (int)7);
        this.aiConversationTtlText.setText(String.valueOf(conversationTtlDays));
        this.useWebChatRenderer.setSelection(store.getBoolean("ai.chat.webRenderer"));
        double silenceThreshold = CommonUtils.toDouble((Object)store.getString("ai.transcript.silence.threshold"), (double)0.3);
        this.aiSilenceThreshold.setText(String.valueOf(silenceThreshold));
        int silenceTimeout = CommonUtils.toInt((Object)store.getString("ai.transcript.silence.timeout"), (int)20);
        this.aiSilenceTimeout.setText(String.valueOf(silenceTimeout));
        int audioMaxDuration = CommonUtils.toInt((Object)store.getString("ai.transcript.audio.duration"), (int)60);
        this.aiAudioMaxDuration.setText(String.valueOf(audioMaxDuration));
    }

    public boolean performOk() {
        if (!this.hasAccessToPage()) {
            return false;
        }
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        store.setValue("ai.useStreamMode", this.useStreamMode.getSelection());
        store.setValue("qmdb.ai.conversation.ttl", this.aiConversationTtlText.getText());
        store.setValue("ai.transcript.silence.threshold", this.aiSilenceThreshold.getText());
        store.setValue("ai.transcript.silence.timeout", this.aiSilenceTimeout.getText());
        store.setValue("ai.transcript.audio.duration", this.aiAudioMaxDuration.getText());
        store.setValue("ai.chat.webRenderer", this.useWebChatRenderer.getSelection());
        return true;
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        composite.setLayoutData((Object)new GridData(1808));
        Group mainGroup = UIUtils.createControlGroup((Composite)composite, (String)"Main", (int)2, (int)0, (int)-1);
        this.useWebChatRenderer = UIUtils.createCheckbox((Composite)mainGroup, (String)AIUIAdvancedMessages.gpt_preference_page_web_view_label, (String)AIUIAdvancedMessages.gpt_preference_page_web_view_tip, (boolean)false, (int)1);
        this.useStreamMode = UIUtils.createCheckbox((Composite)mainGroup, (String)AIUIAdvancedMessages.gpt_preference_page_advanced_completion_use_stream_mode_label, (String)AIUIAdvancedMessages.gpt_preference_page_advanced_completion_use_stream_mode_tip, (boolean)true, (int)2);
        Group storage = UIUtils.createControlGroup((Composite)composite, (String)AIUIAdvancedMessages.gpt_preference_page_advanced_storage_group, (int)2, (int)32, (int)0);
        this.createStorageSettings((Composite)storage);
        Group transcript = UIUtils.createControlGroup((Composite)composite, (String)AIUIAdvancedMessages.ai_preference_page_advanced_transcription_group, (int)2, (int)32, (int)0);
        this.createTranscriptionSettings((Composite)transcript);
        this.performDefaults();
        return composite;
    }

    public void init(IWorkbench workbench) {
    }

    protected boolean hasAccessToPage() {
        return DBWorkbench.getPlatform().getWorkspace().hasRealmPermission("configuration-manager");
    }

    private void createStorageSettings(@NotNull Composite parent) {
        this.aiConversationTtlText = UIUtils.createLabelText((Composite)parent, (String)AIUIAdvancedMessages.gpt_preference_page_advanced_storage_conversation_ttl_label, (String)String.valueOf(7), (int)2048, (Object)GridDataFactory.fillDefaults().hint(50, -1).create());
        this.aiConversationTtlText.setToolTipText(AIUIAdvancedMessages.gpt_preference_page_advanced_storage_conversation_ttl_tip);
        this.aiConversationTtlText.addVerifyListener((VerifyListener)new IntegerValidator(1, Integer.MAX_VALUE));
    }

    private void createTranscriptionSettings(@NotNull Composite parent) {
        Composite group = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        group.setLayout((Layout)layout);
        this.aiSilenceThreshold = UIUtils.createLabelText((Composite)group, (String)AIUIAdvancedMessages.ai_preference_page_advanced_transcription_silence_threshold_label, (String)String.valueOf(0.3), (int)2048, (Object)GridDataFactory.fillDefaults().hint(40, -1).create());
        UIUtils.createLabel((Composite)group, (String)"%");
        this.aiSilenceThreshold.setToolTipText(AIUIAdvancedMessages.ai_preference_page_advanced_transcription_silence_threshold_tip);
        this.aiSilenceThreshold.addVerifyListener((VerifyListener)new DoubleValidator(0.0, 100.0, false));
        this.aiSilenceTimeout = UIUtils.createLabelText((Composite)group, (String)AIUIAdvancedMessages.ai_preference_page_advanced_transcription_silence_timeout_label, (String)String.valueOf(20), (int)2048, (Object)GridDataFactory.fillDefaults().hint(40, -1).create());
        UIUtils.createLabel((Composite)group, (String)"sec");
        this.aiSilenceTimeout.setToolTipText(AIUIAdvancedMessages.ai_preference_page_advanced_transcription_silence_timeout_tip);
        this.aiSilenceTimeout.addVerifyListener((VerifyListener)new IntegerValidator(1, Integer.MAX_VALUE));
        this.aiAudioMaxDuration = UIUtils.createLabelText((Composite)group, (String)AIUIAdvancedMessages.ai_preference_page_advanced_transcription_audio_duration_label, (String)String.valueOf(20), (int)2048, (Object)GridDataFactory.fillDefaults().hint(40, -1).create());
        UIUtils.createLabel((Composite)group, (String)"sec");
        this.aiAudioMaxDuration.setToolTipText(AIUIAdvancedMessages.ai_preference_page_advanced_transcription_audio_duration_tip);
        this.aiAudioMaxDuration.addVerifyListener((VerifyListener)new IntegerValidator(1, Integer.MAX_VALUE));
    }
}

