/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.ai.functions;

import java.util.Map;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.Workbench;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.ai.AIFunction;
import org.jkiss.dbeaver.model.ai.AIFunctionContext;
import org.jkiss.dbeaver.model.ai.AIFunctionResult;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;
import org.jkiss.utils.CommonUtils;

public class AIFunctionGetOpenViewsAndEditors
implements AIFunction {
    @NotNull
    public AIFunctionResult callFunction(@NotNull AIFunctionContext context, @NotNull Map<String, Object> parameters) throws DBException {
        IViewReference[] views;
        IEditorReference[] editors;
        IWorkbenchPage[] pageHolder = new IWorkbenchPage[1];
        UIUtils.syncExec(() -> {
            IWorkbenchWindow window = Workbench.getInstance().getActiveWorkbenchWindow();
            if (window != null) {
                iWorkbenchPageArray[0] = window.getActivePage();
            }
        });
        IWorkbenchPage activePage = pageHolder[0];
        StringBuilder res = new StringBuilder();
        res.append("Open Editors:\n");
        IEditorReference[] iEditorReferenceArray = editors = activePage.getEditorReferences();
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editor = iEditorReferenceArray[n2];
            res.append("  - ").append(editor.getTitle());
            res.append(" (").append(editor.getId()).append(")");
            try {
                IEditorInput iEditorInput = editor.getEditorInput();
                if (iEditorInput instanceof IFileEditorInput) {
                    IFileEditorInput fileEditorInput = (IFileEditorInput)iEditorInput;
                    res.append(" filePath - ").append(fileEditorInput.getFile().getFullPath());
                } else {
                    IDatabaseEditorInput editorInput;
                    IEditorInput iEditorInput2 = editor.getEditorInput();
                    if (iEditorInput2 instanceof IDatabaseEditorInput && CommonUtils.isNotEmpty((String)(editorInput = (IDatabaseEditorInput)iEditorInput2).getNodePath())) {
                        res.append(" nodePath - ").append(editorInput.getNodePath());
                    } else if (editor.getEditorInput() != null) {
                        res.append(" - ").append(editor.getEditorInput().getName());
                    }
                }
            }
            catch (PartInitException e) {
                throw new DBException("Error while get open editors", (Throwable)e);
            }
            res.append("\n");
            ++n2;
        }
        res.append("\nOpen Views:\n");
        IViewReference[] iViewReferenceArray = views = activePage.getViewReferences();
        int n3 = views.length;
        n = 0;
        while (n < n3) {
            IViewReference view = iViewReferenceArray[n];
            res.append("  - ").append(view.getTitle());
            res.append(" id (").append(view.getId()).append(")");
            if (CommonUtils.isNotEmpty((String)view.getSecondaryId())) {
                res.append(" secondary id (").append(view.getSecondaryId()).append(")");
            }
            res.append("\n");
            ++n;
        }
        return new AIFunctionResult(AIFunctionResult.FunctionType.INFORMATION, res.toString());
    }
}

