/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.ai.functions;

import java.util.Map;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.ai.AIFunction;
import org.jkiss.dbeaver.model.ai.AIFunctionContext;
import org.jkiss.dbeaver.model.ai.AIFunctionResult;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithReturn;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class AIFunctionCloseView
implements AIFunction {
    private static final Log log = Log.getLog(AIFunctionCloseView.class);
    public static final String PARAM_VIEW_ID = "viewId";
    public static final String PARAM_SECONDARY_ID = "secondaryId";

    @NotNull
    public AIFunctionResult callFunction(@NotNull AIFunctionContext context, @NotNull Map<String, Object> parameters) throws DBException {
        String viewId = JSONUtils.getString(parameters, (String)PARAM_VIEW_ID);
        String secondaryId = JSONUtils.getString(parameters, (String)PARAM_SECONDARY_ID);
        if (CommonUtils.isEmpty((String)viewId)) {
            throw new DBException("View ID parameter is missing");
        }
        IViewReference[] viewRef = new IViewReference[1];
        UIUtils.syncExec(() -> {
            IWorkbenchPage activePage = UIUtils.getActiveWorkbenchWindow().getActivePage();
            if (activePage != null) {
                iViewReferenceArray[0] = CommonUtils.isEmpty((String)secondaryId) ? activePage.findViewReference(viewId) : activePage.findViewReference(viewId, secondaryId);
            }
        });
        if (viewRef[0] == null) {
            throw new DBException("Can't find any view for ID '" + viewId + "'" + (String)(CommonUtils.isEmpty((String)secondaryId) ? "" : " with secondary ID '" + secondaryId + "'"));
        }
        String viewTitle = viewRef[0].getTitle();
        DBRRunnableWithReturn callback = monitor -> {
            UIUtils.asyncExec(() -> {
                IWorkbenchPage activePage = UIUtils.getActiveWorkbenchWindow().getActivePage();
                if (activePage != null) {
                    iViewReferenceArray[0] = CommonUtils.isEmpty((String)secondaryId) ? activePage.findViewReference(viewId) : activePage.findViewReference(viewId, secondaryId);
                    activePage.hideView(viewRef[0]);
                } else {
                    log.error((Object)"No active workbench page found");
                }
            });
            return null;
        };
        callback.runTask(context.getMonitor());
        return new AIFunctionResult(AIFunctionResult.FunctionType.ACTION, "Close view '" + viewTitle + "'", callback);
    }
}

