/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.ai.engine.azure;

import com.dbeaver.model.ai.engine.azure.AzureAIProperties;
import java.util.Locale;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.ai.registry.AIEngineDescriptor;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.ai.internal.AIUIMessages;
import org.jkiss.dbeaver.ui.ai.model.ContextWindowSizeField;
import org.jkiss.dbeaver.ui.ai.preferences.AIIObjectPropertyConfigurator;
import org.jkiss.utils.CommonUtils;

public class AzureAIConfigurator
implements AIIObjectPropertyConfigurator<AIEngineDescriptor, AzureAIProperties> {
    private String token = "";
    private String temperature = "0.0";
    private boolean logQuery = false;
    private String endpoint = "https://<RESOURCE>.openai.azure.com/";
    private String deployment = "";
    private String audioDeployment = "";
    private Text endpointText;
    private Text deploymentText;
    private Text audioDeploymentText;
    private ContextWindowSizeField contextWindowSizeField;
    @Nullable
    protected Text tokenText;
    private Text temperatureText;
    private Button logQueryCheck;

    public void createControl(@NotNull Composite parent, AIEngineDescriptor object, @NotNull Runnable propertyChangeListener) {
        Composite composite = UIUtils.createComposite((Composite)parent, (int)2);
        composite.setLayoutData((Object)new GridData(768));
        this.createConnectionParameters(composite);
        this.createEndpointParameters(composite);
        this.createDeploymentParameters(composite);
        this.createContextWindowSizeField(composite);
        this.createModelParameters(composite);
        this.createAdditionalSettings(composite);
        UIUtils.syncExec(this::applySettings);
    }

    public void loadSettings(@NotNull AzureAIProperties properties) {
        this.token = CommonUtils.toString((Object)properties.getToken());
        this.temperature = CommonUtils.toString((Object)properties.getTemperature(), (String)"0.0");
        this.logQuery = CommonUtils.toBoolean((Object)properties.isLoggingEnabled());
        this.endpoint = CommonUtils.toString((Object)properties.getUrl(), (String)this.endpoint);
        this.deployment = CommonUtils.toString((Object)properties.getDeployment(), (String)this.deployment);
        this.audioDeployment = CommonUtils.toString((Object)properties.getAudioDeployment(), (String)this.audioDeployment);
        this.contextWindowSizeField.setValue(properties.getContextWindowSize());
        this.applySettings();
    }

    public void saveSettings(@NotNull AzureAIProperties properties) {
        properties.setToken(this.token);
        properties.setTemperature(CommonUtils.toDouble((Object)this.temperature));
        properties.setLoggingEnabled(this.logQuery);
        properties.setBaseUrl(this.endpoint);
        properties.setDeployment(this.deployment);
        properties.setContextWindowSize(this.contextWindowSizeField.getValue());
        properties.setAudioDeployment(this.audioDeployment);
    }

    public void resetSettings(@NotNull AzureAIProperties properties) {
    }

    private void createDeploymentParameters(Composite parent) {
        this.deploymentText = UIUtils.createLabelText((Composite)parent, (String)"Deployment", (String)"", (int)2048);
        this.deploymentText.setLayoutData((Object)new GridData(768));
        this.deploymentText.addModifyListener(e -> {
            String string = this.deployment = this.deploymentText.getText();
        });
        this.deploymentText.setMessage("The deployment name you chose when you deployed the model.");
        this.audioDeploymentText = UIUtils.createLabelText((Composite)parent, (String)"Audio Deployment", (String)"", (int)2048);
        this.audioDeploymentText.setLayoutData((Object)new GridData(768));
        this.audioDeploymentText.addModifyListener(e -> {
            String string = this.audioDeployment = this.audioDeploymentText.getText();
        });
        this.audioDeploymentText.setMessage("The deployment name for audio transcribe.");
    }

    private void createContextWindowSizeField(Composite composite) {
        this.contextWindowSizeField = ContextWindowSizeField.builder().withParent(composite).withGridData(new GridData(768)).build();
    }

    private void createEndpointParameters(Composite parent) {
        this.endpointText = UIUtils.createLabelText((Composite)parent, (String)"Endpoint", (String)"", (int)2048);
        this.endpointText.setLayoutData((Object)new GridData(768));
        this.endpointText.addModifyListener(e -> {
            String string = this.endpoint = this.endpointText.getText();
        });
    }

    protected void createAdditionalSettings(@NotNull Composite parent) {
        this.logQueryCheck = UIUtils.createCheckbox((Composite)parent, (String)"Write AI queries to debug log", (String)"Write AI queries with metadata info in the the debug logs", (boolean)false, (int)2);
        this.logQueryCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AzureAIConfigurator.this.logQuery = AzureAIConfigurator.this.logQueryCheck.getSelection();
            }
        });
    }

    protected void createModelParameters(@NotNull Composite parent) {
        this.temperatureText = UIUtils.createLabelText((Composite)parent, (String)AIUIMessages.gpt_preference_page_text_temperature, (String)"0.0");
        this.temperatureText.addVerifyListener(UIUtils.getNumberVerifyListener((Locale)Locale.getDefault()));
        this.temperatureText.setToolTipText("Lower temperatures give more precise results");
        this.temperatureText.addVerifyListener(UIUtils.getNumberVerifyListener((Locale)Locale.getDefault()));
        this.temperatureText.addModifyListener(e -> {
            String string = this.temperature = this.temperatureText.getText();
        });
    }

    protected void createConnectionParameters(@NotNull Composite parent) {
        this.tokenText = UIUtils.createLabelText((Composite)parent, (String)AIUIMessages.gpt_preference_page_selector_token, (String)"", (int)0x400800);
        GridData gd = new GridData(768);
        gd.widthHint = 150;
        this.tokenText.setLayoutData((Object)gd);
        this.tokenText.addModifyListener(e -> {
            String string = this.token = this.tokenText.getText();
        });
        this.tokenText.setMessage("API access token");
    }

    protected void applySettings() {
        if (this.tokenText != null) {
            this.tokenText.setText(this.token);
        }
        this.temperatureText.setText(this.temperature);
        this.logQueryCheck.setSelection(this.logQuery);
        this.endpointText.setText(this.endpoint);
        this.deploymentText.setText(this.deployment);
        this.audioDeploymentText.setText(this.audioDeployment);
    }

    public boolean isComplete() {
        return this.tokenText == null || !this.tokenText.getText().isEmpty();
    }
}

