/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.ai.commands;

import com.dbeaver.model.ai.prompt.AIPromptSqlCompletion;
import com.dbeaver.ui.ai.chat.internal.AIProFeatures;
import com.dbeaver.ui.ai.messages.AIUIAdvancedMessages;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.StyledText;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.ai.utils.AIUtils;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.parser.SQLScriptParser;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.SQLEditorThemeSettings;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.commands.AbstractSchemaHandler;
import org.jkiss.dbeaver.ui.editors.sql.suggestion.SQLSuggestionTextPainter;
import org.jkiss.utils.CommonUtils;

public class SQLEditorHandlerSuggestTextKey
extends AbstractSchemaHandler {
    private static final Log log = Log.getLog(SQLEditorHandlerSuggestTextKey.class);

    public Object execute(ExecutionEvent event) {
        int cursorPosition;
        SQLEditor editor = this.getEditor(event);
        DBPDataSource dataSource = editor.getDataSource();
        if (dataSource == null) {
            DBWorkbench.getPlatformUI().showError(AIUIAdvancedMessages.ai_suggestion_failed_message, AIUIAdvancedMessages.ai_suggestion_no_active_connection_message);
            return null;
        }
        AIProFeatures.AI_SQL_SUGGESTION.use(Map.of("driver", dataSource.getContainer().getDriver().getPreconfiguredId()));
        ISelection sel = editor.getSelectionProvider().getSelection();
        if (sel instanceof ITextSelection) {
            ITextSelection textSel = (ITextSelection)sel;
            cursorPosition = textSel.getOffset();
        } else {
            StyledText textWidget = editor.getViewer().getTextWidget();
            int widgetOffset = textWidget.getCaretOffset();
            SourceViewer viewer = editor.getViewer();
            if (viewer instanceof ITextViewerExtension5) {
                ITextViewerExtension5 ext5 = (ITextViewerExtension5)viewer;
                cursorPosition = ext5.widgetOffset2ModelOffset(widgetOffset);
            } else {
                cursorPosition = widgetOffset;
            }
        }
        final DBCExecutionContext context = this.getExecutionContext(editor);
        if (context == null) {
            DBWorkbench.getPlatformUI().showError(AIUIAdvancedMessages.ai_suggestion_failed_message, AIUIAdvancedMessages.ai_suggestion_no_active_connection_message);
            return null;
        }
        IDocument document = editor.getDocument();
        if (document == null) {
            return null;
        }
        String scriptContent = document.get();
        final SQLScriptElement sqlScriptElement = SQLScriptParser.parseQuery((DBPDataSource)dataSource, (SQLDialect)dataSource.getSQLDialect(), (DBPPreferenceStore)DBWorkbench.getPlatform().getPreferenceStore(), (String)scriptContent, (int)cursorPosition);
        if (sqlScriptElement == null) {
            return null;
        }
        final SQLSuggestionTextPainter gtp = editor.getSuggestionTextPainter();
        new AbstractJob("AI Suggestion"){

            protected IStatus run(DBRProgressMonitor monitor) {
                try {
                    if (!AIUtils.hasValidConfiguration()) {
                        return Status.error((String)AIUIAdvancedMessages.ai_configuration_invalid_message);
                    }
                    String suggestion = AIPromptSqlCompletion.readCompletionSuggestion((DBRProgressMonitor)monitor, (DBPWorkspace)DBWorkbench.getPlatform().getWorkspace(), (DBCExecutionContext)context, (String)sqlScriptElement.getText(), (int)cursorPosition);
                    if (CommonUtils.isEmptyTrimmed((String)suggestion)) {
                        return Status.OK_STATUS;
                    }
                    UIUtils.syncExec(() -> {
                        if (CommonUtils.isNotEmpty((String)suggestion)) {
                            gtp.setFontColor(SQLEditorThemeSettings.instance.editorAISuggestionColor);
                            gtp.setSuggestionBackgroundColor(SQLEditorThemeSettings.instance.editorAISuggestionBackgroundColor);
                            gtp.showHint(suggestion, cursorPosition);
                        } else {
                            gtp.removeHint();
                        }
                    });
                }
                catch (Exception e) {
                    return Status.error((String)AIUIAdvancedMessages.ai_suggestion_failed_message, (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
        return null;
    }
}

