/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.ai.commands;

import com.dbeaver.model.ai.AIChatConversation;
import com.dbeaver.model.ai.AIChatConversationSettings;
import com.dbeaver.model.ai.AIUtilsPro;
import com.dbeaver.model.ai.prompt.AIPromptObjectDescribe;
import com.dbeaver.ui.ai.chat.AIChatView;
import com.dbeaver.ui.ai.chat.controls.AIChatControl;
import com.dbeaver.ui.ai.chat.internal.AIProFeatures;
import com.dbeaver.ui.ai.messages.AIUIAdvancedMessages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.ai.AIDatabaseScope;
import org.jkiss.dbeaver.model.ai.AIMessage;
import org.jkiss.dbeaver.model.ai.AIPromptGenerator;
import org.jkiss.dbeaver.model.ai.engine.AIDatabaseContext;
import org.jkiss.dbeaver.model.ai.utils.AIUtils;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;

public class AIObjectDescribeHandler
extends AbstractHandler
implements IElementUpdater {
    public Object execute(ExecutionEvent event) {
        AIChatControl chat;
        DBPDataSource dataSource;
        ArrayList<DBSObject> dbsObjects;
        block14: {
            dbsObjects = new ArrayList<DBSObject>();
            ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            if (!selection.isEmpty()) {
                for (DBNNode node : NavigatorUtils.getSelectedNodes((ISelection)selection)) {
                    if (node instanceof DBNDatabaseFolder) {
                        node = node.getParentNode();
                    }
                    if (!(node instanceof DBNDatabaseNode)) continue;
                    DBNDatabaseNode dbNode = (DBNDatabaseNode)node;
                    dbsObjects.add(dbNode.getObject());
                }
            } else {
                DBSObject dbsObject = NavigatorUtils.getCurrentDatabaseObject();
                if (dbsObject != null) {
                    dbsObjects.add(dbsObject);
                }
            }
            if (dbsObjects.isEmpty()) {
                DBWorkbench.getPlatformUI().showError(AIUIAdvancedMessages.ai_popup_description_title, AIUIAdvancedMessages.ai_description_not_available_message);
                return null;
            }
            DBSObject firstObject = (DBSObject)dbsObjects.getFirst();
            dataSource = firstObject.getDataSource();
            if (dataSource == null) {
                DBWorkbench.getPlatformUI().showError(AIUIAdvancedMessages.ai_popup_description_title, NLS.bind((String)AIUIAdvancedMessages.ai_description_not_connected_message, (Object)firstObject.getName()));
                return null;
            }
            AIProFeatures.AI_METADATA_DESCRIPTION.use(Map.of("driver", dataSource.getContainer().getDriver().getPreconfiguredId(), "objectType", firstObject.getClass().getSimpleName()));
            try {
                if (AIUtils.hasValidConfiguration()) break block14;
                DBWorkbench.getPlatformUI().showError(AIUIAdvancedMessages.ai_popup_description_title, AIUIAdvancedMessages.ai_token_not_specified_message);
                return null;
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError(AIUIAdvancedMessages.ai_popup_description_title, AIUIAdvancedMessages.ai_description_error_generating_message, (Throwable)e);
                return null;
            }
        }
        try {
            chat = AIChatView.show().getChat();
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Smart metadata description", "Can't open AI chat", (Throwable)e);
            return null;
        }
        AIDatabaseContext databaseContext = (AIDatabaseContext)UIUtils.runWithMonitor(monitor -> AIPromptObjectDescribe.createDatabaseContext((DBRProgressMonitor)monitor, (List)dbsObjects));
        String title = "Describe " + dbsObjects.stream().map(o -> AIUtilsPro.getDatabaseObjectInfo((DBSObject)o, (boolean)true)).collect(Collectors.joining(", "));
        AIChatConversation conversation = new AIChatConversation(title, (AIPromptGenerator)AIPromptObjectDescribe.create(() -> ((AIDatabaseContext)databaseContext).getDataSource(), dbsObjects), Collections.emptyList(), dataSource.getContainer());
        chat.selectConversation(conversation);
        AIChatConversationSettings customSettings = new AIChatConversationSettings(chat.getChatSession(), conversation);
        customSettings.loadDataSourceDefaults();
        customSettings.setScope(databaseContext.getScope());
        if (customSettings.getScope() == AIDatabaseScope.CUSTOM && databaseContext.getCustomEntities() != null) {
            List<String> objectIds = databaseContext.getCustomEntities().stream().map(DBUtils::getObjectFullId).toList();
            customSettings.setCustomObjectIds(objectIds.toArray(new String[0]));
        }
        conversation.setCustomSettings(customSettings);
        AIMessage aiMessage = AIPromptObjectDescribe.createDescribeMessage(dbsObjects);
        chat.submitPrompt(aiMessage);
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        DBNNode node;
        IStructuredSelection structuredSelection;
        ISelection selection;
        ISelectionProvider selectionProvider = UIUtils.getSelectionProvider((IServiceLocator)element.getServiceLocator());
        if (selectionProvider != null && (selection = selectionProvider.getSelection()) instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1 && (node = NavigatorUtils.getSelectedNode((ISelection)structuredSelection)) instanceof DBNDatabaseNode) {
            DBNDatabaseNode dBNDatabaseNode = (DBNDatabaseNode)node;
        }
    }
}

