/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.ai.chat.controls;

import com.dbeaver.model.ai.AIChatConversation;
import com.dbeaver.model.ai.AIChatListener;
import com.dbeaver.model.ai.AIChatMessage;
import com.dbeaver.model.ai.audio.AITranscriptResult;
import com.dbeaver.ui.ai.chat.controls.AIChatControl;
import com.dbeaver.ui.ai.chat.internal.AIChatIcons;
import com.dbeaver.ui.ai.chat.internal.AIChatMessages;
import com.dbeaver.ui.ai.chat.internal.AIProFeatures;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.FillLayoutFactory;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.ai.AIMessageType;
import org.jkiss.dbeaver.model.ai.utils.AIUtils;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.AbstractUIJob;
import org.jkiss.dbeaver.ui.ActionBars;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.CompositeBorderPainter;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.MessageBoxBuilder;
import org.jkiss.dbeaver.ui.dialogs.Reply;
import org.jkiss.dbeaver.ui.editors.TextEditorUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class PromptComposite
extends Composite {
    private static final Log log = Log.getLog(PromptComposite.class);
    private final Reply discard = new Reply(AIChatMessages.ai_chat_transcription_discard_button);
    private final Reply transcribe = new Reply(AIChatMessages.ai_chat_transcription_transcribe_button);
    private final Reply toContinue = new Reply(AIChatMessages.ai_chat_transcription_continue_button);
    private final AIChatControl chat;
    private final StyledText promptText;
    private final Button sendButton;
    private final Button recordButton;
    private final StackLayout stack;
    private final Canvas audioCanvas;
    private final Composite stackHost;
    private volatile boolean audioRecording;
    private final AtomicBoolean audioTranscribing = new AtomicBoolean(false);

    public PromptComposite(final @NotNull AIChatControl chat, @NotNull Composite parent) {
        super(parent, 0);
        this.chat = chat;
        IWorkbenchPartSite site = chat.getController().getSite();
        chat.getChatSession().addListener(new AIChatListener(){

            public void busyChanged(boolean busy) {
                PromptComposite.this.promptText.setEnabled(!busy);
                PromptComposite.this.sendButton.setEnabled(!busy);
                PromptComposite.this.recordButton.setEnabled(!busy);
                if (!busy) {
                    PromptComposite.this.sendButton.setText(AIChatMessages.ai_chat_send_button_label);
                    PromptComposite.this.sendButton.setToolTipText(AIChatMessages.ai_chat_send_button_tip);
                    PromptComposite.this.sendButton.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.SQL_EXECUTE));
                    PromptComposite.this.setFocusOnPrompt();
                } else {
                    new AbstractUIJob("Enable AI cancellation"){

                        protected IStatus runInUIThread(DBRProgressMonitor monitor) {
                            if (chat.getChatSession().isRunning()) {
                                (this).PromptComposite.this.sendButton.setImage(null);
                                (this).PromptComposite.this.sendButton.setText(IDialogConstants.CANCEL_LABEL);
                                (this).PromptComposite.this.sendButton.setToolTipText(AIChatMessages.ai_chat_cancel_button_tip);
                                (this).PromptComposite.this.sendButton.setEnabled(true);
                            }
                            return Status.OK_STATUS;
                        }
                    }.schedule(500L);
                }
            }
        });
        this.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(1, 1).numColumns(2).create());
        Composite promptBorder = new Composite((Composite)this, 0);
        promptBorder.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        promptBorder.setLayout((Layout)FillLayoutFactory.fillDefaults().margins(2, 2).create());
        this.stackHost = new Composite(promptBorder, 0);
        this.stack = new StackLayout();
        this.stackHost.setLayout((Layout)this.stack);
        this.promptText = new StyledText(this.stackHost, 578);
        this.promptText.setLayoutData((Object)new GridData(1808));
        this.promptText.addKeyListener((KeyListener)new PromptKeyAdapter(chat));
        this.updatePromptEditorSize();
        this.promptText.addModifyListener(e -> this.updatePromptEditorSize());
        this.audioCanvas = new Canvas(this.stackHost, 0x20000000);
        this.stack.topControl = this.promptText;
        promptBorder.layout();
        TextEditorUtils.enableHostEditorKeyBindingsSupport((IWorkbenchPartSite)site, (Control)this.promptText);
        String sendShortcut = CommonUtils.notEmpty((String)ActionUtils.findCommandDescription((String)"com.dbeaver.ai.chat.sendPrompt", (IServiceLocator)site, (boolean)true));
        UIUtils.addEmptyTextHint((Control)this.promptText, text -> NLS.bind((String)AIChatMessages.ai_chat_prompt_text_hint, (Object)sendShortcut));
        new CompositeBorderPainter((Control)promptBorder);
        Composite rightControls = UIUtils.createComposite((Composite)this, (int)1);
        Composite buttonsBar = UIUtils.createComposite((Composite)rightControls, (int)2);
        buttonsBar.setLayoutData((Object)new GridData(4));
        this.sendButton = UIUtils.createPushButton((Composite)buttonsBar, (String)AIChatMessages.ai_chat_send_button_label, (String)(AIChatMessages.ai_chat_send_button_tip + " (" + ActionUtils.findCommandDescription((String)"com.dbeaver.ai.chat.sendPrompt", (IServiceLocator)site, (boolean)true) + ")"), (DBPImage)UIIcon.SQL_EXECUTE, (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> ActionUtils.runCommand((String)"com.dbeaver.ai.chat.sendPrompt", (IServiceLocator)site)));
        this.recordButton = UIUtils.createPushButton((Composite)buttonsBar, null, (String)(AIChatMessages.ai_chat_record_button_tip + " (" + ActionUtils.findCommandDescription((String)"com.dbeaver.ai.chat.recordAudio", (IServiceLocator)site, (boolean)true) + ")"), (DBPImage)AIChatIcons.MIC_OFF, (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> ActionUtils.runCommand((String)"com.dbeaver.ai.chat.recordAudio", (IServiceLocator)site)));
    }

    public void submitPrompt() {
        if (this.chat.getChatSession().isRunning()) {
            if (!this.sendButton.getText().equals(IDialogConstants.CANCEL_LABEL)) {
                return;
            }
            if (this.audioRecording) {
                try {
                    this.cancelSpeechTranscription();
                }
                catch (Exception ex) {
                    log.error((Object)ex);
                }
            }
            this.chat.cancelPrompt();
        } else {
            this.chat.submitPrompt(this.promptText.getText());
        }
    }

    public void recordAudio() throws DBException, IOException {
        if (!this.chat.getAssistant().supportTranscription()) {
            DBWorkbench.getPlatformUI().showMessageBox("Audio not supported", "Audio transcription is not supported by " + AIUtils.getActiveEngineDescriptor().getLabel(), true);
            return;
        }
        if (!this.audioRecording) {
            this.startSpeechTranscription();
        } else {
            this.stopSpeechTranscription();
        }
    }

    public boolean isAudioRecording() {
        return this.audioRecording;
    }

    private void updatePromptEditorSize() {
        Rectangle textBounds;
        int textLength = this.promptText.getCharCount();
        int lineHeight = this.promptText.getLineCount() * this.promptText.getLineHeight();
        Rectangle rectangle = textBounds = textLength <= 0 ? new Rectangle(0, 0, 0, 0) : this.promptText.getTextBounds(0, textLength - 1);
        if (textBounds.height > lineHeight) {
            lineHeight = textBounds.height;
        }
        int maxHeight = UIUtils.getFontHeight((Control)this.promptText) * 10;
        int minHeight = this.promptText.getLineHeight() * 2;
        int height = Math.max(Math.min(maxHeight, lineHeight), minHeight) + 4;
        GridData data = (GridData)this.promptText.getParent().getParent().getLayoutData();
        if (data.heightHint != height) {
            data.heightHint = height;
            Composite container = this.getParent();
            container.setRedraw(false);
            container.layout(true, true);
            container.setRedraw(true);
        }
    }

    private void startSpeechTranscription() throws DBException, IOException {
        DBPDataSourceContainer ds = this.chat.getDataSourceContainer();
        if (ds != null) {
            AIProFeatures.AI_SPEECH_RECOGNITION.use(Map.of("driver", ds.getDriver().getPreconfiguredId()));
        }
        this.chat.getSpeechService().start();
        this.audioRecording = true;
        this.switchToPromptText(false);
        new AudioRecordProgressJob().schedule();
    }

    private void stopSpeechTranscription() throws DBException, IOException {
        this.chat.getSpeechService().stop();
        this.audioRecording = false;
        this.switchToPromptText(true);
        this.transcribeAudio();
    }

    private void cancelSpeechTranscription() throws DBException, IOException {
        this.chat.getSpeechService().stop();
        this.audioRecording = false;
        this.switchToPromptText(true);
    }

    private void transcribeAudio() {
        if (!this.audioTranscribing.compareAndSet(false, true)) {
            return;
        }
        new AbstractJob("AI transcribe"){

            protected IStatus run(DBRProgressMonitor monitor) {
                try {
                    AITranscriptResult result = PromptComposite.this.chat.getSpeechService().transcribeBlocking();
                    if (!PromptComposite.this.isDisposed()) {
                        UIUtils.asyncExec(() -> PromptComposite.this.setPromptText(result.text()));
                    }
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (Exception e) {
                    IStatus iStatus = GeneralUtils.makeExceptionStatus((Throwable)e);
                    return iStatus;
                }
                finally {
                    PromptComposite.this.audioTranscribing.set(false);
                }
            }
        }.schedule();
        new AudioTranscribeProgressJob().schedule();
    }

    @NotNull
    Runnable createTranscriptionDecisionAction(@NotNull String title, @NotNull String message, boolean withContinue) {
        return () -> UIUtils.syncExec(() -> {
            try {
                this.prepareForDecision(withContinue);
                Reply reply = this.buildTranscriptionDialog(title, message, withContinue).showMessageBox();
                this.handleDecision(reply, withContinue);
            }
            catch (Exception e) {
                log.error((Object)"Failed speech service action", (Throwable)e);
            }
        });
    }

    private void prepareForDecision(boolean withContinue) throws DBException, IOException {
        if (withContinue) {
            this.chat.getSpeechService().pause();
        } else {
            this.cancelSpeechTranscription();
        }
    }

    private void handleDecision(@Nullable Reply reply, boolean withContinue) throws DBException, IOException {
        if (reply == this.transcribe) {
            this.stopSpeechTranscription();
            return;
        }
        if (!withContinue) {
            return;
        }
        if (reply == this.toContinue) {
            this.chat.getSpeechService().resume();
        } else if (reply == this.discard) {
            this.cancelSpeechTranscription();
        }
    }

    @NotNull
    private MessageBoxBuilder buildTranscriptionDialog(@NotNull String title, @NotNull String message, boolean withContinue) {
        MessageBoxBuilder b = MessageBoxBuilder.builder().setTitle(title).setMessage(message).setPrimaryImage((DBPImage)DBIcon.STATUS_QUESTION);
        return withContinue ? b.setReplies(new Reply[]{this.discard, this.transcribe, this.toContinue}).setDefaultReply(this.toContinue) : b.setReplies(new Reply[]{this.discard, this.transcribe}).setDefaultReply(this.transcribe);
    }

    @NotNull
    public String getPromptText() {
        if (this.promptText.isDisposed()) {
            return "";
        }
        return this.promptText.getText();
    }

    public void setPromptText(@NotNull String text) {
        this.promptText.setText(text);
        this.promptText.setCaretOffset(text.length());
        this.updatePromptEditorSize();
    }

    public void setFocusOnPrompt() {
        this.promptText.setFocus();
        this.promptText.notifyListeners(24, new Event());
    }

    private void showStatus(String status) {
        IStatusLineManager statusLine = ActionBars.extractStatusLineManager((IWorkbenchSite)this.chat.getController().getSite());
        if (statusLine != null) {
            statusLine.setMessage(status);
        }
    }

    public Canvas getAudioCanvas() {
        return this.audioCanvas;
    }

    private void switchToPromptText(boolean promptTextTop) {
        if (promptTextTop) {
            this.stack.topControl = this.promptText;
            this.stackHost.layout();
        } else {
            this.stack.topControl = this.audioCanvas;
            this.stackHost.layout();
        }
    }

    private class AudioRecordProgressJob
    extends AbstractUIJob {
        private int tickCount;
        private final long startTime;

        protected AudioRecordProgressJob() {
            super("Audio recording");
            this.startTime = System.currentTimeMillis();
        }

        protected IStatus runInUIThread(DBRProgressMonitor monitor) {
            if (PromptComposite.this.recordButton != null && !PromptComposite.this.recordButton.isDisposed()) {
                ++this.tickCount;
                if (PromptComposite.this.isAudioRecording()) {
                    Duration duration = Duration.ofMillis(System.currentTimeMillis() - this.startTime);
                    PromptComposite.this.showStatus("Recording " + String.format("%d.%ds", duration.toSecondsPart(), duration.toMillisPart() % 100));
                    PromptComposite.this.recordButton.setImage(DBeaverIcons.getImage((DBPImage)((DBPImage)AIChatIcons.RECORDING.get(this.tickCount % AIChatIcons.RECORDING.size()))));
                    this.schedule(100L);
                } else {
                    PromptComposite.this.recordButton.setImage(DBeaverIcons.getImage((DBPImage)AIChatIcons.MIC_OFF));
                    PromptComposite.this.showStatus("");
                }
            }
            return Status.OK_STATUS;
        }
    }

    private class AudioTranscribeProgressJob
    extends AbstractUIJob {
        private int tickCount;

        protected AudioTranscribeProgressJob() {
            super("Audio transcribing");
            PromptComposite.this.chat.getChatSession().setBusy(true);
        }

        protected IStatus runInUIThread(DBRProgressMonitor monitor) {
            if (PromptComposite.this.recordButton != null && !PromptComposite.this.recordButton.isDisposed()) {
                ++this.tickCount;
                if (PromptComposite.this.audioTranscribing.get()) {
                    PromptComposite.this.showStatus("Process audio stream...");
                    PromptComposite.this.recordButton.setImage(DBeaverIcons.getImage((DBPImage)((DBPImage)UIIcon.LOADING.get(this.tickCount % UIIcon.LOADING.size()))));
                    this.schedule(100L);
                } else {
                    PromptComposite.this.recordButton.setImage(DBeaverIcons.getImage((DBPImage)AIChatIcons.MIC_OFF));
                    PromptComposite.this.showStatus("");
                    PromptComposite.this.chat.getChatSession().setBusy(false);
                }
            }
            return Status.OK_STATUS;
        }
    }

    private class PromptKeyAdapter
    extends KeyAdapter {
        private final AIChatControl chat;

        public PromptKeyAdapter(AIChatControl chat) {
            this.chat = chat;
        }

        public void keyPressed(KeyEvent e) {
            if (e.keyCode == 0x1000001 && PromptComposite.this.promptText.getText().isBlank()) {
                AIChatConversation conversation = this.chat.getActiveConversation();
                List messages = conversation.getMessages();
                int i = messages.size() - 1;
                while (i >= 0) {
                    AIChatMessage message = (AIChatMessage)messages.get(i);
                    if (message.message().getRole() == AIMessageType.USER) {
                        String oldPrompt = message.message().getContent();
                        PromptComposite.this.promptText.setText(oldPrompt);
                        PromptComposite.this.promptText.setSelection(oldPrompt.length());
                        break;
                    }
                    --i;
                }
                e.doit = false;
            } else if (e.keyCode == 27) {
                try {
                    PromptComposite.this.cancelSpeechTranscription();
                }
                catch (Exception ex) {
                    DBWorkbench.getPlatformUI().showError("Cancel error", "Error canceling audio recording", (Throwable)ex);
                }
            }
        }
    }
}

