/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.ai.chat.controls;

import com.dbeaver.model.ai.AIChatListener;
import com.dbeaver.model.ai.AIChatMessage;
import com.dbeaver.ui.ai.chat.AIChatUtils;
import com.dbeaver.ui.ai.chat.controls.AIChatControl;
import com.dbeaver.ui.ai.chat.controls.ChatCodeEditor;
import com.dbeaver.ui.ai.chat.internal.AIChatMessages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.ui.css.swt.dom.WidgetElement;
import org.eclipse.jface.layout.FillLayoutFactory;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPartSite;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.ai.AIMessageType;
import org.jkiss.dbeaver.model.ai.impl.LinkPosition;
import org.jkiss.dbeaver.model.ai.impl.MessageChunk;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithReturn;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.BaseThemeSettings;
import org.jkiss.dbeaver.ui.CompositeBorderPainter;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.HoverControlSupport;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.css.CSSUtils;
import org.jkiss.dbeaver.ui.editors.TextEditorUtils;
import org.jkiss.utils.CommonUtils;

public class MessageComposite
extends Composite {
    private static final Log log = Log.getLog(MessageComposite.class);
    private static final String CSS_ID = "ai-chat-message";
    private static final String POPUP_CSS_ID = "ai-chat-message-popup";
    private static final String CSS_CODE_CLASS = "code";
    private final AIChatControl chat;
    private final AIChatMessage message;
    private final List<ChatCodeEditor> codeEditors = new ArrayList<ChatCodeEditor>();
    private final List<MessageChunk> chunks;
    private final boolean first;

    MessageComposite(@NotNull AIChatControl chat, @NotNull Composite parent, @NotNull AIChatMessage message, final @NotNull List<MessageChunk> chunks, boolean first) {
        super(parent, 0);
        this.chat = chat;
        this.message = message;
        this.chunks = List.copyOf(chunks);
        this.first = first;
        boolean isUser = message.message().getRole() != AIMessageType.ASSISTANT;
        this.setLayout((Layout)GridLayoutFactory.swtDefaults().margins(isUser ? 10 : 0, 10).spacing(10, 5).numColumns(2).create());
        this.setLayoutData(new GridData(4, 4, true, true));
        WidgetElement.setID((Widget)this, (String)CSS_ID);
        if (message.message().getRole() == AIMessageType.WARNING || message.message().getRole() == AIMessageType.ERROR) {
            Label avatarLabel = UIUtils.createLabel((Composite)this, (DBPImage)AIChatUtils.getRoleIcon(message.message()));
            avatarLabel.setLayoutData((Object)new GridData(1, 1, false, false));
            avatarLabel.setToolTipText(NLS.bind((String)AIChatMessages.ai_chat_message_info_tip, (Object)AIChatUtils.getRoleName(message.message()), (Object)AIChatUtils.formatMessageTime(message.message())));
        }
        Composite holder = new Composite((Composite)this, 0);
        holder.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        holder.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).span(message.message().getRole() == AIMessageType.USER || message.message().getRole() == AIMessageType.WARNING || message.message().getRole() == AIMessageType.ERROR ? 1 : 2, 1).create());
        for (MessageChunk chunk : chunks) {
            if (chunk instanceof MessageChunk.Link) {
                MessageChunk.Link link = (MessageChunk.Link)chunk;
                this.createLinkControl(holder, link);
                continue;
            }
            if (chunk instanceof MessageChunk.Text) {
                MessageChunk.Text text = (MessageChunk.Text)chunk;
                this.createTextControl(holder, text);
                continue;
            }
            if (!(chunk instanceof MessageChunk.Code)) continue;
            MessageChunk.Code code = (MessageChunk.Code)chunk;
            Composite inner = new Composite(holder, 0);
            inner.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 0).margins(0, 0).create());
            inner.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
            inner.setBackground(this.getDisplay().getSystemColor(22));
            inner.setBackgroundMode(0);
            String sqlText = CommonUtils.notEmpty((String)code.text());
            if (isUser) {
                this.createCodeControl(inner, sqlText);
                continue;
            }
            if (this.createSqlControl(inner, sqlText)) continue;
            this.createCodeControl(inner, sqlText);
        }
        this.addPaintListener(e -> {
            if (message.message().getRole() == AIMessageType.USER) {
                GC gc = e.gc;
                Point size = this.getSize();
                gc.setBackground(this.getParent().getBackground());
                gc.fillRectangle(0, 0, 10, 10);
                gc.fillRectangle(size.x - 10, 0, 10, 10);
                gc.fillRectangle(0, size.y - 10, 10, 10);
                gc.fillRectangle(size.x - 10, size.y - 10, 10, 10);
                gc.setBackground(this.getBackground());
                gc.fillRoundRectangle(0, 0, size.x, size.y, 10, 10);
                ColorRegistry registry = UIUtils.getColorRegistry();
                gc.setForeground(registry.get("org.jkiss.dbeaver.ui.sqlPresentation.aiChat.color.prompt.border"));
                gc.drawRoundRectangle(0, 0, size.x - 1, size.y - 1, 10, 10);
            } else if (message.message().getRole() == AIMessageType.WARNING || message.message().getRole() == AIMessageType.ERROR) {
                GC gc = e.gc;
                Point size = this.getSize();
                Color color = message.message().getRole() == AIMessageType.WARNING ? BaseThemeSettings.instance.colorWarning : BaseThemeSettings.instance.colorError;
                gc.setForeground(color);
                gc.setLineWidth(5);
                gc.drawLine(0, 0, 0, size.y);
            }
        });
        this.addDisposeListener(e -> {
            for (ChatCodeEditor editor : this.codeEditors) {
                editor.dispose();
            }
        });
        new HoverControlSupport<MessageComposite>(this){

            protected void createControl(@NotNull Composite parent, @NotNull MessageComposite target) {
                CSSUtils.setCSSClass((Widget)parent, (String)MessageComposite.POPUP_CSS_ID);
                MessageComposite.this.contributeHoverControls(parent);
            }

            @NotNull
            protected Control pickOverlayControl(@NotNull MessageComposite target) {
                if (!chunks.isEmpty() && chunks.getLast() instanceof MessageChunk.Code && !MessageComposite.this.codeEditors.isEmpty()) {
                    return MessageComposite.this.codeEditors.getLast().getEditorControlWrapper();
                }
                return target;
            }
        };
    }

    void contributeHoverControls(@NotNull Composite parent) {
        ToolBar toolBar = new ToolBar(parent, 0x800100);
        if (this.message.message().getRole() == AIMessageType.USER && !this.first) {
            final ToolItem clearItem = new ToolItem(toolBar, 8);
            clearItem.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.CLEAN));
            clearItem.setToolTipText(AIChatMessages.ai_chat_message_clear_up_to_here_tip);
            clearItem.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> AIChatUtils.clearToHere(this.chat.getChatSession(), this.chat.getActiveConversation(), this.message)));
            AIChatListener listener = new AIChatListener(){

                public void busyChanged(boolean busy) {
                    if (!clearItem.isDisposed()) {
                        clearItem.setEnabled(!busy);
                    }
                }
            };
            this.chat.getChatSession().addListener(listener);
            clearItem.addDisposeListener(e -> this.chat.getChatSession().removeListener(listener));
        }
        ToolItem toolTipItem = new ToolItem(toolBar, 8);
        toolTipItem.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.SMALL_INFO));
        toolTipItem.setToolTipText(NLS.bind((String)AIChatMessages.ai_chat_message_info_tip, (Object)AIChatUtils.getRoleName(this.message.message()), (Object)AIChatUtils.formatMessageTime(this.message.message())));
    }

    @NotNull
    public AIChatMessage getMessage() {
        return this.message;
    }

    private void createSqlToolbar(@NotNull Composite parent, @NotNull String text) {
        boolean hasConnection = this.chat.getDataSourceContainer() != null;
        Composite toolBar = new Composite(parent, 0);
        toolBar.setLayoutData((Object)new GridData(768));
        toolBar.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(5, 0).numColumns(hasConnection ? 4 : 2).extendedMargins(0, 0, 5, 0).create());
        UIUtils.createEmptyLabel((Composite)toolBar, (int)1, (int)1).setLayoutData((Object)new GridData(768));
        if (hasConnection) {
            UIUtils.createPushButton((Composite)toolBar, (String)AIChatMessages.ai_chat_message_execute_query_label, (String)AIChatMessages.ai_chat_message_execute_query_tip, (DBPImage)UIIcon.SQL_EXECUTE, (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> AIChatUtils.executeInEditor(this.chat.getController(), text)));
            UIUtils.createPushButton((Composite)toolBar, (String)AIChatMessages.ai_chat_message_copy_to_editor_label, (String)AIChatMessages.ai_chat_message_copy_to_editor_tip, (DBPImage)UIIcon.LINK_TO_EDITOR, (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> AIChatUtils.openInEditor(this.chat, text, this.message.message())));
        }
        UIUtils.createPushButton((Composite)toolBar, (String)AIChatMessages.ai_chat_message_copy_to_clipboard_label, (String)AIChatMessages.ai_chat_message_copy_to_clipboard_tip, (DBPImage)UIIcon.FILTER_CLIPBOARD, (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> AIChatUtils.copyToClipboard(this.getDisplay(), text)));
    }

    private void createTextControl(@NotNull Composite parent, @NotNull MessageChunk.Text text) {
        final StyledText bodyLabel = new StyledText(parent, 72);
        bodyLabel.setText(text.text().trim());
        bodyLabel.setBackground(UIStyles.getDefaultTextBackground());
        StyleRange[] linkStyles = (LinkStyle[])text.getLinks().stream().map(LinkStyle::new).toArray(LinkStyle[]::new);
        bodyLabel.setStyleRanges(linkStyles);
        bodyLabel.addMouseMoveListener(e -> {
            int offset = bodyLabel.getOffsetAtPoint(new Point(e.x, e.y));
            if (offset < 0 || offset >= bodyLabel.getCharCount()) {
                bodyLabel.setCursor(null);
                return;
            }
            StyleRange rangeAtOffset = bodyLabel.getStyleRangeAtOffset(offset);
            if (rangeAtOffset instanceof LinkStyle) {
                bodyLabel.setCursor(this.getDisplay().getSystemCursor(21));
            } else {
                bodyLabel.setCursor(null);
            }
        });
        bodyLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                int offset = bodyLabel.getOffsetAtPoint(new Point(e.x, e.y));
                if (offset < 0 || offset >= bodyLabel.getText().length()) {
                    return;
                }
                StyleRange rangeAtOffset = bodyLabel.getStyleRangeAtOffset(offset);
                if (rangeAtOffset instanceof LinkStyle) {
                    LinkStyle link = (LinkStyle)rangeAtOffset;
                    if (link.data instanceof String) {
                        String url = (String)link.data;
                        UIUtils.openWebBrowser((String)url);
                    }
                }
            }
        });
        TextEditorUtils.enableHostEditorKeyBindingsSupport((IWorkbenchPartSite)this.chat.getController().getSite(), (Control)bodyLabel);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = Math.min(bodyLabel.computeSize((int)-1, (int)-1).x, 300);
        bodyLabel.setLayoutData((Object)gd);
    }

    private void createLinkControl(@NotNull Composite holder, @NotNull MessageChunk.Link link) {
        Link bodyLabel = new Link(holder, 0);
        bodyLabel.setText("<a>" + link.text() + "</a>");
        DBRRunnableWithReturn callback = link.getCallback();
        if (callback != null) {
            bodyLabel.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
                try {
                    callback.runTask((DBRProgressMonitor)new VoidProgressMonitor());
                }
                catch (DBException ex) {
                    DBWorkbench.getPlatformUI().showError("Link error", "Error opening chat link", (Throwable)ex);
                }
            }));
        }
    }

    private boolean createCodeControl(@NotNull Composite parent, @NotNull String code) {
        Composite host = new Composite(parent, 0);
        host.setLayout((Layout)GridLayoutFactory.fillDefaults().extendedMargins(9, 1, 1, 1).create());
        new CompositeBorderPainter((Control)host);
        StyledText text = new StyledText(host, 778);
        text.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        text.setText(code);
        text.setFont(BaseThemeSettings.instance.monospaceFont);
        text.setAlwaysShowScrollBars(false);
        host.setLayoutData((Object)ChatCodeEditor.createTextLayoutData(text, 4));
        WidgetElement.setCSSClass((Widget)host, (String)CSS_CODE_CLASS);
        return true;
    }

    private boolean createSqlControl(@NotNull Composite parent, @NotNull String code) {
        Composite host = new Composite(parent, 0);
        host.setLayout((Layout)FillLayoutFactory.fillDefaults().margins(1, 1).create());
        new CompositeBorderPainter((Control)host);
        try {
            ChatCodeEditor codeEditor = new ChatCodeEditor(this.chat.getController().getExecutionContext(), code);
            codeEditor.createCodeEditor(this.chat.getController().getSite(), host);
            this.codeEditors.add(codeEditor);
        }
        catch (DBException e) {
            log.debug((Object)"Can't create SQL panel", (Throwable)e);
            host.dispose();
            return false;
        }
        this.createSqlToolbar(parent, code);
        return true;
    }

    private static class LinkStyle
    extends StyleRange {
        public LinkStyle(@NotNull LinkPosition linkPosition) {
            super(linkPosition.start(), linkPosition.length(), null, null);
            this.data = linkPosition.url();
            this.underline = true;
            this.underlineStyle = 4;
        }
    }
}

