/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.ai.chat.controls;

import com.dbeaver.model.ai.AIAssistantPro;
import com.dbeaver.model.ai.AIChatAnnotation;
import com.dbeaver.model.ai.AIChatContextProvider;
import com.dbeaver.model.ai.AIChatConversation;
import com.dbeaver.model.ai.AIChatConversationSettings;
import com.dbeaver.model.ai.AIChatListener;
import com.dbeaver.model.ai.AIChatMessage;
import com.dbeaver.model.ai.AIChatSession;
import com.dbeaver.model.ai.audio.AIAssistantAudio;
import com.dbeaver.model.ai.audio.AIAudioRecorder;
import com.dbeaver.model.qm.QMServiceProvider;
import com.dbeaver.model.qm.ai.QMAIChatStorage;
import com.dbeaver.model.qm.ai.QMAIChatStorageInMemory;
import com.dbeaver.ui.ai.chat.AIChatController;
import com.dbeaver.ui.ai.chat.AIChatSpeechToTextService;
import com.dbeaver.ui.ai.chat.AIChatUtils;
import com.dbeaver.ui.ai.chat.controls.AudioHistogram;
import com.dbeaver.ui.ai.chat.controls.ContextComposite;
import com.dbeaver.ui.ai.chat.controls.PromptComposite;
import com.dbeaver.ui.ai.chat.controls.StandardMessageList;
import com.dbeaver.ui.ai.chat.controls.WebViewMessageList;
import com.dbeaver.ui.ai.chat.internal.AIChatMessages;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.eclipse.e4.ui.css.swt.dom.WidgetElement;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.ai.AIContextSettings;
import org.jkiss.dbeaver.model.ai.AIMessage;
import org.jkiss.dbeaver.model.ai.AIPromptGenerator;
import org.jkiss.dbeaver.model.ai.prompt.AIPromptGenerateSql;
import org.jkiss.dbeaver.model.ai.utils.AIUtils;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.logical.DBSLogicalDataSource;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.ai.AIUIUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.LazyValue;

public class AIChatControl
extends Composite
implements AIChatContextProvider {
    private static final Log log = Log.getLog(AIChatControl.class);
    public static final String AUDIO_TEMP_FOLDER = "audio";
    public static final String AI_AUDIO_WAV = "ai_audio.wav";
    private final AIChatSession chatSession;
    private final AIChatController controller;
    private final PromptComposite promptComposite;
    private volatile boolean waitingForResponse = false;
    private AIContextSettings activeCompletionSettings;
    private AIChatConversation activeConversation;
    private AIChatSpeechToTextService speechService;

    public boolean isWaitingForResponse() {
        return this.waitingForResponse;
    }

    public void setWaitingForResponse(boolean waitingForResponse) {
        this.waitingForResponse = waitingForResponse;
    }

    public AIChatControl(@NotNull Composite parent, @NotNull AIChatController controller) {
        super(parent, 0);
        QMServiceProvider provider;
        this.controller = controller;
        DBPWorkspace workspace = DBWorkbench.getPlatform().getWorkspace();
        if (!(workspace instanceof QMServiceProvider) || (provider = (QMServiceProvider)workspace).getActiveQueryManagerService() == null) {
            throw new IllegalStateException("QMServiceProvider is not available in the current workspace");
        }
        final QMAIChatStorage activeQueryManagerService = (QMAIChatStorage)provider.getActiveQueryManagerService();
        final Supplier<Boolean> qmdbAvailableSupplier = () -> activeQueryManagerService != null && provider.getQueryManagerSessionId() != null;
        LazyValue<QMAIChatStorage, DBException> chatStorage = new LazyValue<QMAIChatStorage, DBException>(){

            @NotNull
            protected QMAIChatStorage initialize() {
                return (Boolean)qmdbAvailableSupplier.get() != false ? activeQueryManagerService : new QMAIChatStorageInMemory();
            }
        };
        AIChatSession.SessionIdProvider sessionIdProvider = monitor -> (Boolean)qmdbAvailableSupplier.get() != false ? Objects.requireNonNull(provider.getQueryManagerSessionId()) : QMUtils.getWorkspaceSession((DBRProgressMonitor)monitor).getSessionId();
        this.chatSession = new AIChatSession(workspace, (AIChatContextProvider)this, (LazyValue)chatStorage, sessionIdProvider);
        this.setBackgroundMode(2);
        this.setLayout((Layout)new GridLayout());
        DBCExecutionContext executionContext = controller.getExecutionContext();
        this.activeConversation = this.createEmptyConversation(executionContext == null ? null : executionContext.getDataSource().getContainer());
        this.createContextControl(this);
        UIUtils.createLineSeparator((Composite)this, (int)256);
        Control messageListComposite = this.createMessageListControl(this);
        UIUtils.createLineSeparator((Composite)this, (int)256);
        this.promptComposite = this.createPromptControl(this);
        WidgetElement.applyStyles((Widget)this, (boolean)true);
        messageListComposite.addMouseListener(MouseListener.mouseDownAdapter(mouseEvent -> this.promptComposite.setFocusOnPrompt()));
    }

    public void sendPrompt() {
        this.promptComposite.submitPrompt();
    }

    public void recordAudio() {
        try {
            this.promptComposite.recordAudio();
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public boolean isAudioRecording() {
        return this.promptComposite.isAudioRecording();
    }

    private PromptComposite getPromptComposite() {
        return this.promptComposite;
    }

    public AIChatSession getChatSession() {
        return this.chatSession;
    }

    public void selectConversation(@NotNull AIChatConversation conversation) throws DBException {
        if (conversation == this.activeConversation) {
            return;
        }
        if (this.activeConversation != null) {
            this.chatSession.addConversation(this.activeConversation);
        }
        this.updateActiveConversation(conversation);
        AIContextSettings settings = conversation.getDataSource() != null ? this.chatSession.getConversationSettings(conversation) : null;
        this.setCompletionSettings(settings);
        this.chatSession.notifyListeners(AIChatListener::conversationChanged, (Object)conversation);
    }

    @NotNull
    public AIChatConversation getActiveConversation() {
        return this.activeConversation;
    }

    public void updateActiveConversation(@NotNull AIChatConversation conversation) throws DBException {
        this.chatSession.addConversation(conversation);
        this.activeConversation = conversation;
    }

    public void removeActiveConversation() throws DBException {
        if (this.activeConversation == null) {
            return;
        }
        this.chatSession.removeConversation(this.activeConversation);
        this.activeConversation = null;
        List<AIChatConversation> conversations = this.listConversations();
        if (conversations.isEmpty()) {
            this.selectConversation(this.createEmptyConversation(this.getDataSourceContainer()));
        } else {
            this.selectConversation(conversations.getLast());
        }
    }

    @NotNull
    AIChatConversation createEmptyConversation(@NotNull String name, @Nullable DBPDataSourceContainer container) {
        AIPromptGenerateSql aiPromptGenerator = AIPromptGenerateSql.create(() -> container == null ? null : new DBSLogicalDataSource(container));
        return new AIChatConversation(name, (AIPromptGenerator)aiPromptGenerator, container);
    }

    @NotNull
    AIChatConversation createEmptyConversation(@Nullable DBPDataSourceContainer container) {
        return this.createEmptyConversation(AIChatMessages.ai_chat_default_conversation_name, container);
    }

    @NotNull
    public List<AIChatConversation> listConversations() throws DBException {
        DBPDataSourceContainer container = this.getDataSourceContainer();
        return this.chatSession.getAllConversations(container);
    }

    public void cancelPrompt() {
        this.chatSession.cancelAICompletion();
    }

    public void submitPrompt(@NotNull String prompt) {
        AIMessage promptMessage = AIMessage.userMessage((String)prompt.trim());
        if (promptMessage.getContent().isEmpty()) {
            return;
        }
        this.submitPrompt(promptMessage);
    }

    public void submitPrompt(@NotNull AIMessage promptMessage) {
        AIChatConversationSettings settings = this.activeConversation.getCustomSettings();
        if (settings == null) {
            settings = this.getCompletionSettings();
        }
        if (settings != null && !AIUIUtils.confirmMetaTransfer((AIContextSettings)settings)) {
            return;
        }
        if (!this.checkConfiguration()) {
            return;
        }
        this.waitingForResponse = true;
        AIChatMessage chatMessage = this.activeConversation.addMessage(promptMessage);
        this.chatSession.notifyMessageAdd(this.activeConversation, chatMessage);
        this.chatSession.setBusy(true);
        CompletableFuture chatFuture = this.chatSession.submitConversation((AIContextSettings)settings, this.activeConversation);
        chatFuture.whenComplete((response, throwable) -> UIUtils.syncExec(() -> {
            if (this.promptComposite.isDisposed()) {
                return;
            }
            List<AIMessage> assistantMessage = new ArrayList();
            if (throwable != null) {
                log.debug((Object)"Error during AI completion", throwable);
                assistantMessage.add(AIMessage.errorMessage((Throwable)throwable));
            } else if (response != null) {
                assistantMessage = response;
                this.promptComposite.setPromptText("");
            } else {
                this.chatSession.notifyMessageRemove(this.activeConversation, chatMessage);
            }
            this.chatSession.setBusy(false);
            for (AIMessage message : assistantMessage) {
                AIChatMessage responseMessage = this.activeConversation.addMessage(message);
                this.chatSession.notifyMessageAdd(this.activeConversation, responseMessage);
            }
            this.waitingForResponse = false;
        }));
    }

    public boolean checkConfiguration() {
        try {
            if (!AIUtils.hasValidConfiguration()) {
                AIUIUtils.showPreferences((Shell)this.getShell());
                return false;
            }
        }
        catch (DBException e) {
            log.error((Object)e);
        }
        return true;
    }

    public AIAssistantPro getAssistant() {
        return this.chatSession.getAssistant();
    }

    public void setFocusOnPrompt() {
        this.promptComposite.setFocusOnPrompt();
    }

    public void renameConversation(@NotNull AIChatConversation conversation, @NotNull String newName) {
        conversation.setCaption(AIChatUtils.normalizeConversationCaption(newName));
        this.chatSession.notifyConversationRenamed(conversation, newName);
    }

    @Nullable
    public DBPDataSourceContainer getDataSourceContainer() {
        return this.activeCompletionSettings != null ? this.activeCompletionSettings.getDataSourceContainer() : null;
    }

    @Nullable
    public DBCExecutionContext getExecutionContext(@NotNull DBPDataSourceContainer dataSourceContainer) {
        DBCExecutionContext executionContext = this.controller.getExecutionContext();
        if (executionContext != null && executionContext.getDataSource() == dataSourceContainer.getDataSource()) {
            return executionContext;
        }
        return DBUtils.getDefaultContext((DBSObject)dataSourceContainer, (boolean)false);
    }

    @Nullable
    public AIContextSettings getCompletionSettings() {
        return this.activeCompletionSettings;
    }

    public void setCompletionSettings(@Nullable AIContextSettings completionSettings) {
        if (this.activeCompletionSettings != completionSettings) {
            this.activeCompletionSettings = completionSettings;
            this.chatSession.notifyListeners(AIChatListener::settingsChanged, (Object)completionSettings);
        }
    }

    public boolean isBusy() {
        return this.chatSession.isBusy();
    }

    public void setDataSource(@Nullable DBPDataSourceContainer container) throws DBException {
        if (container != null && container == this.getDataSourceContainer()) {
            return;
        }
        AIChatConversation conversation = this.chatSession.getLastConversation(container);
        this.setCompletionSettings(container == null || conversation == null ? null : this.chatSession.getConversationSettings(conversation));
        this.selectConversation(conversation != null ? conversation : this.createEmptyConversation(container));
    }

    public boolean hasMessages() {
        return !this.activeConversation.getMessages().isEmpty();
    }

    @NotNull
    public AIChatController getController() {
        return this.controller;
    }

    public AIChatSpeechToTextService getSpeechService() throws DBException {
        if (this.speechService == null) {
            if (!this.checkConfiguration()) {
                throw new DBException("AI is not configured");
            }
            Runnable longSilenceAction = this.promptComposite.createTranscriptionDecisionAction(AIChatMessages.ai_chat_transcription_silence_title, AIChatMessages.ai_chat_transcription_silence_message, true);
            DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
            int audioMaxDuration = CommonUtils.toInt((Object)store.getString("ai.transcript.audio.duration"), (int)60);
            Runnable longSpeechAction = this.promptComposite.createTranscriptionDecisionAction(NLS.bind((String)AIChatMessages.ai_chat_transcription_speech_title, (Object)audioMaxDuration), NLS.bind((String)AIChatMessages.ai_chat_transcription_speech_message, (Object)audioMaxDuration), false);
            this.speechService = new AIChatSpeechToTextService(audioMaxDuration, AIAudioRecorder.AUDIO_FORMAT, (AIAssistantAudio)this.getAssistant(), longSilenceAction, longSpeechAction, List.of(new AudioHistogram(this.promptComposite.getAudioCanvas(), AIAudioRecorder.AUDIO_FORMAT)));
            this.addDisposeListener(e -> this.speechService.close());
        }
        return this.speechService;
    }

    @NotNull
    public AIChatConversation findOrCreateAssociatedConversation(@NotNull SQLEditor editor, @NotNull SQLScriptElement query, @NotNull AIChatConversation newConversation) throws DBException {
        AIChatConversation associatedConversation;
        IAnnotationModel annotationModel = editor.getAnnotationModel();
        if (annotationModel == null) {
            return newConversation;
        }
        UUID associatedConversationId = this.getAssociatedConversationId(annotationModel, query);
        if (associatedConversationId != null && (associatedConversation = this.chatSession.getConversation(associatedConversationId)) != null) {
            return associatedConversation;
        }
        annotationModel.addAnnotation((Annotation)new AIChatAnnotation(newConversation.getId()), new Position(query.getOffset(), query.getLength()));
        return newConversation;
    }

    @Nullable
    private UUID getAssociatedConversationId(@NotNull IAnnotationModel annotationModel, @NotNull SQLScriptElement query) {
        Iterator iterator = annotationModel.getAnnotationIterator();
        while (iterator.hasNext()) {
            Annotation annotation = (Annotation)iterator.next();
            Position position = annotationModel.getPosition(annotation);
            if (!(annotation instanceof AIChatAnnotation)) continue;
            AIChatAnnotation aiChatAnnotation = (AIChatAnnotation)annotation;
            if (position == null || position.getOffset() != query.getOffset() || position.getLength() != query.getLength()) continue;
            return aiChatAnnotation.getConversationId();
        }
        return null;
    }

    @NotNull
    private Control createMessageListControl(@NotNull Composite parent) {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        if (store.getBoolean("ai.chat.webRenderer")) {
            try {
                return new WebViewMessageList(this, parent);
            }
            catch (IOException e) {
                log.error((Object)"Error creating WebViewMessageList", (Throwable)e);
            }
        }
        ScrolledComposite host = UIUtils.createScrolledComposite((Composite)parent, (int)512);
        StandardMessageList chat = new StandardMessageList(this, (Composite)host);
        chat.setBackgroundMode(2);
        chat.setLayoutData(new GridData(4, 0x1000008, true, true));
        UIUtils.configureScrolledComposite((ScrolledComposite)host, (Control)chat);
        return chat;
    }

    @NotNull
    private ContextComposite createContextControl(@NotNull Composite parent) {
        ContextComposite composite = new ContextComposite(this, parent);
        composite.setBackgroundMode(1);
        composite.setLayoutData(new GridData(4, 1, true, false));
        return composite;
    }

    @NotNull
    private PromptComposite createPromptControl(@NotNull Composite parent) {
        PromptComposite composite = new PromptComposite(this, parent);
        composite.setBackgroundMode(1);
        composite.setLayoutData(new GridData(4, 0x1000008, true, false));
        return composite;
    }
}

