/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.ai.chat;

import com.dbeaver.model.ai.AIChatContextProvider;
import com.dbeaver.model.ai.AIChatConversation;
import com.dbeaver.model.ai.AIChatConversationSettings;
import com.dbeaver.model.ai.AIChatMessage;
import com.dbeaver.model.ai.AIChatSession;
import com.dbeaver.ui.ai.chat.AIChatController;
import com.dbeaver.ui.ai.chat.controls.AIChatControl;
import com.dbeaver.ui.ai.chat.internal.AIChatIcons;
import com.dbeaver.ui.ai.chat.internal.AIChatMessages;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.ai.AIContextSettings;
import org.jkiss.dbeaver.model.ai.AIDatabaseScope;
import org.jkiss.dbeaver.model.ai.AIMessage;
import org.jkiss.dbeaver.model.ai.AIMessageType;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.UIServiceConnections;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.ai.controls.ScopeSelectorControl;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class AIChatUtils {
    public static void chooseCustomScope(@NotNull Shell shell, @NotNull AIContextSettings settings, @NotNull DBPDataSourceContainer container, @NotNull AIChatContextProvider contextProvider, @Nullable AIChatConversation conversation) {
        if (container.isConnected() && container.getDataSource() != null) {
            AIChatUtils.chooseContextCustomScope(shell, settings, container, contextProvider, conversation);
            return;
        }
        UIServiceConnections service = (UIServiceConnections)DBWorkbench.getService(UIServiceConnections.class);
        if (service == null) {
            DBWorkbench.getPlatformUI().showError("Can't connect to data source", "Try establishing the connection manually");
            return;
        }
        service.connectDataSource(container, e -> {
            DBPDataSource dataSource = container.getDataSource();
            if (dataSource != null) {
                UIUtils.syncExec(() -> AIChatUtils.chooseContextCustomScope(shell, settings, container, contextProvider, conversation));
            }
        });
    }

    public static void chooseContextCustomScope(@NotNull Shell shell, @NotNull AIContextSettings settings, @NotNull DBPDataSourceContainer dataSourceContainer, @NotNull AIChatContextProvider contextProvider, @Nullable AIChatConversation conversation) {
        DBCExecutionContext executionContext = contextProvider.getExecutionContext(dataSourceContainer);
        if (executionContext != null) {
            AIChatUtils.chooseCustomDataSourceScope(shell, settings, executionContext, conversation);
        }
    }

    public static void chooseCustomDataSourceScope(@NotNull Shell shell, @NotNull AIContextSettings settings, @NotNull DBCExecutionContext executionContext, @Nullable AIChatConversation conversation) {
        Set passedObjects = ArrayUtils.isEmpty((Object[])settings.getCustomObjectIds()) ? Set.of() : Set.of(settings.getCustomObjectIds());
        List ids = ScopeSelectorControl.chooseCustomEntities((Shell)shell, (DBRRunnableContext)UIUtils.getDefaultRunnableContext(), (DBCExecutionContext)executionContext, passedObjects);
        if (ids != null) {
            settings.setScope(AIDatabaseScope.CUSTOM);
            settings.setCustomObjectIds((String[])ids.toArray(String[]::new));
            AIChatUtils.saveContextSettings(conversation, settings);
        }
    }

    public static void saveContextSettings(@Nullable AIChatConversation conversation, @NotNull AIContextSettings settings) {
        try {
            if (conversation != null) {
                if (settings instanceof AIChatConversationSettings) {
                    AIChatConversationSettings cs = (AIChatConversationSettings)settings;
                    conversation.setCustomSettings(cs);
                } else {
                    conversation.setCustomSettings(null);
                }
            }
            settings.saveSettings();
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Settings save", "Settings save failed", (Throwable)e);
        }
    }

    public static void copyToClipboard(@NotNull Display display, @NotNull String text) {
        UIUtils.setClipboardContents((Display)display, (Transfer)TextTransfer.getInstance(), (Object)text);
    }

    public static void openInEditor(@NotNull AIChatControl chat, @NotNull String sqlCode, @NotNull AIMessage message) {
        String description;
        Object contents = sqlCode;
        if (DBWorkbench.getPlatform().getPreferenceStore().getBoolean("ai.completion.includeSourceTextInQuery") && !(description = AIChatUtils.createConversationDescription(chat.getActiveConversation(), message)).isBlank()) {
            DBPDataSourceContainer container = chat.getDataSourceContainer();
            String comment = SQLUtils.generateCommentLine((DBPDataSource)(container != null ? container.getDataSource() : null), (String)description);
            contents = comment + (String)contents;
        }
        chat.getController().openInEditor((String)contents, chat.getActiveConversation());
    }

    private static String createConversationDescription(AIChatConversation conversation, AIMessage message) {
        List messages = conversation.getMessages();
        if (messages.isEmpty() || ((AIChatMessage)messages.getFirst()).message().isAutoGenerated()) {
            return "";
        }
        return messages.stream().takeWhile(m -> m.message() != message).map(AIChatMessage::message).filter(messaged -> messaged.getRole() == AIMessageType.USER).map(AIMessage::getContent).map(CommonUtils::capitalizeWord).collect(Collectors.joining(". "));
    }

    public static void executeInEditor(@NotNull AIChatController chatController, @NotNull String text) {
        chatController.executeInEditor(text);
    }

    public static void clearToHere(@NotNull AIChatSession chatSession, @NotNull AIChatConversation activeConversation, @NotNull AIChatMessage message) {
        if (DBWorkbench.getPlatformUI().confirmAction(AIChatMessages.ai_chat_clear_history_confirm_title, AIChatMessages.ai_chat_clear_history_partial_confirm_message)) {
            chatSession.notifyMessagesRemove(activeConversation, message);
            activeConversation.clearMessagesAfter(message);
        }
    }

    @NotNull
    public static String formatMessageTime(@NotNull AIMessage message) {
        LocalDateTime time = message.getTime();
        if (time.getDayOfYear() == LocalDateTime.now().getDayOfYear()) {
            return time.format(DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT));
        }
        return time.format(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM));
    }

    @NotNull
    public static String getRoleName(@NotNull AIMessage message) {
        return switch (message.getRole()) {
            case AIMessageType.SYSTEM -> AIChatMessages.ai_chat_message_role_system_label;
            case AIMessageType.USER -> {
                if (message.isAutoGenerated()) {
                    yield AIChatMessages.ai_chat_message_role_generated_label;
                }
                yield AIChatMessages.ai_chat_message_role_user_label;
            }
            case AIMessageType.ASSISTANT -> AIChatMessages.ai_chat_message_role_assistant_label;
            case AIMessageType.FUNCTION -> AIChatMessages.ai_chat_message_role_function_label;
            case AIMessageType.WARNING -> AIChatMessages.ai_chat_message_role_warning_label;
            case AIMessageType.ERROR -> AIChatMessages.ai_chat_message_role_error_label;
            default -> throw new MatchException(null, null);
        };
    }

    @NotNull
    public static DBPImage getRoleIcon(@NotNull AIMessage message) {
        return switch (message.getRole()) {
            case AIMessageType.SYSTEM -> AIChatIcons.SYSTEM;
            case AIMessageType.USER -> {
                if (message.isAutoGenerated()) {
                    yield AIChatIcons.GENERATED;
                }
                yield AIChatIcons.USER;
            }
            case AIMessageType.ASSISTANT, AIMessageType.FUNCTION -> AIChatIcons.ASSISTANT;
            case AIMessageType.WARNING -> DBIcon.STATUS_WARNING;
            case AIMessageType.ERROR -> DBIcon.STATUS_ERROR;
            default -> throw new MatchException(null, null);
        };
    }

    @NotNull
    public static String normalizeConversationCaption(@NotNull String caption) {
        if (caption.contains("```")) {
            caption = caption.replaceAll("```", "");
        }
        if (caption.startsWith("\n")) {
            caption = caption.replaceFirst("\n", "");
        }
        if (caption.contains("\n")) {
            caption = caption.replaceAll("[\\n\\r\\t]", " ");
        }
        return caption;
    }

    public static void updateChatToggleContribution() {
        UIUtils.asyncExec(() -> ActionUtils.fireCommandRefresh((String[])new String[]{"com.dbeaver.ai.chat.toggle"}));
    }
}

