/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.cassandra.model;

import com.datastax.oss.driver.api.core.metadata.schema.FunctionMetadata;
import com.datastax.oss.driver.api.core.type.DataType;
import com.dbeaver.db.cassandra.model.CasKeyspace;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class CasFunction
implements DBSObject,
DBPScriptObject {
    private final CasKeyspace keyspace;
    private final FunctionMetadata metadata;

    public CasFunction(CasKeyspace keyspace, FunctionMetadata metadata) {
        this.keyspace = keyspace;
        this.metadata = metadata;
    }

    @Nullable
    public String getDescription() {
        return this.metadata.getSignature().toString();
    }

    @Nullable
    public CasKeyspace getParentObject() {
        return this.keyspace;
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this.keyspace.getDataSource();
    }

    @Property(viewable=true)
    @NotNull
    public String getName() {
        return this.metadata.getSignature().getName().toString();
    }

    public boolean isPersisted() {
        return true;
    }

    @Property(viewable=true)
    public String getSignature() {
        return this.metadata.getSignature().toString();
    }

    @Property
    public DataType getReturnType() {
        return this.metadata.getReturnType();
    }

    @Property
    public String getLanguage() {
        return this.metadata.getLanguage();
    }

    @NotNull
    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) {
        return this.metadata.getBody();
    }
}

