/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.cassandra.model;

import java.util.Date;
import java.util.EnumSet;
import java.util.UUID;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPIdentifierCase;
import org.jkiss.dbeaver.model.impl.sql.BasicSQLDialect;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class CasCQLDialect
extends BasicSQLDialect {
    public static final CasCQLDialect INSTANCE = new CasCQLDialect();

    @NotNull
    public String getDialectName() {
        return "CQL";
    }

    @NotNull
    public DBPIdentifierCase storesUnquotedCase() {
        return DBPIdentifierCase.LOWER;
    }

    public boolean validIdentifierStart(char c) {
        return SQLUtils.isLatinLetter((int)c) || c == '_';
    }

    public boolean validIdentifierPart(char c, boolean quoted) {
        return SQLUtils.isLatinLetter((int)c) || Character.isDigit(c) || c == '_';
    }

    @NotNull
    public SQLDialect.MultiValueInsertMode getDefaultMultiValueInsertMode() {
        return SQLDialect.MultiValueInsertMode.NOT_SUPPORTED;
    }

    public int getCatalogUsage() {
        return Integer.MAX_VALUE;
    }

    public boolean supportsSubqueries() {
        return false;
    }

    public boolean supportsAliasInSelect() {
        return false;
    }

    public boolean supportsAliasInUpdate() {
        return false;
    }

    public boolean supportsNullability() {
        return false;
    }

    public String getColumnTypeModifiers(DBPDataSource dataSource, @NotNull DBSTypedObject column, @NotNull String typeName, @NotNull DBPDataKind dataKind) {
        if (dataKind == DBPDataKind.STRING || dataKind == DBPDataKind.NUMERIC) {
            return null;
        }
        return super.getColumnTypeModifiers(dataSource, column, typeName, dataKind);
    }

    @NotNull
    public String escapeScriptValue(DBSTypedObject attribute, @NotNull Object value, @NotNull String strValue) {
        if (value instanceof UUID) {
            return strValue;
        }
        if (value instanceof Date) {
            return "'" + strValue + "'";
        }
        return super.escapeScriptValue(attribute, value, strValue);
    }

    public String[] getSingleLineComments() {
        return new String[]{"--", "//"};
    }

    public EnumSet<SQLDialect.ProjectionAliasVisibilityScope> getProjectionAliasVisibilityScope() {
        return EnumSet.of(SQLDialect.ProjectionAliasVisibilityScope.GROUP_BY, SQLDialect.ProjectionAliasVisibilityScope.HAVING);
    }

    public boolean supportsQualifiedColumnNames() {
        return false;
    }
}

