/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.databricks.model.auth;

import com.dbeaver.db.databricks.model.auth.DatabricksU2MAuthCredentials;
import java.util.Properties;
import java.util.UUID;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.access.DBAAuthModel;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class DatabricksU2MAuthModel
implements DBAAuthModel<DatabricksU2MAuthCredentials> {
    @NotNull
    public DatabricksU2MAuthCredentials createCredentials() {
        return new DatabricksU2MAuthCredentials();
    }

    @NotNull
    public DatabricksU2MAuthCredentials loadCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration) {
        DatabricksU2MAuthCredentials credentials = this.createCredentials();
        credentials.setHttpPath(configuration.getAuthProperty("httpPath"));
        return credentials;
    }

    public void saveCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull DatabricksU2MAuthCredentials credentials) {
        configuration.setAuthProperty("httpPath", credentials.getHttpPath());
    }

    public Object initAuthentication(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull DatabricksU2MAuthCredentials credentials, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) {
        String httpPath = credentials.getHttpPath();
        if (CommonUtils.isNotEmpty((String)httpPath)) {
            connProperties.put("transportMode", "http");
            connProperties.put("ssl", "1");
            connProperties.put("httpPath", httpPath);
            connProperties.put("AuthMech", "11");
            connProperties.put("Auth_Flow", "2");
            connProperties.put("EnableTokenCache", "0");
            String randomPassphrase = UUID.randomUUID().toString();
            connProperties.put("TokenCachePassPhrase", randomPassphrase);
        }
        return credentials;
    }

    public void endAuthentication(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) {
    }

    public void refreshCredentials(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull DatabricksU2MAuthCredentials credentials) {
    }
}

