/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.databricks.model.auth;

import com.dbeaver.db.databricks.model.auth.DatabricksM2MAuthCredentials;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.access.DBAAuthModel;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class DatabricksM2MAuthModel
implements DBAAuthModel<DatabricksM2MAuthCredentials> {
    @NotNull
    public DatabricksM2MAuthCredentials createCredentials() {
        return new DatabricksM2MAuthCredentials();
    }

    @NotNull
    public DatabricksM2MAuthCredentials loadCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration) {
        DatabricksM2MAuthCredentials credentials = this.createCredentials();
        credentials.setHttpPath(configuration.getAuthProperty("httpPath"));
        credentials.setClientId(configuration.getAuthProperty("OAuth2ClientId"));
        credentials.setClientSecret(configuration.getAuthProperty("OAuth2Secret"));
        return credentials;
    }

    public void saveCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull DatabricksM2MAuthCredentials credentials) {
        configuration.setAuthProperty("httpPath", credentials.getHttpPath());
        configuration.setAuthProperty("OAuth2ClientId", credentials.getClientId());
        configuration.setAuthProperty("OAuth2Secret", credentials.getClientSecret());
    }

    public Object initAuthentication(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull DatabricksM2MAuthCredentials credentials, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) {
        String clientId = credentials.getClientId();
        String clientSecret = credentials.getClientSecret();
        String httpPath = credentials.getHttpPath();
        if (CommonUtils.isNotEmpty((String)clientId) && CommonUtils.isNotEmpty((String)clientSecret) && CommonUtils.isNotEmpty((String)httpPath)) {
            connProperties.put("transportMode", "http");
            connProperties.put("ssl", "1");
            connProperties.put("httpPath", httpPath);
            connProperties.put("AuthMech", "11");
            connProperties.put("Auth_Flow", "1");
            connProperties.put("OAuth2ClientId", clientId);
            connProperties.put("OAuth2Secret", clientSecret);
        }
        return credentials;
    }

    public void endAuthentication(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) {
    }

    public void refreshCredentials(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull DatabricksM2MAuthCredentials credentials) {
    }
}

