/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.tableau.auth;

import com.dbeaver.model.tableau.auth.TBAuthProfile;
import com.dbeaver.model.tableau.auth.TBConfigurationListener;
import com.dbeaver.model.tableau.tds.TDSConnection;
import com.google.gson.Gson;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class TBAuthConfiguration {
    private static final Log log = Log.getLog(TBAuthConfiguration.class);
    public static final String TABLEAU_PROFILES_JSON = "tableau-profiles.json";
    private static TBAuthConfiguration configuration;
    private static final Gson gson;
    private final List<TBAuthProfile> globalProfiles = new ArrayList<TBAuthProfile>();
    private final transient List<TBConfigurationListener> listeners = new ArrayList<TBConfigurationListener>();

    static {
        gson = new Gson();
    }

    public static synchronized TBAuthConfiguration getConfiguration() {
        if (configuration == null) {
            try {
                String jsonData = DBWorkbench.getPlatform().getConfigurationController().loadConfigurationFile(TABLEAU_PROFILES_JSON);
                configuration = CommonUtils.isEmpty((String)jsonData) ? new TBAuthConfiguration() : (TBAuthConfiguration)gson.fromJson((Reader)new StringReader(jsonData), TBAuthConfiguration.class);
            }
            catch (DBException e) {
                configuration = new TBAuthConfiguration();
                log.error((Object)e);
            }
        }
        return configuration;
    }

    public DBPDataSourceContainer findDataSourceContainerByConnection(TDSConnection tdsConnection) {
        return null;
    }

    public TDSConnection findConnectionByDataSourceContainer(DBPDataSourceContainer dataSource) {
        return null;
    }

    public List<TBAuthProfile> getGlobalProfiles() {
        return new ArrayList<TBAuthProfile>(this.globalProfiles);
    }

    public TBAuthProfile getProfileByName(String name) {
        for (TBAuthProfile profile : this.globalProfiles) {
            if (!name.equals(profile.getName())) continue;
            return profile;
        }
        return null;
    }

    public TBAuthProfile getProfileById(String id) {
        for (TBAuthProfile profile : this.globalProfiles) {
            if (!id.equals(profile.getId())) continue;
            return profile;
        }
        return null;
    }

    public void addProfile(TBAuthProfile profile) throws DBException {
        if (this.getProfileByName(profile.getName()) != null) {
            throw new DBException("Profile '" + profile.getName() + "' already exists");
        }
        this.globalProfiles.add(profile);
        profile.saveCredentials();
        this.saveConfiguration();
        this.fireConfigurationEvent(TBConfigurationListener.Action.ADD, profile);
    }

    public void deleteProfile(TBAuthProfile profile) throws DBException {
        if (this.globalProfiles.remove(profile)) {
            profile.deleteCredentials();
            this.saveConfiguration();
            this.fireConfigurationEvent(TBConfigurationListener.Action.DELETE, profile);
        }
    }

    public void updateProfile(TBAuthProfile profile) throws DBException {
        profile.saveCredentials();
        this.saveConfiguration();
        this.fireConfigurationEvent(TBConfigurationListener.Action.UPDATE, profile);
    }

    public void saveConfiguration() throws DBException {
        String jsonData = gson.toJson((Object)this, TBAuthConfiguration.class);
        DBWorkbench.getPlatform().getConfigurationController().saveConfigurationFile(TABLEAU_PROFILES_JSON, jsonData);
    }

    public void addListener(TBConfigurationListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(TBConfigurationListener listener) {
        this.listeners.remove(listener);
    }

    private void fireConfigurationEvent(TBConfigurationListener.Action action, TBAuthProfile profile) {
        for (TBConfigurationListener listener : this.listeners) {
            listener.profileAction(action, profile);
        }
    }
}

