/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.tableau;

import com.dbeaver.model.tableau.TBObject;
import com.dbeaver.model.tableau.TBProject;
import com.dbeaver.model.tableau.TBSite;
import com.dbeaver.model.tableau.rest.api.WorkbookType;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.meta.Property;

public class TBWorkbook
implements TBObject {
    private static final Log log = Log.getLog(TBWorkbook.class);
    private final TBSite site;
    private final WorkbookType workbook;
    private final TBProject project;

    public TBWorkbook(TBSite site, WorkbookType workbook, TBProject project) {
        this.site = site;
        this.workbook = workbook;
        this.project = project;
    }

    public TBSite getSite() {
        return this.site;
    }

    @Override
    @Property(order=1)
    public String getId() {
        return this.workbook.getId();
    }

    @Property(order=2, viewable=true)
    @NotNull
    public String getName() {
        return this.workbook.getName();
    }

    @Property(order=30)
    @Nullable
    public String getDescription() {
        return this.workbook.getDescription();
    }

    @Property(order=10, href=true)
    @Nullable
    public String getWebpageURL() {
        return this.workbook.getWebpageUrl();
    }

    @Property(order=12, viewable=true)
    @Nullable
    public String getCreatedAt() {
        return String.valueOf(this.workbook.getCreatedAt());
    }

    @Property(order=13, viewable=true)
    @Nullable
    public String getUpdatedAt() {
        return String.valueOf(this.workbook.getUpdatedAt());
    }

    @Property(order=20)
    public TBProject getProject() {
        return this.project;
    }

    public WorkbookType getWorkbookType() {
        return this.workbook;
    }
}

