/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.tableau;

import com.dbeaver.model.tableau.TBObject;
import com.dbeaver.model.tableau.TBVirtualConnection;
import com.dbeaver.model.tableau.rest.api.VirtualConnectionSourceConnectionType;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.meta.Property;

public class TBVirtualConnectionDatabase
implements TBObject {
    private static final Log log = Log.getLog(TBVirtualConnectionDatabase.class);
    private final TBVirtualConnection virtualConnection;
    private final VirtualConnectionSourceConnectionType connectionType;

    public TBVirtualConnectionDatabase(TBVirtualConnection virtualConnection, VirtualConnectionSourceConnectionType connectionType) {
        this.virtualConnection = virtualConnection;
        this.connectionType = connectionType;
    }

    public TBVirtualConnection getVirtualConnection() {
        return this.virtualConnection;
    }

    public VirtualConnectionSourceConnectionType getConnectionType() {
        return this.connectionType;
    }

    @Override
    @Property(order=1)
    public String getId() {
        return this.connectionType.getConnectionId();
    }

    @NotNull
    public String getName() {
        return this.getServerName();
    }

    @Property(order=10, viewable=true)
    @NotNull
    public String getDbClass() {
        return this.connectionType.getDbClass();
    }

    @Property(order=11, viewable=true)
    @NotNull
    public String getServerName() {
        return this.connectionType.getServer();
    }

    @Property(order=12, viewable=true)
    @Nullable
    public String getServerPort() {
        return this.connectionType.getPort() == null ? null : String.valueOf(this.connectionType.getPort());
    }

    @Property(order=13, viewable=true)
    @Nullable
    public String getDatabase() {
        return this.connectionType.getDatabase();
    }

    @Property(order=14)
    @NotNull
    public String getUsername() {
        return this.connectionType.getUsername();
    }

    @Nullable
    public String getDescription() {
        return null;
    }
}

