/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.tableau;

import com.dbeaver.model.tableau.TBObject;
import com.dbeaver.model.tableau.TBProject;
import com.dbeaver.model.tableau.TBSession;
import com.dbeaver.model.tableau.TBSite;
import com.dbeaver.model.tableau.TBWorkbook;
import com.dbeaver.model.tableau.rest.api.ViewType;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;

public class TBView
implements TBObject {
    private static final Log log = Log.getLog(TBView.class);
    private final TBSite site;
    private final TBProject project;
    private ViewType viewType;
    private transient boolean detailsLoaded;

    public TBView(TBSite site, ViewType viewType, TBProject project) {
        this.site = site;
        this.viewType = viewType;
        this.project = project;
    }

    public TBSite getSite() {
        return this.site;
    }

    public TBSession getSession() {
        return this.site.getSession();
    }

    @Override
    @Property(order=1)
    public String getId() {
        return this.viewType.getId();
    }

    @Property(order=2, viewable=true)
    @NotNull
    public String getName() {
        return this.viewType.getName();
    }

    @Property(order=30)
    @Nullable
    public String getDescription() {
        try {
            TBWorkbook workbook = this.site.getWorkbook((DBRProgressMonitor)new VoidProgressMonitor(), this.viewType.getWorkbook().getId());
            if (workbook == null) {
                return "Tableau view '" + this.getName() + "'";
            }
            return "Tableau workbook '" + workbook.getName() + "' view '" + this.getName() + "'";
        }
        catch (DBException e) {
            return e.getMessage();
        }
    }

    @Property(order=10)
    @Nullable
    public String getContentURL() {
        return this.viewType.getContentUrl();
    }

    @Property(order=11)
    @Nullable
    public String getViewUrlName() {
        return this.viewType.getViewUrlName();
    }

    @Property(order=12, viewable=true)
    @Nullable
    public String getCreatedAt() {
        return String.valueOf(this.viewType.getCreatedAt());
    }

    @Property(order=13, viewable=true)
    @Nullable
    public String getUpdatedAt() {
        return String.valueOf(this.viewType.getUpdatedAt());
    }

    @Property(order=20)
    public TBProject getProject() {
        return this.project;
    }

    @Property(order=5, href=true)
    public String getViewURL() throws DBException {
        return this.getViewURL(false);
    }

    public String getViewURL(boolean embedded) throws DBException {
        TBWorkbook workbook = this.site.getWorkbook((DBRProgressMonitor)new VoidProgressMonitor(), this.viewType.getWorkbook().getId());
        if (workbook == null) {
            throw new DBException("Cannot find view workbook " + this.viewType.getWorkbook().getId());
        }
        return this.getSession().getAuthProfile().getSiteURL() + "/#/site/" + this.getSite().getName() + "/views/" + workbook.getWorkbookType().getContentUrl() + "/" + this.viewType.getViewUrlName() + (embedded ? this.getEmbeddedViewParameters() : "");
    }

    private String getEmbeddedViewParameters() {
        return "?iframeSizedToWindow=true&:embed=y&:showAppBanner=false&:showVizHome=no&:refresh=yes&:tabs=no&:toolbar=no";
    }

    public ViewType getViewType() {
        return this.viewType;
    }

    @Override
    public boolean needsDetails() {
        return !this.detailsLoaded;
    }

    @Override
    public void loadDetails(DBRProgressMonitor monitor) throws DBException {
        this.viewType = this.site.executeRequest(monitor, "views/" + this.viewType.getId()).getView();
        this.detailsLoaded = true;
    }

    public String toString() {
        return this.viewType.getName() + " (" + this.viewType.getContentUrl() + ")";
    }
}

